/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.ConnectionSetting;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.JDBCObjectFactory;
import com.vertica.jdbc.SConnection;
import com.vertica.jdbc.SWarningListener;
import com.vertica.security.LocalIntegratedSecurityManager;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.SettingReader;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ExceptionUtilities;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.PropertyTypeConverter;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConnectionFactory {
    public static final String URL_SEPARATOR = ":";
    public static final String CONNECTION_LOCALE_KEY = "Locale";

    protected final boolean acceptsURL(String string, Properties properties) {
        try {
            String string2 = this.getSubProtocol();
            if (null == string2) {
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, URL_SEPARATOR);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if ("jdbc".equals(string3) && string2.equals(string4)) {
                int n = string.indexOf(string2) + string2.length() + 1;
                String string5 = "";
                if (n < string.length()) {
                    string5 = string.substring(n);
                }
                SettingReader.clearAllSettings();
                if (SettingReader.isSuccessfulLoad()) {
                    properties.putAll((Map<?, ?>)SettingReader.retrieveAllSettings());
                }
                return this.parseSubName(string5, properties);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    protected JDBCObjectFactory createJDBCObjectFactory() {
        return new JDBCObjectFactory();
    }

    protected SConnection doConnect(Pair<IConnection, ConnSettingRequestMap> pair, String string) throws SQLException {
        assert (null != pair);
        IConnection iConnection = pair.key();
        IWarningListener iWarningListener = iConnection.getWarningListener();
        try {
            if (null == JDBCObjectFactory.getInstance()) {
                JDBCObjectFactory.setInstance(this.createJDBCObjectFactory());
            }
            ConnSettingResponseMap connSettingResponseMap = null;
            if (null == iWarningListener) {
                iWarningListener = new SWarningListener(iConnection.getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
                iConnection.registerWarningListener(iWarningListener);
            }
            connSettingResponseMap = iConnection.updateConnectionSettings(pair.value());
            this.checkResponseMap(connSettingResponseMap, iWarningListener);
            iConnection.connect(pair.value());
            for (Warning warning : iWarningListener.getWarnings()) {
                LogUtilities.logWarning(warning.getMessage(), DSIDriverSingleton.getInstance().getDriverLog());
            }
            return JDBCObjectFactory.getInstance().createConnection(iConnection, string);
        }
        catch (Exception exception) {
            ILogger iLogger = null;
            try {
                iLogger = pair.key().getConnectionLog();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (null == iLogger) {
                throw ExceptionConverter.toSQLException(exception, iWarningListener);
            }
            throw ExceptionConverter.toSQLException(exception, iWarningListener, iLogger);
        }
    }

    protected Pair<IConnection, ConnSettingRequestMap> getConnection(Properties properties) throws SQLException {
        assert (null != properties);
        IDriver iDriver = DSIDriverSingleton.getInstance();
        SWarningListener sWarningListener = new SWarningListener(iDriver.getMessageSource(), FunctionID.BEFORE_CONNECTION);
        try {
            Object object;
            ILogger iLogger;
            this.mapJDBCtoODBCAuthentication(properties);
            this.saveLoggingAttributes(properties);
            PrintWriter printWriter = DriverManager.getLogWriter();
            if (null != printWriter) {
                SettingReader.storeAdditionalSetting("LogPrintWriter", printWriter);
            }
            if ((iLogger = iDriver.getDriverLog()) instanceof DSILogger) {
                ((DSILogger)iLogger).prepareSettings(((DSILogger)iLogger).getFileName());
            }
            IConnection iConnection = null;
            try {
                char c = iDriver.getProperty(20).getChar();
                object = iDriver.createEnvironment();
                object.registerWarningListener(sWarningListener);
                iConnection = (long)c == 1L ? object.createConnection(new LocalIntegratedSecurityManager(iLogger)) : object.createConnection();
            }
            catch (Exception exception) {
                try {
                    throw ExceptionConverter.toSQLException(exception, sWarningListener, iLogger);
                }
                catch (Exception exception2) {
                    throw exception;
                }
            }
            ConnSettingRequestMap connSettingRequestMap = PropertyTypeConverter.toConnSettingRequestMap(properties);
            SettingReader.storeSettings(properties);
            if (connSettingRequestMap.containsKey(CONNECTION_LOCALE_KEY)) {
                object = connSettingRequestMap.getProperty(CONNECTION_LOCALE_KEY);
                iConnection.setLocale(ExceptionUtilities.createLocale(((Variant)object).getString()));
            }
            return new Pair<IConnection, ConnSettingRequestMap>(iConnection, connSettingRequestMap);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, sWarningListener);
        }
    }

    protected abstract String getSubProtocol();

    protected abstract boolean parseSubName(String var1, Properties var2);

    private void checkResponseMap(ConnSettingResponseMap connSettingResponseMap, IWarningListener iWarningListener) throws SQLException {
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Iterator<String> iterator = connSettingResponseMap.getKeysIterator();
        while (iterator.hasNext()) {
            charSequence = iterator.next();
            ConnectionSetting connectionSetting = connSettingResponseMap.getProperty((String)charSequence);
            if (connectionSetting.isRequired()) {
                arrayList.add((String)charSequence);
                continue;
            }
            if (connectionSetting.isOptional()) {
                arrayList2.add((String)charSequence);
                continue;
            }
            arrayList3.add((String)charSequence);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        charSequence = new StringBuilder(JDBCMessageBuilder.getMessage(JDBCMessageKey.REQUIRED_KEYS_MSG, iWarningListener, false, false));
        ((StringBuilder)charSequence).append(": ");
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((StringBuilder)charSequence).append(iterator.next());
            if (!iterator.hasNext()) continue;
            ((StringBuilder)charSequence).append(", ");
        }
        if (!arrayList2.isEmpty()) {
            ((StringBuilder)charSequence).append("; ");
            ((StringBuilder)charSequence).append(JDBCMessageBuilder.getMessage(JDBCMessageKey.OPTIONAL_KEYS_MSG, iWarningListener, false, false));
            ((StringBuilder)charSequence).append(": ");
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(iterator.next());
                if (!iterator.hasNext()) continue;
                ((StringBuilder)charSequence).append(", ");
            }
        }
        if (!arrayList3.isEmpty()) {
            ((StringBuilder)charSequence).append("; ");
            ((StringBuilder)charSequence).append(JDBCMessageBuilder.getMessage(JDBCMessageKey.PROCESSED_KEYS_MSG, iWarningListener, false, false));
            ((StringBuilder)charSequence).append(": ");
            iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(iterator.next());
                if (!iterator.hasNext()) continue;
                ((StringBuilder)charSequence).append(", ");
            }
        }
        throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.CONNECTION_REFUSED, iWarningListener, ((StringBuilder)charSequence).toString());
    }

    private void mapJDBCtoODBCAuthentication(Properties properties) {
        Object object;
        IDriver iDriver = DSIDriverSingleton.getInstance();
        assert (null != iDriver);
        try {
            object = iDriver.getProperty(1000);
            if (1 != ((Variant)object).getShort()) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        object = properties.keys();
        while (object.hasMoreElements()) {
            String string;
            String string2 = (String)object.nextElement();
            if (string2.equalsIgnoreCase("USER")) {
                string = properties.getProperty(string2);
                properties.remove(string2);
                properties.setProperty("UID", string);
                continue;
            }
            if (!string2.equalsIgnoreCase("PASSWORD")) continue;
            string = properties.getProperty(string2);
            properties.remove(string2);
            properties.setProperty("PWD", string);
        }
    }

    private void saveLoggingAttributes(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.regionMatches(true, 0, "log", 0, 3)) continue;
            SettingReader.storeSetting(string, properties.get(string).toString());
        }
    }
}

