/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.dsi.core.impl.DSIDriverFactory;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.BaseConnectionFactory;
import com.vertica.jdbc.SWarningListener;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.SettingReader;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.PropertyTypeConverter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class AbstractDriver
extends BaseConnectionFactory
implements Driver {
    private static final String VERSION_SEPARATOR = ".";
    public static final String URL_PROTOCOL = "jdbc";
    private static boolean s_isInitialized = false;
    private static String s_messageComponentName = "[JDBC Driver]";
    private SWarningListener m_warningListener;

    public static String getErrorMessageComponentName() {
        return s_messageComponentName;
    }

    public static void initialize(AbstractDriver abstractDriver, String string) throws SQLException {
        DSIDriverFactory.setDriverClassName(string);
        try {
            DriverManager.registerDriver(abstractDriver);
            s_isInitialized = true;
        }
        catch (SQLException sQLException) {
            throw JDBCMessageBuilder.createSQLException("HY000", "A database access error occurred while registering the driver", 0);
        }
    }

    public static void setErrorMessageComponentName(String string) {
        s_messageComponentName = "[" + string + "]";
    }

    public AbstractDriver() {
        SettingReader.loadSimbaSettings();
    }

    public final boolean acceptsURL(String string) {
        return this.acceptsURL(string, new Properties());
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        if (null != properties) {
            this.copyProperties(properties2, properties);
        }
        this.doInitialize();
        if (!this.acceptsURL(string, properties2)) {
            return null;
        }
        Pair<IConnection, ConnSettingRequestMap> pair = this.getConnection(properties2);
        return this.doConnect(pair, string);
    }

    public int getMajorVersion() {
        int n = 1;
        try {
            this.doInitialize();
            IDriver iDriver = DSIDriverSingleton.getInstance();
            Variant variant = iDriver.getProperty(5);
            if (null == variant.getString()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_VERSION, this.m_warningListener, variant.getString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(variant.getString(), VERSION_SEPARATOR);
            String string = stringTokenizer.nextToken();
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public int getMinorVersion() {
        int n = 0;
        try {
            this.doInitialize();
            IDriver iDriver = DSIDriverSingleton.getInstance();
            Variant variant = iDriver.getProperty(5);
            if (null == variant.getString()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_VERSION, this.m_warningListener, variant.getString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(variant.getString(), VERSION_SEPARATOR);
            stringTokenizer.nextToken();
            String string = stringTokenizer.nextToken();
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        if (null != properties) {
            this.copyProperties(properties2, properties);
        }
        this.doInitialize();
        if (!this.acceptsURL(string, properties2)) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_URL, this.m_warningListener, new Object[0]);
        }
        try {
            Pair<IConnection, ConnSettingRequestMap> pair = this.getConnection(properties2);
            IConnection iConnection = pair.key();
            IWarningListener iWarningListener = iConnection.getWarningListener();
            ConnSettingResponseMap connSettingResponseMap = null;
            if (null == iWarningListener) {
                iWarningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
                iConnection.registerWarningListener(iWarningListener);
            }
            connSettingResponseMap = iConnection.updateConnectionSettings(pair.value());
            for (Warning warning : iWarningListener.getWarnings()) {
                LogUtilities.logWarning(warning.getMessage(), DSIDriverSingleton.getInstance().getDriverLog());
            }
            iConnection.close();
            SettingReader.clearAllSettings();
            return PropertyTypeConverter.toDriverPropertyInfo(connSettingResponseMap);
        }
        catch (Exception exception) {
            SettingReader.clearAllSettings();
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener);
        }
    }

    public boolean jdbcCompliant() {
        return false;
    }

    private void copyProperties(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, properties2.get(string));
        }
    }

    private void doInitialize() throws SQLException {
        if (!s_isInitialized) {
            throw JDBCMessageBuilder.createSQLException("HY000", "Class has not been initialized. Please initialize by calling AbstractDriver.initialize()", 0);
        }
        if (null == DSIDriverSingleton.getInstance()) {
            try {
                DSIDriverSingleton.setInstance(DSIDriverFactory.createDriver());
                this.m_warningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), FunctionID.BEFORE_CONNECTION);
            }
            catch (ErrorException errorException) {
                throw new SQLException(errorException.getLocalizedMessage());
            }
        }
    }
}

