/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.VDriver;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import com.vertica.localization.VMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import java.io.FileOutputStream;
import java.io.IOException;

public final class WriteFileResponseMessage
extends ResponseMessage {
    private String m_fileName;
    private long[] m_rejects;
    private boolean m_isReturnRejected;
    private int m_fileLength;
    private DSILogger m_log;
    private int test;

    public WriteFileResponseMessage(VStream vStream, DSILogger dSILogger) {
        super(vStream);
        this.m_log = dSILogger;
    }

    protected void buildMessage(int n) throws IOException {
        this.test = n;
        this.m_fileName = this.m_vStream.ReceiveString();
        this.m_fileLength = this.m_vStream.ReceiveIntegerR(4);
        if (this.m_fileName.equals("")) {
            this.m_isReturnRejected = true;
            assert (this.m_fileLength % 8 == 0);
            int n2 = this.m_fileLength / 8;
            this.m_rejects = new long[n2];
            for (int i = 0; i < n2; ++i) {
                this.m_rejects[i] = this.m_vStream.RecieveLongLE();
            }
        }
    }

    public void writeToDisk() throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.m_log, this.m_fileName);
        byte[] byArray = this.m_vStream.getCopyBuffer();
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            fileOutputStream = new FileOutputStream(this.m_fileName, true);
            for (n = this.m_fileLength; n > 0; n -= n2) {
                n2 = byArray.length;
                if (n < byArray.length) {
                    n2 = n;
                }
                this.m_vStream.Receive(byArray, 0, n2);
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.close();
            fileOutputStream = null;
            LogUtilities.logInfo("Succesfully wrote " + this.m_fileLength + " bytes to copy result file " + this.m_fileName, (ILogger)this.m_log);
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException2) {
                LogUtilities.logError(iOException2, (ILogger)this.m_log);
            }
            try {
                this.m_vStream.skip(n);
            }
            catch (IOException iOException3) {
                LogUtilities.logError(iOException3, (ILogger)this.m_log);
            }
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_WRITING_COPY_FILE.toString(), new String[]{this.m_fileName}, (Throwable)iOException);
        }
    }

    public boolean usingReturnRejectedFormat() {
        return this.m_isReturnRejected;
    }

    public long[] getReturnRejectedRows() {
        return this.m_rejects;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public Object[] getDebugInfo() {
        return new Object[]{this.getType(), "File: " + ("".equals(this.m_fileName) ? "RETURNREJECTED" : this.m_fileName)};
    }

    public MessageType getType() {
        return MessageType.WriteFile;
    }
}

