/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.VConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

class VStream {
    private final String host;
    private final int port;
    private Socket connection;
    private InputStream input;
    private OutputStream output;
    private byte[] streamBuffer;
    private VConnection m_connection;
    private byte[] byte_buf = new byte[8192];

    VStream(VConnection vConnection) throws IOException {
        this.host = vConnection.getServer();
        this.port = vConnection.getPort();
        this.m_connection = vConnection;
        int n = vConnection.getLoginTimeout() * 1000;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        Socket socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
        socket.connect(inetSocketAddress, n);
        this.changeSocket(socket);
    }

    public Socket getSocket() {
        return this.connection;
    }

    void changeSocket(Socket socket) throws IOException {
        this.connection = socket;
        this.connection.setTcpNoDelay(true);
        this.connection.setKeepAlive(true);
        this.input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
    }

    void SendChar(int n) throws IOException {
        this.output.write((byte)n);
    }

    void SendInteger8(long l) throws IOException {
        this.output.write((int)(l >>> 56));
        this.output.write((int)(l >>> 48));
        this.output.write((int)(l >>> 40));
        this.output.write((int)(l >>> 32));
        this.output.write((int)(l >>> 24));
        this.output.write((int)(l >>> 16));
        this.output.write((int)(l >>> 8));
        this.output.write((int)l);
    }

    void SendInteger4(int n) throws IOException {
        this.output.write(n >>> 24);
        this.output.write(n >>> 16);
        this.output.write(n >>> 8);
        this.output.write(n);
    }

    void SendInteger2(int n) throws IOException {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IOException("Tried to send an out-of-range integer as a 2-byte value: " + n);
        }
        this.output.write(n >>> 8);
        this.output.write(n);
    }

    void Send(byte[] byArray) throws IOException {
        this.output.write(byArray);
    }

    void Send(byte[] byArray, int n) throws IOException {
        this.Send(byArray, 0, n);
    }

    void Send(byte[] byArray, int n, int n2) throws IOException {
        this.output.write(byArray, n, byArray.length - n < n2 ? byArray.length - n : n2);
        if (byArray.length - n < n2) {
            for (int i = byArray.length - n; i < n2; ++i) {
                this.output.write(0);
            }
        }
    }

    int ReceiveChar() throws IOException {
        int n = this.input.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    int ReceiveIntegerR(int n) throws IOException {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.input.read();
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 = n3 | n2 << 8;
        }
        switch (n) {
            case 1: {
                return (byte)n2;
            }
            case 2: {
                return (short)n2;
            }
        }
        return n2;
    }

    long ReceiveLong() throws IOException {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = this.input.read();
            if (n < 0) {
                throw new EOFException();
            }
            l = (long)n | l << 8;
        }
        return l;
    }

    long RecieveLongLE() throws IOException {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = this.input.read();
            if (n < 0) {
                throw new EOFException();
            }
            l = (long)(n << i * 8) + l;
        }
        return l;
    }

    String ReceiveString(int n) throws IOException {
        if (n > this.byte_buf.length) {
            this.byte_buf = new byte[n];
        }
        this.Receive(this.byte_buf, 0, n);
        return new String(this.byte_buf, 0, n, VConnection.VERTICA_CHARSET);
    }

    String ReceiveString() throws IOException {
        int n = 0;
        byte[] byArray = this.byte_buf;
        int n2 = byArray.length;
        while (true) {
            int n3;
            if ((n3 = this.input.read()) < 0) {
                throw new EOFException();
            }
            if (n3 == 0) break;
            if (n == n2) {
                if ((n2 *= 2) <= 0) {
                    throw new IOException("Impossibly long string");
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray = byArray2;
            }
            byArray[n++] = (byte)n3;
        }
        return new String(byArray, 0, n, VConnection.VERTICA_CHARSET);
    }

    void Receive(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.input.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public void skip(long l) throws IOException {
        this.input.skip(l);
    }

    public byte[] getCopyBuffer() {
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        return this.streamBuffer;
    }

    void flush() throws IOException {
        this.output.flush();
    }

    void close() throws IOException {
        this.output.close();
        this.input.close();
        this.connection.close();
    }

    protected final VConnection getConnection() {
        return this.m_connection;
    }
}

