/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadAuthException;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.io.AuthCryptResponseMessage;
import com.vertica.io.AuthMD5ResponseMessage;
import com.vertica.io.AuthOkResponseMessage;
import com.vertica.io.AuthPasswordChangedResponseMessage;
import com.vertica.io.AuthPasswordExpiredResponseMessage;
import com.vertica.io.AuthPasswordGraceResponseMessage;
import com.vertica.io.AuthPasswordResponseMessage;
import com.vertica.io.AuthSCMResponseMessage;
import com.vertica.io.BindCompleteResponseMessage;
import com.vertica.io.CloseCompleteResponseMessage;
import com.vertica.io.CommandCompleteResponseMessage;
import com.vertica.io.CommandDescriptionResponseMessage;
import com.vertica.io.CopyDataResponseMessage;
import com.vertica.io.CopyDoneResponseMessage;
import com.vertica.io.CopyInResponseMessage;
import com.vertica.io.DataRowResponseMessage;
import com.vertica.io.EmptyQueryResponseMessage;
import com.vertica.io.EndOfBatchResponseMessage;
import com.vertica.io.ErrorResponseMessage;
import com.vertica.io.KeyDataResponseMessage;
import com.vertica.io.LoadFileResponseMessage;
import com.vertica.io.MessageType;
import com.vertica.io.NoDataResponseMessage;
import com.vertica.io.NoticeResponseMessage;
import com.vertica.io.NotificationResponseMessage;
import com.vertica.io.ParameterDescriptionResponseMessage;
import com.vertica.io.ParameterStatusResponseMessage;
import com.vertica.io.ParseCompleteResponseMessage;
import com.vertica.io.PortalSuspendedResponseMessage;
import com.vertica.io.ReadyForQueryResponseMessage;
import com.vertica.io.RequestMessage;
import com.vertica.io.ResponseMessage;
import com.vertica.io.RowDescriptionResponseMessage;
import com.vertica.io.SSLRequestMessage;
import com.vertica.io.VStream;
import com.vertica.io.VerifyFilesResponseMessage;
import com.vertica.io.WriteFileResponseMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.util.ServerErrorData;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import javax.net.ssl.SSLSocketFactory;

public class ProtocolStream {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_CHANGE_PASSWORD = 9;
    private static final int AUTH_REQ_PASSWORD_CHANGED = 10;
    private static final int AUTH_REQ_PASSWORD_GRACE = 11;
    private VConnection m_connection;
    private VStream m_vStream;
    private DSILogger m_log;
    private Queue<ResponseMessage> m_incomingQueue;
    private boolean m_isClosed;
    private boolean m_hasOutgoingMessage;
    private boolean m_initComplete;
    private IWarningListener m_currentWarningListener;

    public ProtocolStream(VConnection vConnection) throws GeneralException {
        this.m_connection = vConnection;
        this.m_log = vConnection.getConnectionLog();
        this.m_incomingQueue = new LinkedList<ResponseMessage>();
        try {
            this.m_vStream = new VStream(this.m_connection);
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
            this.m_isClosed = true;
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_CONNECTION_FAILED.toString(), new String[]{vConnection.getServer(), vConnection.getPort() + "", iOException.getLocalizedMessage()}, (Throwable)iOException);
        }
    }

    public void enableSSL() throws BadAuthException, GeneralException {
        try {
            this.sendMessage(new SSLRequestMessage());
            this.m_vStream.flush();
            int n = this.m_vStream.ReceiveChar();
            switch (n) {
                case 83: {
                    SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    Socket socket = sSLSocketFactory.createSocket(this.m_vStream.getSocket(), this.m_connection.getServer(), this.m_connection.getPort(), true);
                    this.m_vStream.changeSocket(socket);
                    break;
                }
                default: {
                    throw new BadAuthException(101, VMessageKey.ERROR_SSL_STARTUP_FAILED.toString(), "");
                }
            }
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.NETWORK_ERROR_GENERAL.toString(), new String[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    public void sendMessage(RequestMessage requestMessage) throws GeneralException {
        this.ensureOpen();
        try {
            if (this.m_log.isEnabled() && !requestMessage.getType().equals((Object)MessageType.ClientCopyData)) {
                LogUtilities.logDebug("FE => " + Arrays.toString(requestMessage.getDebugInfo()), (ILogger)this.m_log);
            }
            requestMessage.send(this.m_vStream);
            this.m_hasOutgoingMessage = true;
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.NETWORK_ERROR_GENERAL.toString(), new String[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    public void putBack(ResponseMessage responseMessage) {
        this.m_incomingQueue.add(responseMessage);
    }

    public boolean hasQueuedMessage() {
        return !this.m_incomingQueue.isEmpty();
    }

    public ResponseMessage readMessage() throws GeneralException {
        this.ensureOpen();
        try {
            ResponseMessage responseMessage;
            if (this.m_hasOutgoingMessage) {
                this.m_vStream.flush();
                this.m_hasOutgoingMessage = false;
            }
            if ((responseMessage = this.m_incomingQueue.poll()) != null) {
                return responseMessage;
            }
            int n = this.m_vStream.ReceiveChar();
            int n2 = this.m_vStream.ReceiveIntegerR(4);
            block1 : switch (n) {
                case 49: {
                    responseMessage = new ParseCompleteResponseMessage(this.m_vStream);
                    break;
                }
                case 50: {
                    responseMessage = new BindCompleteResponseMessage(this.m_vStream);
                    break;
                }
                case 51: {
                    responseMessage = new CloseCompleteResponseMessage(this.m_vStream);
                    break;
                }
                case 65: {
                    responseMessage = new NotificationResponseMessage(this.m_vStream);
                    break;
                }
                case 99: {
                    responseMessage = new CopyDoneResponseMessage(this.m_vStream);
                    break;
                }
                case 67: {
                    responseMessage = new CommandCompleteResponseMessage(this.m_vStream);
                    break;
                }
                case 109: {
                    responseMessage = new CommandDescriptionResponseMessage(this.m_vStream);
                    break;
                }
                case 100: {
                    responseMessage = new CopyDataResponseMessage(this.m_vStream);
                    break;
                }
                case 68: {
                    responseMessage = new DataRowResponseMessage(this.m_vStream);
                    break;
                }
                case 69: {
                    responseMessage = new ErrorResponseMessage(this.m_connection, this.m_vStream, this.m_connection.getConnectionLog());
                    break;
                }
                case 70: {
                    responseMessage = new VerifyFilesResponseMessage(this.m_vStream);
                    break;
                }
                case 72: {
                    responseMessage = new LoadFileResponseMessage(this.m_vStream);
                    break;
                }
                case 71: {
                    responseMessage = new CopyInResponseMessage(this.m_vStream);
                    break;
                }
                case 73: {
                    responseMessage = new EmptyQueryResponseMessage(this.m_vStream);
                    break;
                }
                case 74: {
                    responseMessage = new EndOfBatchResponseMessage(this.m_vStream);
                    break;
                }
                case 75: {
                    responseMessage = new KeyDataResponseMessage(this.m_vStream);
                    break;
                }
                case 78: {
                    responseMessage = new NoticeResponseMessage(this.m_connection, this.m_vStream, this.m_connection.getConnectionLog());
                    break;
                }
                case 110: {
                    responseMessage = new NoDataResponseMessage(this.m_vStream);
                    break;
                }
                case 79: {
                    responseMessage = new WriteFileResponseMessage(this.m_vStream, this.m_connection.getConnectionLog());
                    break;
                }
                case 82: {
                    int n3 = this.m_vStream.ReceiveIntegerR(4);
                    n2 -= 4;
                    switch (n3) {
                        case 0: {
                            responseMessage = new AuthOkResponseMessage(this.m_vStream);
                            break block1;
                        }
                        case 1: 
                        case 2: {
                            throw new IOException("Protocol error.  Kerberos not supported.");
                        }
                        case 3: {
                            responseMessage = new AuthPasswordResponseMessage(this.m_vStream);
                            break block1;
                        }
                        case 4: {
                            responseMessage = new AuthCryptResponseMessage(this.m_vStream);
                            break block1;
                        }
                        case 5: {
                            responseMessage = new AuthMD5ResponseMessage(this.m_vStream);
                            break block1;
                        }
                        case 6: {
                            responseMessage = new AuthSCMResponseMessage(this.m_vStream);
                            break block1;
                        }
                        case 9: {
                            responseMessage = new AuthPasswordExpiredResponseMessage(this.m_vStream);
                            break block1;
                        }
                        case 10: {
                            responseMessage = new AuthPasswordChangedResponseMessage(this.m_vStream);
                            break block1;
                        }
                        case 11: {
                            responseMessage = new AuthPasswordGraceResponseMessage(this.m_vStream);
                            break block1;
                        }
                    }
                    LogUtilities.logError("Unsupported auth message subtype: " + (char)n3, (ILogger)this.m_log);
                    throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNKNOWN_TYPE.toString(), (char)n + ":" + (char)n3);
                }
                case 115: {
                    responseMessage = new PortalSuspendedResponseMessage(this.m_vStream);
                    break;
                }
                case 83: {
                    responseMessage = new ParameterStatusResponseMessage(this.m_vStream);
                    break;
                }
                case 116: {
                    responseMessage = new ParameterDescriptionResponseMessage(this.m_vStream);
                    break;
                }
                case 84: {
                    responseMessage = new RowDescriptionResponseMessage(this.m_vStream);
                    break;
                }
                case 90: {
                    responseMessage = new ReadyForQueryResponseMessage(this.m_vStream);
                    break;
                }
                default: {
                    LogUtilities.logError("Unexpected message type: " + (char)n, (ILogger)this.m_log);
                    throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNKNOWN_TYPE.toString(), (char)n + "");
                }
            }
            responseMessage.buildMessage(n2 - 4);
            responseMessage.m_length = n2;
            if (n == 82) {
                responseMessage.m_length += 4;
            }
            if (this.m_log.isEnabled() && n != 68) {
                LogUtilities.logDebug("BE <= " + Arrays.toString(responseMessage.getDebugInfo()), (ILogger)this.m_log);
            }
            switch (responseMessage.getType()) {
                case ParameterStatus: {
                    this.handleParameterStatus((ParameterStatusResponseMessage)responseMessage);
                    responseMessage = this.readMessage();
                    break;
                }
                case Notice: {
                    this.handleNotice((NoticeResponseMessage)responseMessage);
                    responseMessage = this.readMessage();
                }
            }
            return responseMessage;
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.NETWORK_ERROR_GENERAL.toString(), new String[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    private void handleParameterStatus(ParameterStatusResponseMessage parameterStatusResponseMessage) {
        block16: {
            String string = parameterStatusResponseMessage.getParameterName();
            String string2 = parameterStatusResponseMessage.getParameterValue();
            LogUtilities.logInfo("Session parameter " + string + " set to " + string2, (ILogger)this.m_log);
            if (string.equals("standard_conforming_strings")) {
                this.m_connection.setUseStandardConformingStrings(string2.equals("on"));
            } else if (string.equals("server_version")) {
                this.m_connection.setServerVersion(string2);
            } else if (string.equals("client_locale")) {
                try {
                    this.m_connection.setServerLocale(string2, false);
                }
                catch (ErrorException errorException) {}
            } else if (string.equals("long_string_types")) {
                this.m_connection.setLongStringsEnabled(string2.equals("on"));
            } else if (string.equals("auto_commit")) {
                try {
                    boolean bl;
                    boolean bl2 = string2.equals("on");
                    boolean bl3 = bl = this.m_connection.getProperty(19).getLong() == 1L;
                    if (bl2 && !bl || !bl2 && bl) {
                        Variant variant = new Variant(3, bl2 ? 1L : 0L);
                        this.m_connection.setPropertySDKOnly(19, variant);
                    }
                }
                catch (UtilsException utilsException) {
                    assert (false);
                }
                catch (ErrorException errorException) {
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError();
                }
            }
        }
    }

    public ResponseMessage readExpectedMessage(MessageType messageType) throws ErrorException {
        return this.readExpectedMessage(new MessageType[]{messageType});
    }

    public ResponseMessage readExpectedMessage(MessageType[] messageTypeArray) throws ErrorException {
        ResponseMessage responseMessage = this.readMessage();
        MessageType messageType = responseMessage.getType();
        for (MessageType messageType2 : messageTypeArray) {
            if (!messageType.equals((Object)messageType2)) continue;
            return responseMessage;
        }
        LogUtilities.logError("Message read (" + (Object)((Object)messageType) + ") did not match any of the expected types: " + Arrays.toString((Object[])messageTypeArray), (ILogger)this.m_log);
        switch (messageType) {
            case Error: {
                ServerErrorData serverErrorData = ((ErrorResponseMessage)responseMessage).getErrorData();
                throw serverErrorData.buildException();
            }
        }
        throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNEXPECTED_TYPE.toString(), messageType.toString());
    }

    private void handleNotice(NoticeResponseMessage noticeResponseMessage) {
        IWarningListener iWarningListener;
        ServerErrorData serverErrorData = noticeResponseMessage.getNotice();
        LogUtilities.logWarning(serverErrorData.toString(), (ILogger)this.m_log);
        String string = serverErrorData.getSQLState();
        if (string == null) {
            string = "01000";
        }
        IWarningListener iWarningListener2 = iWarningListener = this.m_currentWarningListener == null ? this.m_connection.getWarningListener() : this.m_currentWarningListener;
        if (iWarningListener != null) {
            iWarningListener.postWarning(new Warning(string, serverErrorData.getMessage(), serverErrorData.getErrorCode()));
        }
    }

    public void setWarningListener(IWarningListener iWarningListener) {
        this.m_currentWarningListener = iWarningListener;
    }

    public void clearWarningListener() {
        this.m_currentWarningListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (this.m_isClosed) {
            return;
        }
        try {
            this.m_vStream.close();
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
        }
        finally {
            this.m_isClosed = true;
        }
    }

    public void flush() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.ensureOpen();
        try {
            this.m_vStream.flush();
            this.m_hasOutgoingMessage = false;
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.NETWORK_ERROR_GENERAL.toString(), new String[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    public void ensureOpen() throws GeneralException {
        if (this.m_initComplete && this.m_connection.isClosed()) {
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_CONNECTION_CLOSED.toString());
        }
    }

    public void enableOpenChecking() {
        this.m_initComplete = true;
    }
}

