/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.utilities.DSIMonthSpan;
import com.vertica.dsi.dataengine.utilities.DSITimeSpan;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.utilities.CalendarSetter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataWrapper {
    private static Map<Integer, List<Class<?>>> TYPE_CLASSES_MAP = new HashMap();
    private int m_type = 0;
    private Object m_value = null;

    private static void addTypeClassesMap() {
        ArrayList<Class<DSIMonthSpan>> arrayList = new ArrayList<Class<DSIMonthSpan>>();
        arrayList.add(BigInteger.class);
        arrayList.add(Long.class);
        TYPE_CLASSES_MAP.put(-5, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Boolean.class);
        TYPE_CLASSES_MAP.put(-7, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Date.class);
        TYPE_CLASSES_MAP.put(91, arrayList);
        arrayList = new ArrayList();
        arrayList.add(BigDecimal.class);
        TYPE_CLASSES_MAP.put(3, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Double.class);
        TYPE_CLASSES_MAP.put(8, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Double.class);
        arrayList.add(Float.class);
        TYPE_CLASSES_MAP.put(6, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Long.class);
        arrayList.add(Integer.class);
        TYPE_CLASSES_MAP.put(4, arrayList);
        arrayList = new ArrayList();
        arrayList.add(BigDecimal.class);
        TYPE_CLASSES_MAP.put(2, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Float.class);
        TYPE_CLASSES_MAP.put(7, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Integer.class);
        arrayList.add(Short.class);
        TYPE_CLASSES_MAP.put(5, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Time.class);
        arrayList.add(TimeTz.class);
        TYPE_CLASSES_MAP.put(92, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Timestamp.class);
        arrayList.add(TimestampTz.class);
        arrayList.add(Date.class);
        arrayList.add(Time.class);
        TYPE_CLASSES_MAP.put(93, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Short.class);
        arrayList.add(Byte.class);
        TYPE_CLASSES_MAP.put(-6, arrayList);
        arrayList = new ArrayList();
        arrayList.add(byte[].class);
        arrayList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-2, arrayList);
        arrayList = new ArrayList();
        arrayList.add(byte[].class);
        arrayList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-4, arrayList);
        arrayList = new ArrayList();
        arrayList.add(byte[].class);
        arrayList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-3, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(1, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(-1, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(12, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Boolean.class);
        TYPE_CLASSES_MAP.put(16, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(-8, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(-9, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(-10, arrayList);
        arrayList = new ArrayList();
        arrayList.add(DSITimeSpan.class);
        TYPE_CLASSES_MAP.put(103, arrayList);
        TYPE_CLASSES_MAP.put(108, arrayList);
        TYPE_CLASSES_MAP.put(109, arrayList);
        TYPE_CLASSES_MAP.put(110, arrayList);
        TYPE_CLASSES_MAP.put(104, arrayList);
        TYPE_CLASSES_MAP.put(111, arrayList);
        TYPE_CLASSES_MAP.put(112, arrayList);
        TYPE_CLASSES_MAP.put(105, arrayList);
        TYPE_CLASSES_MAP.put(113, arrayList);
        TYPE_CLASSES_MAP.put(106, arrayList);
        arrayList = new ArrayList();
        arrayList.add(DSIMonthSpan.class);
        TYPE_CLASSES_MAP.put(102, arrayList);
        TYPE_CLASSES_MAP.put(101, arrayList);
        TYPE_CLASSES_MAP.put(107, arrayList);
    }

    public BigInteger getBigInt() throws IncorrectTypeException {
        if (-5 == this.m_type) {
            if (this.m_value instanceof BigInteger) {
                return (BigInteger)this.m_value;
            }
            return BigInteger.valueOf((Long)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public byte[] getBinary() throws IncorrectTypeException {
        if (-2 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Boolean getBit() throws IncorrectTypeException {
        if (-7 == this.m_type || 16 == this.m_type) {
            return (Boolean)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Boolean getBoolean() throws IncorrectTypeException {
        if (-7 == this.m_type || 16 == this.m_type) {
            return (Boolean)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public String getChar() throws IncorrectTypeException {
        if (1 == this.m_type || -8 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Date getDate() throws IncorrectTypeException {
        if (91 == this.m_type) {
            Date date = (Date)this.m_value;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(date.getTime());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            date = new Date(calendar.getTimeInMillis());
            return date;
        }
        throw new IncorrectTypeException();
    }

    public BigDecimal getDecimal() throws IncorrectTypeException {
        if (3 == this.m_type) {
            return (BigDecimal)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Double getDouble() throws IncorrectTypeException {
        if (8 == this.m_type) {
            return (Double)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Double getFloat() throws IncorrectTypeException {
        if (6 == this.m_type) {
            if (this.m_value instanceof Double) {
                return (Double)this.m_value;
            }
            return ((Float)this.m_value).floatValue();
        }
        throw new IncorrectTypeException();
    }

    public Long getInteger() throws IncorrectTypeException {
        if (4 == this.m_type) {
            if (this.m_value instanceof Long) {
                return (Long)this.m_value;
            }
            return (long)((Integer)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Object getInterval() throws IncorrectTypeException {
        if (TypeUtilities.isIntervalType(this.m_type)) {
            return this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public byte[] getLongVarBinary() throws IncorrectTypeException {
        if (-4 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public String getLongVarChar() throws IncorrectTypeException {
        if (-1 == this.m_type || -10 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public BigDecimal getNumeric() throws IncorrectTypeException {
        if (2 == this.m_type) {
            return (BigDecimal)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Object getObject() {
        return this.m_value;
    }

    public Float getReal() throws IncorrectTypeException {
        if (7 == this.m_type) {
            return (Float)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Integer getSmallInt() throws IncorrectTypeException {
        if (5 == this.m_type) {
            if (this.m_value instanceof Integer) {
                return (Integer)this.m_value;
            }
            return (int)((Short)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Time getTime() throws IncorrectTypeException {
        Time time = null;
        if (92 == this.m_type) {
            time = (Time)this.m_value;
            if (this.m_value instanceof TimeTz) {
                TimeTz timeTz = (TimeTz)this.m_value;
                time = CalendarSetter.getTime(time, timeTz.getTimezoneCalendar());
            } else {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTimeInMillis(time.getTime());
                calendar.set(1, 1970);
                calendar.set(2, 0);
                calendar.set(5, 1);
                time = new Time(calendar.getTimeInMillis());
            }
            return time;
        }
        throw new IncorrectTypeException();
    }

    public Timestamp getTimestamp() throws IncorrectTypeException {
        if (93 == this.m_type) {
            if (this.m_value instanceof TimestampTz) {
                TimestampTz timestampTz = (TimestampTz)this.m_value;
                return CalendarSetter.getTimestamp(timestampTz, timestampTz.getTimezoneCalendar());
            }
            return (Timestamp)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public TimestampTz getTimestampTz() throws IncorrectTypeException {
        if (93 == this.m_type) {
            if (null == this.m_value) {
                return null;
            }
            if (this.m_value instanceof Timestamp && !(this.m_value instanceof TimestampTz)) {
                return new TimestampTz((Timestamp)this.m_value, Calendar.getInstance());
            }
            return (TimestampTz)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public TimeTz getTimeTz() throws IncorrectTypeException {
        if (92 == this.m_type) {
            if (null == this.m_value) {
                return null;
            }
            if (this.m_value instanceof Time && !(this.m_value instanceof TimeTz)) {
                return new TimeTz((Time)this.m_value, Calendar.getInstance());
            }
            return (TimeTz)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Short getTinyInt() throws IncorrectTypeException {
        if (-6 == this.m_type) {
            if (this.m_value instanceof Short) {
                return (Short)this.m_value;
            }
            return (short)((Byte)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public int getType() {
        return this.m_type;
    }

    public byte[] getVarBinary() throws IncorrectTypeException {
        if (-3 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public String getVarChar() throws IncorrectTypeException {
        if (12 == this.m_type || -9 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public boolean isNull() {
        return null == this.m_value;
    }

    public boolean isSet() {
        return 0 != this.m_type;
    }

    public void setBigInt(BigInteger bigInteger) {
        this.m_type = -5;
        this.m_value = bigInteger;
    }

    public void setBigInt(long l) {
        this.m_type = -5;
        this.m_value = BigInteger.valueOf(l);
    }

    public void setBinary(byte[] byArray) {
        this.m_type = -2;
        this.m_value = byArray;
    }

    public void setBit(boolean bl) {
        this.m_type = -7;
        this.m_value = bl;
    }

    public void setBit(Boolean bl) {
        this.m_type = -7;
        this.m_value = bl;
    }

    public void setBoolean(boolean bl) {
        this.m_type = 16;
        this.m_value = bl;
    }

    public void setBoolean(Boolean bl) {
        this.m_type = 16;
        this.m_value = bl;
    }

    public void setChar(String string) {
        this.m_type = 1;
        this.m_value = string;
    }

    public void setData(int n, Object object) throws IncorrectTypeException {
        Object object2 = object;
        if (TypeUtilities.isCharacterType(n)) {
            if (object instanceof StringReader) {
                object2 = this.getString((StringReader)object);
            } else if (object instanceof ByteArrayInputStream || object instanceof byte[]) {
                byte[] byArray = this.getByteArray(object);
                object2 = TypeUtilities.isBinaryType(this.m_type) ? (Object)byArray : new String(byArray);
            } else {
                object2 = object.toString();
            }
        } else if (TypeUtilities.isBinaryType(n)) {
            object2 = this.getByteArray(object);
        } else {
            List<Class<?>> list = TYPE_CLASSES_MAP.get(n);
            if (null == list) {
                throw new IncorrectTypeException();
            }
            boolean bl = false;
            for (Class<?> clazz : list) {
                if (!clazz.isInstance(object2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IncorrectTypeException();
            }
        }
        this.m_type = n;
        this.m_value = 93 == n ? (object2 instanceof Time ? new Timestamp(((Time)object2).getTime()) : object2) : object2;
    }

    public void setDate(int n, int n2, int n3) {
        this.m_type = 91;
        this.m_value = new Date(n, n2, n3);
    }

    public void setDate(Date date) {
        this.m_type = 91;
        this.m_value = date;
    }

    public void setDecimal(BigDecimal bigDecimal) {
        this.m_type = 3;
        this.m_value = bigDecimal;
    }

    public void setDouble(double d) {
        this.m_type = 8;
        this.m_value = new Double(d);
    }

    public void setDouble(Double d) {
        this.m_type = 8;
        this.m_value = d;
    }

    public void setFloat(double d) {
        this.m_type = 6;
        this.m_value = new Double(d);
    }

    public void setFloat(Double d) {
        this.m_type = 6;
        this.m_value = d;
    }

    public void setInteger(long l) {
        this.m_type = 4;
        this.m_value = l;
    }

    public void setInteger(Long l) {
        this.m_type = 4;
        this.m_value = l;
    }

    public void setInterval(Object object) {
        if (object instanceof DSIMonthSpan) {
            this.m_type = ((DSIMonthSpan)object).getIntervalType();
            this.m_value = object;
        } else if (object instanceof DSITimeSpan) {
            this.m_type = ((DSITimeSpan)object).getIntervalType();
            this.m_value = object;
        }
    }

    public void setLongVarBinary(byte[] byArray) {
        this.m_type = -4;
        this.m_value = byArray;
    }

    public void setLongVarChar(String string) {
        this.m_type = -1;
        this.m_value = string;
    }

    public void setNull(int n) {
        this.m_type = n;
        this.m_value = null;
    }

    public void setNumeric(BigDecimal bigDecimal) {
        this.m_type = 2;
        this.m_value = bigDecimal;
    }

    public void setReal(float f) {
        this.m_type = 7;
        this.m_value = new Float(f);
    }

    public void setReal(Float f) {
        this.m_type = 7;
        this.m_value = f;
    }

    public void setSmallInt(int n) {
        this.m_type = 5;
        this.m_value = n;
    }

    public void setSmallInt(Integer n) {
        this.m_type = 5;
        this.m_value = n;
    }

    public void setTime(int n, int n2, int n3) {
        this.m_type = 92;
        this.m_value = new Time(n, n2, n3);
    }

    public void setTime(Time time) {
        this.m_type = 92;
        this.m_value = time;
    }

    public void setTime(TimeTz timeTz) {
        this.m_type = 92;
        this.m_value = timeTz;
    }

    public void setTimestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.m_type = 93;
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n7);
        this.m_value = timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.m_type = 93;
        this.m_value = timestamp;
    }

    public void setTimestamp(TimestampTz timestampTz) {
        this.m_type = 93;
        this.m_value = timestampTz;
    }

    public void setTinyInt(short s) {
        this.m_type = -6;
        this.m_value = s;
    }

    public void setTinyInt(Short s) {
        this.m_type = -6;
        this.m_value = s;
    }

    public void setVarBinary(byte[] byArray) {
        this.m_type = -3;
        this.m_value = byArray;
    }

    public void setVarChar(String string) {
        this.m_type = 12;
        this.m_value = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_type);
        stringBuilder.append("|");
        if (this.isNull()) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.m_value.toString());
        }
        return stringBuilder.toString();
    }

    private byte[] getByteArray(Object object) throws IncorrectTypeException {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof ByteArrayInputStream) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)object;
            byte[] byArray = new byte[byteArrayInputStream.available()];
            try {
                byteArrayInputStream.read(byArray);
            }
            catch (IOException iOException) {
                return null;
            }
            return byArray;
        }
        throw new IncorrectTypeException();
    }

    private String getString(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            while (-1 != (n = ((Reader)bufferedReader).read())) {
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    static {
        DataWrapper.addTypeClassesMap();
    }
}

