/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.AttributeDataMap;
import com.vertica.dsi.core.utilities.PropertyLimitKeys;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.WarningCode;
import com.vertica.support.exceptions.ErrorException;
import java.util.Hashtable;

public abstract class DSIStatement
implements IStatement {
    private AttributeDataMap m_settings = new AttributeDataMap();
    private Hashtable<Integer, PropertyLimitKeys> m_propertyLimitKeyMap = new Hashtable();
    private IConnection m_parentConnection = null;
    private String m_cursorName = "";
    private IWarningListener m_warningListener = null;

    protected DSIStatement(IConnection iConnection) throws ErrorException {
        this.m_parentConnection = iConnection;
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
        this.loadPropertyKeyToPropertyLimitKeyMapping();
    }

    public String getCursorName() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        return this.m_cursorName;
    }

    public Variant getCustomProperty(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        return null;
    }

    public int getCustomPropertyType(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        return 0;
    }

    public ILogger getLog() {
        return this.m_parentConnection.getConnectionLog();
    }

    public IConnection getParentConnection() {
        return this.m_parentConnection;
    }

    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        if (null == this.m_settings) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (this.m_settings.isProperty(n)) {
            return this.m_settings.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    public Variant getSimilarValue(int n, Variant variant) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n, variant);
        if (null == this.m_propertyLimitKeyMap) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROP_LIMITMAP.name());
        }
        try {
            PropertyLimitKeys propertyLimitKeys = this.m_propertyLimitKeyMap.get(n);
            if (null == propertyLimitKeys) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROP_LIMITKEY.name());
            }
            int n2 = (int)variant.getLong();
            Integer n3 = propertyLimitKeys.getMaxLimitkey();
            Variant variant2 = this.m_settings.getProperty(n3);
            long l = n2;
            if (null != variant2) {
                l = variant2.getLong();
            }
            Integer n4 = propertyLimitKeys.getMinLimitkey();
            Variant variant3 = this.m_settings.getProperty(n4);
            long l2 = n2;
            if (null != variant3) {
                l2 = variant3.getLong();
            }
            if (null != variant2 && null != variant3 && l == l2) {
                return null;
            }
            if (null != variant2 && l < (long)n2) {
                return variant2;
            }
            if (null != variant3 && l2 > (long)n2) {
                return variant3;
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
        return null;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    public boolean isCustomProperty(int n) throws ErrorException {
        return false;
    }

    public boolean isValueSupported(int n, Variant variant) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), variant);
        if (null == this.m_propertyLimitKeyMap) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROP_LIMITMAP.name());
        }
        PropertyLimitKeys propertyLimitKeys = this.m_propertyLimitKeyMap.get(n);
        if (null == propertyLimitKeys) {
            return true;
        }
        try {
            long l = variant.getLong();
            boolean bl = false;
            Integer n2 = propertyLimitKeys.getMaxLimitkey();
            Variant variant2 = this.m_settings.getProperty(n2);
            long l2 = l;
            if (null != variant2) {
                l2 = variant2.getLong();
                bl = 0L != l2;
            }
            Integer n3 = propertyLimitKeys.getMinLimitkey();
            Variant variant3 = this.m_settings.getProperty(n3);
            long l3 = l;
            if (null != variant3) {
                l3 = variant3.getLong();
            }
            if (bl && null != variant3 && l2 == l3) {
                return l2 == l;
            }
            if (bl && l2 < l) {
                return false;
            }
            if (null != variant3 && l3 > l) {
                return false;
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
        return true;
    }

    public void notifyCursorNameChange(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string);
        this.m_cursorName = string;
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    public void setCustomProperty(int n, Variant variant) {
        LogUtilities.logFunctionEntrance(this.getLog(), variant);
    }

    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n, variant);
        if (null == this.m_settings) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (this.isValueSupported(n, variant)) {
            this.m_settings.setProperty(n, variant);
        } else {
            Variant variant2 = this.getSimilarValue(n, variant);
            if (null == variant2) {
                throw new BadAttrValException(2, DSIMessageKey.BAD_ATTR_VAL.name(), new String[]{String.valueOf(n), variant.getString()});
            }
            this.m_settings.setProperty(n, variant2);
            if (null != this.m_warningListener) {
                this.m_warningListener.postWarning(new Warning(WarningCode.OPTIONAL_VALUE_CHANGED, 2, DSIMessageKey.OPTIONAL_VAL_CHANGED.name(), new String[]{String.valueOf(n), variant.getString()}));
            }
        }
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_settings.setProperty(100, 3, 0xFFFFFFFFL);
        this.m_settings.setProperty(101, 3, 0L);
        this.m_settings.setProperty(104, 3, 0L);
        this.m_settings.setProperty(105, 3, 0L);
        this.m_settings.setProperty(103, 3, 0L);
        this.m_settings.setProperty(1, 3, 0L);
        this.m_settings.setProperty(2, 3, 0L);
        this.m_settings.setProperty(3, 3, 0L);
        this.m_settings.setProperty(4, 5, (short)0);
    }

    private void loadPropertyKeyToPropertyLimitKeyMapping() {
        PropertyLimitKeys propertyLimitKeys = new PropertyLimitKeys(100, 101);
        this.m_propertyLimitKeyMap.put(1, propertyLimitKeys);
        PropertyLimitKeys propertyLimitKeys2 = new PropertyLimitKeys(102, 103);
        this.m_propertyLimitKeyMap.put(2, propertyLimitKeys2);
        PropertyLimitKeys propertyLimitKeys3 = new PropertyLimitKeys(104, 105);
        this.m_propertyLimitKeyMap.put(3, propertyLimitKeys3);
    }
}

