/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;

public class DSIDriverFactory {
    private static String s_driverClassName = null;

    public static IDriver createDriver() throws ErrorException {
        if (null == s_driverClassName) {
            throw new GeneralException("Error creating DriverFactory, Driver class name not set.", 0);
        }
        try {
            return (IDriver)Class.forName(s_driverClassName).newInstance();
        }
        catch (Exception exception) {
            throw new GeneralException("Error creating Driver, Driver class name incorrect.", 0);
        }
    }

    public static synchronized void setDriverClassName(String string) {
        if (null == s_driverClassName) {
            s_driverClassName = string;
        }
    }
}

