/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIMessageSource;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.utilities.AttributeDataMap;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.IMessageSource;
import com.vertica.support.LogUtilities;
import com.vertica.support.SettingReader;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionBuilder;
import com.vertica.support.exceptions.ExceptionUtilities;
import java.util.Locale;

public abstract class DSIDriver
implements IDriver {
    public static ExceptionBuilder s_DSIMessages = new ExceptionBuilder(2);
    protected DSIMessageSource m_msgSrc = new DSIMessageSource(true, true);
    private AttributeDataMap m_settings = new AttributeDataMap();

    protected DSIDriver() throws ErrorException {
        try {
            this.loadProperties();
            LogUtilities.logFunctionEntrance(this.getDriverLog(), new Object[0]);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
        this.registerMessages();
    }

    public Locale getLocale() {
        String string = SettingReader.readSetting("DriverLocale");
        return ExceptionUtilities.createLocale(string);
    }

    public IMessageSource getMessageSource() {
        return this.m_msgSrc;
    }

    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getDriverLog(), n);
        if (null == this.m_settings) {
            throw s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (this.m_settings.isProperty(n)) {
            return this.m_settings.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    protected void setProperty(int n, Variant variant) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getDriverLog(), n, variant);
        if (null == this.m_settings) {
            throw s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        this.m_settings.setProperty(n, variant);
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_settings.setProperty(1, 2, Character.valueOf('\u0000'));
        this.m_settings.setProperty(2, 3, 0L);
        this.m_settings.setProperty(3, 0, "");
        this.m_settings.setProperty(4, 0, "03.52");
        this.m_settings.setProperty(5, 0, "9.0.39.1102");
        this.m_settings.setProperty(6, 2, Character.valueOf('\u0000'));
        this.m_settings.setProperty(7, 6, 65532);
        this.m_settings.setProperty(9, 6, 65532);
        this.m_settings.setProperty(8, 6, 65532);
        this.m_settings.setProperty(10, 6, 1);
        this.m_settings.setProperty(11, 3, 1L);
        this.m_settings.setProperty(12, 5, (short)0);
        this.m_settings.setProperty(13, 3, 2L);
        this.m_settings.setProperty(16, 0, "1995");
        this.m_settings.setProperty(17, 3, 0L);
        this.m_settings.setProperty(18, 2, Character.valueOf('\u0002'));
        this.m_settings.setProperty(19, 3, 0x40000000L);
        this.m_settings.setProperty(20, 3, 0L);
        this.m_settings.setProperty(21, 3, 0L);
        this.m_settings.setProperty(22, 3, 1L);
        this.m_settings.setProperty(1000, 5, (short)0);
        this.m_settings.setProperty(1001, 5, (short)0);
        this.m_settings.setProperty(1002, 5, (short)0);
        this.m_settings.setProperty(1003, 5, (short)0);
        this.m_settings.setProperty(1004, 5, (short)0);
    }

    private void registerMessages() {
        String string = ExceptionUtilities.getPackageName(DSIDriver.class);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(".");
        stringBuilder.append("DSIMessages");
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 2, "JDSI");
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append(".");
        stringBuilder2.append("JDBCMessages");
        this.m_msgSrc.registerMessages(stringBuilder2.toString(), 1, "JDBC");
    }
}

