/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.core.VConnection;
import com.vertica.core.VStatement;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dataengine.VCopyStreamExecutionContext;
import com.vertica.dataengine.VCopyStreamExecutionContexts;
import com.vertica.dataengine.VResultSet;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.dataengine.impl.DSIErrorResult;
import com.vertica.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.vertica.dsi.dataengine.interfaces.IQueryExecutor;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionContext;
import com.vertica.dsi.dataengine.utilities.ExecutionContextStatus;
import com.vertica.dsi.dataengine.utilities.ExecutionContexts;
import com.vertica.dsi.dataengine.utilities.ExecutionResults;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.BadDefaultParamException;
import com.vertica.dsi.exceptions.ExecutingException;
import com.vertica.dsi.exceptions.OperationCanceledException;
import com.vertica.dsi.exceptions.ParsingException;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.io.BindRequestMessage;
import com.vertica.io.CopyDataRequestMessage;
import com.vertica.io.CopyDoneRequestMessage;
import com.vertica.io.CopyErrorRequestMessage;
import com.vertica.io.EndOfBatchRequestMessage;
import com.vertica.io.ErrorResponseMessage;
import com.vertica.io.ExecuteRequestMessage;
import com.vertica.io.LoadFileResponseMessage;
import com.vertica.io.Message;
import com.vertica.io.MessageType;
import com.vertica.io.ProtocolStream;
import com.vertica.io.ReadyForQueryResponseMessage;
import com.vertica.io.RequestMessage;
import com.vertica.io.ResponseMessage;
import com.vertica.io.RowDescriptionResponseMessage;
import com.vertica.io.SimpleQueryRequestMessage;
import com.vertica.io.SyncRequestMessage;
import com.vertica.io.VerifiedFilesRequestMessage;
import com.vertica.io.VerifyFilesResponseMessage;
import com.vertica.io.WriteFileResponseMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.parser.StatementType;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.util.ServerErrorData;
import com.vertica.util.ServerException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VQueryExecutor
implements IQueryExecutor {
    private DSILogger m_log;
    private String m_query;
    private ProtocolStream m_protocolStream;
    private VStatement m_statement;
    private String m_statementName;
    private Queue<VResultSet> m_futureResults;
    private VConnection m_connection;
    private final ArrayList<ParameterMetadata> m_parameterMetadata;
    private final boolean m_isSimpleBatchQuery;
    private ArrayList<ColumnDescription> m_preparedRowDescription;
    private List<String> m_commandTags;
    private final boolean m_useExtendedProtocol;
    private ExecutionContexts m_currentContexts;
    private ExecutionContext m_currentExecutionContext;
    private IWarningListener m_currentWarningListener;
    private boolean m_startingCopyOperation;
    private final boolean m_isBatchCopy;
    private final boolean m_generatesOnlyResultSets;
    private boolean m_isStdInCopy;
    private final boolean m_useLocalCopyProtocol;
    private long[] m_rejects;
    private long m_biAttemptedRowCount;
    private long m_copyRowCount;
    private VResultSet m_copyRowCountRS;
    private final Map<Integer, Map<Integer, List<DataWrapper>>> m_pushedDataCache;
    private ExecutionResults m_executionResults;
    private final ExecutionResults m_preExecuteResults;
    private boolean m_previousExecuteFailed;

    public VQueryExecutor(VStatement vStatement, String string, String string2, ArrayList<ParameterMetadata> arrayList, ArrayList<ColumnDescription> arrayList2, List<String> list, boolean bl, boolean bl2) {
        this.m_connection = vStatement.getConnection();
        this.m_log = this.m_connection.getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_log, vStatement, string2, arrayList, arrayList2, list, bl, bl2);
        this.m_statement = vStatement;
        this.m_query = string;
        this.m_statementName = string2;
        this.m_parameterMetadata = arrayList;
        this.m_protocolStream = this.m_connection.getProtocolStream();
        this.m_preparedRowDescription = arrayList2;
        this.m_useExtendedProtocol = bl2;
        this.m_commandTags = list;
        this.m_isSimpleBatchQuery = bl;
        this.m_isBatchCopy = this.m_preparedRowDescription != null && !bl2 && this.m_commandTags.size() == 1 && this.m_commandTags.get(0).equals("INSERT");
        this.m_useLocalCopyProtocol = this.m_isBatchCopy || this.m_commandTags.size() == 1 && this.m_commandTags.get(0).equals("COPY_LOCAL");
        this.m_pushedDataCache = new HashMap<Integer, Map<Integer, List<DataWrapper>>>();
        this.m_executionResults = new ExecutionResults();
        this.m_futureResults = new ConcurrentLinkedQueue<VResultSet>();
        boolean bl3 = true;
        for (String string3 : list) {
            VResultSet vResultSet = new VResultSet(this, this.m_futureResults, string3, this.m_preparedRowDescription);
            this.registerResult(vResultSet, false);
            bl3 &= StatementType.returnsResultSet(string3);
        }
        this.m_generatesOnlyResultSets = bl3;
        this.m_preExecuteResults = this.m_executionResults;
        this.m_currentContexts = null;
        this.m_currentWarningListener = null;
    }

    public VQueryExecutor(VStatement vStatement, String string, List<String> list, boolean bl) {
        this(vStatement, string, "", new ArrayList<ParameterMetadata>(), null, list, bl, false);
    }

    @Override
    public void cancelExecute() throws GeneralException {
        this.m_connection.cancelCurrentStatement();
    }

    @Override
    public void clearCancel() {
    }

    @Override
    public void close() {
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.m_parameterMetadata;
    }

    @Override
    public int getNumParams() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.m_parameterMetadata.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResults getResults() {
        VConnection vConnection = this.m_connection;
        synchronized (vConnection) {
            if ((this.m_isBatchCopy || this.m_useExtendedProtocol) && this.m_previousExecuteFailed) {
                return this.m_preExecuteResults;
            }
            return this.m_executionResults;
        }
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, GeneralException {
        block5: {
            List<DataWrapper> list;
            LogUtilities.logFunctionEntrance(this.m_log, n, parameterInputValue);
            assert (0 < n);
            int n2 = parameterInputValue.getMetadata().getParameterNumber();
            --n2;
            Map<Integer, List<DataWrapper>> map = this.m_pushedDataCache.get(n - 1);
            if (map == null) {
                map = new HashMap<Integer, List<DataWrapper>>();
                this.m_pushedDataCache.put(n - 1, map);
            }
            List<DataWrapper> list2 = list = map.isEmpty() ? null : map.get(n2);
            if (null == list) {
                list = new ArrayList<DataWrapper>();
                map.put(n2, list);
            }
            try {
                list.add(parameterInputValue.getData());
            }
            catch (UtilsException utilsException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void finalizePushedParamData() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        for (Map<Integer, List<DataWrapper>> map : this.m_pushedDataCache.values()) {
            for (Integer n : map.keySet()) {
                List<DataWrapper> list = map.get(n);
                DataWrapper dataWrapper = new DataWrapper();
                if (TypeUtilities.isCharacterType(this.m_parameterMetadata.get(n).getTypeMetadata().getType())) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (DataWrapper dataWrapper2 : list) {
                        stringBuilder.append((String)dataWrapper2.getObject());
                    }
                    dataWrapper.setVarChar(stringBuilder.toString());
                } else {
                    int n2 = 0;
                    for (DataWrapper dataWrapper3 : list) {
                        n2 += ((byte[])dataWrapper3.getObject()).length;
                    }
                    Object object = new byte[n2];
                    int n3 = 0;
                    for (DataWrapper dataWrapper4 : list) {
                        byte[] byArray = (byte[])dataWrapper4.getObject();
                        System.arraycopy(byArray, 0, object, n3, byArray.length);
                        n3 += byArray.length;
                    }
                    dataWrapper.setLongVarBinary((byte[])object);
                }
                list.clear();
                list.add(dataWrapper);
            }
        }
    }

    @Override
    public void clearPushedParamData() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_pushedDataCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        VConnection vConnection = this.m_connection;
        synchronized (vConnection) {
            try {
                block18: {
                    block19: {
                        block17: {
                            this.m_protocolStream.setWarningListener(iWarningListener);
                            this.m_connection.ensureNotInLRS(this.m_query, this.m_statement.getResultBufferSize());
                            this.m_previousExecuteFailed = false;
                            this.m_currentContexts = executionContexts;
                            this.m_currentWarningListener = iWarningListener;
                            this.m_futureResults = new ConcurrentLinkedQueue<VResultSet>();
                            this.m_executionResults = new ExecutionResults();
                            if (this.m_useLocalCopyProtocol) {
                                VQueryExecutor vQueryExecutor = this.m_connection.getCurrentCopyExecutor();
                                if (this == vQueryExecutor) {
                                    this.m_startingCopyOperation = false;
                                } else {
                                    this.m_connection.endCurrentCopy();
                                    this.m_startingCopyOperation = true;
                                }
                            } else {
                                this.m_connection.endCurrentCopy();
                            }
                            if (this.m_currentContexts.getCount() == 0) {
                                return;
                            }
                            if (!this.m_useExtendedProtocol) break block17;
                            assert (!this.m_useLocalCopyProtocol);
                            this.executeExtendedProtocol();
                            break block18;
                        }
                        if (this.m_useLocalCopyProtocol && !this.m_startingCopyOperation) break block19;
                        boolean bl = this.executeSimpleProtocol();
                        if (!bl) break block18;
                        assert (!this.m_useLocalCopyProtocol);
                        return;
                    }
                    assert (this.m_useLocalCopyProtocol && this.m_connection.getCurrentCopyExecutor() == this);
                }
                this.handleExecuteResponse();
            }
            finally {
                this.m_pushedDataCache.clear();
                this.m_protocolStream.clearWarningListener();
            }
            return;
        }
    }

    private void checkForCancelError(ErrorException errorException) throws OperationCanceledException, ErrorException {
        ServerErrorData serverErrorData;
        if (errorException instanceof ServerException && (serverErrorData = ((ServerException)errorException).getError()).isCancellelationError()) {
            this.m_executionResults = new ExecutionResults();
            throw new ErrorException(DiagState.DIAG_OPER_CANCELED, 101, VMessageKey.SERVER_ERROR_DATA.name(), new String[]{serverErrorData.toString()});
        }
    }

    private void registerResult(VResultSet vResultSet, boolean bl) {
        if (bl) {
            this.m_futureResults.add(vResultSet);
        }
        if (vResultSet.isRowCount()) {
            this.m_executionResults.addRowCountResult(vResultSet);
        } else {
            this.m_executionResults.addResultSet(vResultSet);
        }
    }

    private void registerBatchError(ErrorException errorException, ExecutionContext executionContext) {
        executionContext.setStatus(ExecutionContextStatus.ERROR);
        String string = errorException.getMessage();
        String string2 = "";
        if (errorException instanceof ServerException) {
            string2 = ((ServerException)errorException).getError().getSQLState();
        }
        this.m_executionResults.addErrorResult(new DSIErrorResult(string, 0, string2), false);
    }

    private boolean executeSimpleProtocol() throws ErrorException, OperationCanceledException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl = false;
        try {
            String string = this.m_query;
            if (this.m_isBatchCopy && this.m_statement.getDirectBatchInsert()) {
                if (this.m_connection.isAutoCommitEnabled() && this.m_query.endsWith("AUTO")) {
                    string = this.m_query.substring(0, this.m_query.length() - 4) + "DIRECT";
                } else if (this.m_query.endsWith("AUTO NO COMMIT")) {
                    string = this.m_query.substring(0, this.m_query.length() - 14) + "DIRECT NO COMMIT";
                }
            }
            this.m_protocolStream.sendMessage(new SimpleQueryRequestMessage(string));
            ResponseMessage responseMessage = this.m_protocolStream.readMessage();
            MessageType messageType = responseMessage.getType();
            if (messageType.equals((Object)MessageType.Error)) {
                ServerErrorData serverErrorData = ((ErrorResponseMessage)responseMessage).getErrorData();
                ServerException serverException = serverErrorData.buildException();
                throw serverException;
            }
            if (messageType.equals((Object)MessageType.EmptyQuery)) {
                ReadyForQueryResponseMessage readyForQueryResponseMessage = (ReadyForQueryResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.ReadyForQuery);
                this.m_connection.setServerTxnState(readyForQueryResponseMessage.getTxnState(), false, true);
                bl = true;
            } else {
                this.m_protocolStream.putBack(responseMessage);
            }
        }
        catch (ErrorException errorException) {
            this.m_previousExecuteFailed = true;
            this.m_connection.handleError(false, errorException);
            this.checkForCancelError(errorException);
            throw errorException;
        }
        return bl;
    }

    private void executeExtendedProtocol() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
            int n = 0;
            while (iterator.hasNext()) {
                ExecutionContext executionContext = iterator.next();
                ArrayList<ParameterInputValue> arrayList = executionContext.getInputs();
                this.m_protocolStream.sendMessage(new BindRequestMessage(arrayList, this.m_pushedDataCache.get(n++), this.m_statementName, ""));
                this.m_protocolStream.sendMessage(new ExecuteRequestMessage("", 0));
            }
            this.m_protocolStream.sendMessage(new SyncRequestMessage());
        }
        catch (ErrorException errorException) {
            this.m_previousExecuteFailed = true;
            this.m_connection.handleError(true, errorException);
            this.checkForCancelError(errorException);
            throw errorException;
        }
    }

    private void handleExecuteResponse() throws ErrorException, OperationCanceledException {
        try {
            if (this.m_useLocalCopyProtocol) {
                if (this.m_currentContexts.getCount() > 0) {
                    this.m_currentExecutionContext = this.m_currentContexts.contextIterator().next();
                }
                if (this.m_startingCopyOperation) {
                    this.readCopyStartResponse();
                }
                boolean bl = true;
                while (bl) {
                    this.sendCopyData();
                    bl = this.readCopyDataResponse();
                }
            } else {
                this.readExecuteResponse();
            }
        }
        catch (ErrorException errorException) {
            this.m_previousExecuteFailed = true;
            this.m_connection.handleError(false, errorException);
            this.checkForCancelError(errorException);
            if (this.m_currentExecutionContext != null) {
                if (this.m_isSimpleBatchQuery || this.m_currentContexts.getCount() > 1) {
                    this.registerBatchError(errorException, this.m_currentExecutionContext);
                } else {
                    this.m_currentExecutionContext.setStatus(ExecutionContextStatus.ERROR);
                }
            }
            throw errorException;
        }
    }

    private void readExecuteResponse() throws ErrorException {
        Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
        assert (this.m_futureResults.isEmpty());
        while (iterator.hasNext()) {
            this.m_currentExecutionContext = iterator.next();
            for (String string : this.m_commandTags) {
                VResultSet vResultSet = new VResultSet(this, this.m_futureResults, string, this.m_preparedRowDescription);
                this.registerResult(vResultSet, true);
                if (this.m_connection.inLRS()) continue;
                vResultSet.initialize();
            }
            this.m_currentExecutionContext.setStatus(ExecutionContextStatus.SUCCESS);
        }
    }

    private void readCopyStartResponse() throws ErrorException {
        Message message;
        RowDescriptionResponseMessage rowDescriptionResponseMessage = (RowDescriptionResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.RowDescription);
        this.m_copyRowCountRS = new VResultSet(this, this.m_futureResults, this.m_commandTags.get(0), rowDescriptionResponseMessage.getRowDescription());
        this.m_futureResults.add(this.m_copyRowCountRS);
        this.m_connection.setCurrentCopy(this);
        VerifyFilesResponseMessage verifyFilesResponseMessage = (VerifyFilesResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.VerifyFiles);
        String[] stringArray = verifyFilesResponseMessage.getInputFileNames();
        this.m_isStdInCopy = stringArray.length == 0;
        File[] fileArray = null;
        try {
            fileArray = this.checkFiles(stringArray, verifyFilesResponseMessage.getExceptionsFileName(), verifyFilesResponseMessage.getRejectionsFileName());
            message = new VerifiedFilesRequestMessage(fileArray);
            this.m_protocolStream.sendMessage((RequestMessage)message);
        }
        catch (IOException iOException) {
            this.m_protocolStream.sendMessage(new CopyErrorRequestMessage(iOException));
        }
        message = this.m_protocolStream.readMessage();
        switch (message.getType()) {
            case CopyIn: {
                assert (this.m_isStdInCopy);
                break;
            }
            case Error: {
                throw ((ErrorResponseMessage)message).getErrorData().buildException();
            }
            default: {
                this.m_protocolStream.putBack((ResponseMessage)message);
            }
        }
    }

    private void sendCopyData() throws ErrorException {
        List<CopyDataRequestMessage> list = null;
        list = this.m_isStdInCopy ? this.getStdinCopyData() : this.getLocalFileCopyData();
        for (CopyDataRequestMessage copyDataRequestMessage : list) {
            this.m_protocolStream.sendMessage(copyDataRequestMessage);
        }
        this.m_protocolStream.sendMessage(new EndOfBatchRequestMessage());
    }

    private boolean readCopyDataResponse() throws ErrorException {
        this.m_rejects = null;
        ResponseMessage responseMessage = this.m_protocolStream.readExpectedMessage(EndOfBatchRequestMessage.LEGAL_RESPONSES);
        while (responseMessage.getType().equals((Object)MessageType.WriteFile)) {
            WriteFileResponseMessage writeFileResponseMessage = (WriteFileResponseMessage)responseMessage;
            if (writeFileResponseMessage.usingReturnRejectedFormat()) {
                this.m_rejects = writeFileResponseMessage.getReturnRejectedRows();
            } else {
                writeFileResponseMessage.writeToDisk();
            }
            responseMessage = this.m_protocolStream.readExpectedMessage(EndOfBatchRequestMessage.LEGAL_RESPONSES);
        }
        if (this.m_rejects == null) {
            this.m_rejects = new long[0];
        }
        this.m_protocolStream.putBack(responseMessage);
        this.m_protocolStream.readExpectedMessage(MessageType.ServerEndOfBatch);
        if (!this.m_isStdInCopy) {
            responseMessage = this.m_protocolStream.readMessage();
            this.m_protocolStream.putBack(responseMessage);
            if (responseMessage.getType().equals((Object)MessageType.LoadFile)) {
                return true;
            }
            this.m_protocolStream.readExpectedMessage(MessageType.ServerCopyDone);
        }
        if (!this.m_isStdInCopy || this.m_isStdInCopy && this.m_connection.isAutoCommitEnabled()) {
            this.m_connection.endCurrentCopy();
        }
        if (this.m_isBatchCopy) {
            this.registerBatchInsertResults();
        } else {
            this.registerLocalCopyResults();
        }
        return false;
    }

    private List<CopyDataRequestMessage> getStdinCopyData() {
        Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
        int n = 0;
        LinkedList<CopyDataRequestMessage> linkedList = new LinkedList<CopyDataRequestMessage>();
        if (this.m_currentContexts.getCount() == 0 && this.m_isBatchCopy && this.m_startingCopyOperation) {
            linkedList.add(new CopyDataRequestMessage(this.m_startingCopyOperation, this.m_parameterMetadata.size(), null, null));
        }
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            this.m_currentExecutionContext = iterator.next();
            if (this.m_currentExecutionContext instanceof VCopyStreamExecutionContext) {
                object2 = (VCopyStreamExecutionContext)this.m_currentExecutionContext;
                object = ((VCopyStreamExecutionContext)object2).getCopyStream();
                linkedList.add(new CopyDataRequestMessage((InputStream)object));
            } else {
                object2 = this.m_currentExecutionContext.getInputs();
                object = this.m_pushedDataCache.get(n++);
                CopyDataRequestMessage copyDataRequestMessage = new CopyDataRequestMessage(this.m_startingCopyOperation, this.m_parameterMetadata.size(), (List<ParameterInputValue>)object2, (Map<Integer, List<DataWrapper>>)object);
                linkedList.add(copyDataRequestMessage);
            }
            if (!this.m_startingCopyOperation) continue;
            this.m_startingCopyOperation = false;
        }
        return linkedList;
    }

    private List<CopyDataRequestMessage> getLocalFileCopyData() throws ErrorException {
        LinkedList<CopyDataRequestMessage> linkedList = new LinkedList<CopyDataRequestMessage>();
        LoadFileResponseMessage loadFileResponseMessage = (LoadFileResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.LoadFile);
        String string = loadFileResponseMessage.getFileName();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            linkedList.add(new CopyDataRequestMessage(fileInputStream));
        }
        catch (IOException iOException) {
            this.m_protocolStream.sendMessage(new CopyErrorRequestMessage(iOException));
        }
        return linkedList;
    }

    private void registerBatchInsertResults() {
        Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.m_currentExecutionContext = iterator.next();
            if (n < this.m_rejects.length && this.m_rejects[n] == this.m_biAttemptedRowCount + 1L) {
                this.m_currentExecutionContext.setStatus(ExecutionContextStatus.ERROR);
                this.m_executionResults.addErrorResult(new DSIErrorResult(this.m_connection.getMessageSource().loadMessage(this.m_connection.getLocale(), 101, VMessageKey.ERROR_ROW_REJECTED.toString()), 0, "01S01"), false);
                ++n;
            } else {
                this.m_currentExecutionContext.setStatus(ExecutionContextStatus.SUCCESS);
                this.m_executionResults.addRowCountResult(new DSISimpleRowCountResult(1L));
            }
            ++this.m_biAttemptedRowCount;
        }
    }

    private void registerLocalCopyResults() throws ErrorException {
        Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
        while (iterator.hasNext()) {
            this.m_currentExecutionContext = iterator.next();
            this.m_currentExecutionContext.setStatus(ExecutionContextStatus.SUCCESS);
        }
        if (!this.m_isStdInCopy) {
            this.registerResult(this.m_copyRowCountRS, false);
        }
        if (this.m_currentContexts instanceof VCopyStreamExecutionContexts) {
            ((VCopyStreamExecutionContexts)this.m_currentContexts).setRejects(this.m_rejects);
        }
    }

    private File[] checkFiles(String[] stringArray, String string, String string2) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        if (stringArray.length == 0) {
            assert (this.m_isStdInCopy);
            return new File[0];
        }
        for (String string3 : stringArray) {
            HashSet<File> hashSet = this.expandGlob(string3);
            if (hashSet.isEmpty()) {
                File file = new File(string3);
                if (file.isDirectory()) {
                    throw new IOException(string3 + " is a directory.");
                }
                if (!file.exists()) {
                    throw new IOException(string3 + " does not exist.");
                }
                hashSet.add(file);
            }
            for (File file : hashSet) {
                this.checkFile(file, true);
            }
            arrayList.addAll(hashSet);
        }
        if (!"".equals(string2)) {
            this.checkFile(new File(string2), false);
        }
        if (!"".equals(string)) {
            this.checkFile(new File(string), false);
        }
        Object[] objectArray = new File[arrayList.size()];
        return (File[])arrayList.toArray(objectArray);
    }

    private void checkFile(File file, boolean bl) throws IOException {
        try {
            String string = file.getAbsolutePath();
            if (file.isDirectory()) {
                throw new IOException(string + " is a directory.");
            }
            if (bl) {
                if (!file.exists()) {
                    throw new IOException(string + " does not exist.");
                }
                if (!file.canRead()) {
                    throw new IOException(string + " is not readable.");
                }
            } else {
                if (file.exists() && !file.canWrite()) {
                    throw new IOException(string + " is not writable.");
                }
                File file2 = file.getParentFile();
                if (!(file2 == null || file2.isDirectory() && file2.canWrite())) {
                    throw new IOException(string + " is not writable.");
                }
            }
        }
        catch (SecurityException securityException) {
            throw new IOException("Insufficient permissions on " + file);
        }
    }

    public VStatement getParentStatement() {
        return this.m_statement;
    }

    public long[] getCopyRejects() {
        return this.m_rejects;
    }

    public long getCopyRowCount() {
        return this.m_copyRowCount;
    }

    protected final boolean generatesOnlyResultSets() {
        return this.m_generatesOnlyResultSets;
    }

    public void endCopy() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, this);
        this.m_protocolStream.sendMessage(new CopyDoneRequestMessage());
        ResponseMessage responseMessage = this.m_protocolStream.readMessage();
        if (responseMessage.getType().equals((Object)MessageType.WriteFile)) {
            WriteFileResponseMessage writeFileResponseMessage = (WriteFileResponseMessage)responseMessage;
            writeFileResponseMessage.toString();
        } else {
            this.m_protocolStream.putBack(responseMessage);
        }
        this.m_connection.setCurrentCopy(null);
        this.m_copyRowCountRS.initialize();
        this.m_copyRowCount += this.m_copyRowCountRS.getRowCount();
        this.m_biAttemptedRowCount = 0L;
    }

    private HashSet<File> expandGlob(String string) throws IOException {
        File file = new File(string);
        String string2 = Pattern.quote(File.separator);
        boolean bl = System.getProperty("os.name", "").contains("Windows");
        if (bl) {
            string2 = string2 + "|" + Pattern.quote("/");
        }
        String[] stringArray = string.split(string2);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        if (file.isAbsolute()) {
            if ("".equals(stringArray[0]) && !bl) {
                arrayList.add(File.separator);
            }
        } else if (!".".equals(stringArray[0]) && !"..".equals(stringArray[0])) {
            arrayList.add(".");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ("".equals(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        HashSet<File> hashSet = new HashSet<File>();
        try {
            this.expandGlobImpl(new File((String)arrayList.get(0)), 1, arrayList, hashSet);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IOException(patternSyntaxException.getMessage());
        }
        return hashSet;
    }

    private boolean expandGlobImpl(File file, int n, ArrayList<String> arrayList, HashSet<File> hashSet) throws IOException {
        boolean bl = false;
        String string = arrayList.get(n);
        ++n;
        File[] fileArray = null;
        if ("..".equals(string)) {
            File[] fileArray2 = file.getAbsoluteFile();
            if (fileArray2.getParentFile() != null) {
                fileArray2 = fileArray2.getParentFile();
            }
            fileArray = new File[]{fileArray2};
        } else {
            fileArray = ".".equals(string) ? new File[]{file} : file.listFiles(new GlobFileFilter(string));
        }
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (n < arrayList.size()) {
                    if (!file2.isDirectory()) continue;
                    bl |= this.expandGlobImpl(file2.getCanonicalFile(), n, arrayList, hashSet);
                    continue;
                }
                if (!file2.exists() || !file2.isFile()) continue;
                hashSet.add(file2);
                bl = true;
            }
        }
        return bl;
    }

    private static class GlobFileFilter
    implements FileFilter {
        private Pattern m_regex;

        public GlobFileFilter(String string) throws PatternSyntaxException {
            String string2 = this.glob2regex(string);
            this.m_regex = Pattern.compile(string2);
        }

        private String glob2regex(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            boolean bl = false;
            int n = 0;
            for (char c : string.toCharArray()) {
                switch (c) {
                    case '\\': {
                        if (!bl) break;
                        stringBuilder.append("\\\\");
                        break;
                    }
                    case '*': {
                        if (bl) {
                            stringBuilder.append("\\*");
                            break;
                        }
                        stringBuilder.append(".*");
                        break;
                    }
                    case '?': {
                        if (bl) {
                            stringBuilder.append("\\?");
                            break;
                        }
                        stringBuilder.append(".");
                        break;
                    }
                    case '{': {
                        if (bl) {
                            stringBuilder.append("\\{");
                            break;
                        }
                        stringBuilder.append('(');
                        ++n;
                        break;
                    }
                    case '}': {
                        if (bl) {
                            stringBuilder.append("\\}");
                            break;
                        }
                        if (n > 0) {
                            stringBuilder.append(')');
                            --n;
                            break;
                        }
                        stringBuilder.append("}");
                        break;
                    }
                    case ',': {
                        if (bl) {
                            stringBuilder.append("\\,");
                            break;
                        }
                        if (n > 0) {
                            stringBuilder.append('|');
                            break;
                        }
                        stringBuilder.append(',');
                        break;
                    }
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '@': 
                    case '^': 
                    case '|': {
                        stringBuilder.append('\\');
                        stringBuilder.append(c);
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
                bl = !bl && c == '\\';
            }
            return stringBuilder.toString();
        }

        public boolean accept(File file) {
            Matcher matcher = this.m_regex.matcher(file.getName());
            boolean bl = matcher.matches();
            return bl;
        }
    }
}

