/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.core.VStatement;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dataengine.VParameterMetadata;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dataengine.VResultSet;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.dataengine.impl.DSIDataEngine;
import com.vertica.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.exceptions.ParsingErrorID;
import com.vertica.dsi.exceptions.ParsingException;
import com.vertica.io.CommandDescriptionResponseMessage;
import com.vertica.io.DescribeRequestMessage;
import com.vertica.io.ErrorResponseMessage;
import com.vertica.io.FlushRequestMessage;
import com.vertica.io.MessageType;
import com.vertica.io.ParameterDescriptionResponseMessage;
import com.vertica.io.ParseRequestMessage;
import com.vertica.io.ProtocolStream;
import com.vertica.io.ResponseMessage;
import com.vertica.io.RowDescriptionResponseMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.parser.ParsedQuery;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.ServerErrorData;
import com.vertica.util.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VDataEngine
extends DSIDataEngine {
    private VStatement m_statement;
    private DSILogger m_log;
    private ProtocolStream m_protocolStream;
    private VConnection m_connection;
    private boolean m_isPrepared;
    private boolean m_isInternal;
    private boolean m_needsResultBeforeExecute;

    public VDataEngine(VStatement vStatement, boolean bl) {
        super(vStatement);
        this.m_statement = vStatement;
        this.m_connection = vStatement.getConnection();
        this.m_protocolStream = this.m_connection.getProtocolStream();
        this.m_needsResultBeforeExecute = !bl;
        this.m_isInternal = bl;
        this.m_isPrepared = true;
        this.m_log = this.m_connection.getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_log, vStatement, bl);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void setDirectExecute() {
        this.m_isPrepared = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VQueryExecutor prepareImpl(String string, boolean bl) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_log, string, bl);
        if (!this.m_isInternal) {
            object = new ParsedQuery(string, this.m_connection.useStandardConformingStrings(), this.m_statement.getMaxRows());
            ((ParsedQuery)object).parse();
            string = ((ParsedQuery)object).toString();
        }
        object = new LinkedList();
        String string2 = "";
        boolean bl2 = false;
        VConnection vConnection = this.m_connection;
        synchronized (vConnection) {
            try {
                Object object2;
                this.m_protocolStream.setWarningListener(this.getWarningListener());
                this.m_connection.ensureNotInLRS(string, this.m_statement.getResultBufferSize());
                try {
                    this.m_connection.endCurrentCopy();
                }
                catch (ErrorException errorException) {
                    bl2 = true;
                    throw errorException;
                }
                this.m_connection.executeLRSWorkQueue();
                if (this.m_isPrepared) {
                    string2 = this.m_statement.makeStatementName();
                    int n = 0;
                    int[] nArray = new int[n];
                    Arrays.fill(nArray, 0);
                    this.m_protocolStream.sendMessage(new ParseRequestMessage(string2, string, nArray));
                    this.m_protocolStream.sendMessage(new DescribeRequestMessage(false, string2));
                    this.m_protocolStream.sendMessage(new FlushRequestMessage());
                    this.m_protocolStream.readExpectedMessage(ParseRequestMessage.LEGAL_RESPONSE);
                    ParameterDescriptionResponseMessage parameterDescriptionResponseMessage = (ParameterDescriptionResponseMessage)this.m_protocolStream.readExpectedMessage(DescribeRequestMessage.LEGAL_RESPONSE_STEP1);
                    int[] nArray2 = parameterDescriptionResponseMessage.getParameterTypes();
                    int[] nArray3 = parameterDescriptionResponseMessage.getParameterTypmods();
                    boolean[] blArray = parameterDescriptionResponseMessage.getParameterNotNulls();
                    assert (nArray2.length == nArray3.length);
                    assert (nArray2.length == blArray.length);
                    ResponseMessage responseMessage = this.m_protocolStream.readExpectedMessage(DescribeRequestMessage.LEGAL_RESPONSES_STEP2);
                    ArrayList<ColumnDescription> arrayList = responseMessage.getType().equals((Object)MessageType.RowDescription) ? ((RowDescriptionResponseMessage)responseMessage).getRowDescription() : VResultSet.PSEUDO_ROWCOUNT_DESCRIPTION;
                    CommandDescriptionResponseMessage commandDescriptionResponseMessage = (CommandDescriptionResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.CommandDescription);
                    String string3 = commandDescriptionResponseMessage.getTag();
                    ((LinkedList)object).add(string3);
                    if ("".equals(string3)) {
                        throw new ParsingException(ParsingErrorID.SYNTAX_ERR_OR_ACCESS_VIOLATION, 101, VMessageKey.ERROR_EMPTY_QUERY_NOT_SUPPORTED.toString());
                    }
                    if ("COPY_LOCAL".equals(string3)) {
                        if (nArray2.length != 0) throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_PREPARED_COPY_NOT_SUPPORTED.toString());
                        this.m_statement.fallbackToUnnamed();
                        this.m_isPrepared = false;
                        VQueryExecutor vQueryExecutor = this.prepareImpl(string, bl);
                        return vQueryExecutor;
                    }
                    boolean bl3 = commandDescriptionResponseMessage.hasCopyRewrite() && nArray2.length > 0;
                    ArrayList<ParameterMetadata> arrayList2 = new ArrayList<ParameterMetadata>();
                    boolean bl4 = this.m_connection.useStringBatchInserts();
                    for (int i = 0; i < nArray2.length; ++i) {
                        VParameterMetadata vParameterMetadata = new VParameterMetadata(i + 1, ParameterType.INPUT, TypeUtils.createTypeMetadata(nArray2[i], nArray3[i]), TypeUtils.getColumnSize(nArray2[i], nArray3[i]), TypeUtils.getTypeName(nArray2[i], nArray3[i]), true, blArray[i] ? Nullable.NO_NULLS : Nullable.NULLABLE, nArray2[i]);
                        vParameterMetadata.setConvertInputToString(bl4 && nArray2[i] != 15 && nArray2[i] != 11 && nArray2[i] != 12 && nArray2[i] != 13 && nArray2[i] != 116 && nArray2[i] != 117 && nArray2[i] != 17);
                        arrayList2.add(vParameterMetadata);
                    }
                    if (bl3) {
                        string = commandDescriptionResponseMessage.getCopyRewrite();
                    }
                    VQueryExecutor vQueryExecutor = new VQueryExecutor(this.m_statement, string, string2, arrayList2, arrayList, (List<String>)object, false, !bl3);
                    return vQueryExecutor;
                }
                this.m_protocolStream.sendMessage(new ParseRequestMessage(string2, string, new int[0]));
                this.m_protocolStream.sendMessage(new FlushRequestMessage());
                ResponseMessage responseMessage = this.m_protocolStream.readMessage();
                while (responseMessage.getType().equals((Object)MessageType.CommandDescription)) {
                    object2 = ((CommandDescriptionResponseMessage)responseMessage).getTag();
                    ((LinkedList)object).add(object2);
                    responseMessage = this.m_protocolStream.readMessage();
                }
                if (responseMessage.getType().equals((Object)MessageType.Error)) {
                    object2 = ((ErrorResponseMessage)responseMessage).getErrorData();
                    throw ((ServerErrorData)object2).buildException();
                }
                object2 = new VQueryExecutor(this.m_statement, string, (List<String>)object, bl);
                return object2;
            }
            catch (ErrorException errorException) {
                this.m_connection.handleError(!bl2, errorException);
                throw errorException;
            }
            finally {
                this.m_protocolStream.clearWarningListener();
            }
        }
    }

    @Override
    public VQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        return this.prepareImpl(string, false);
    }

    @Override
    public VQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        StringBuilder stringBuilder = new StringBuilder(2048);
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        return this.prepareImpl(stringBuilder.toString(), true);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        IMetadataSource iMetadataSource;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[]{metadataSourceID, map});
        switch (metadataSourceID) {
            case CATALOG_ONLY: 
            case CATALOG_SCHEMA_ONLY: 
            case COLUMNS: 
            case COLUMN_PRIVILEGES: 
            case FOREIGN_KEYS: 
            case PRIMARY_KEYS: 
            case PROCEDURES: 
            case PROCEDURE_COLUMNS: 
            case SCHEMA_ONLY: 
            case SPECIAL_COLUMNS: 
            case TABLES: 
            case TABLETYPE_ONLY: 
            case TABLE_PRIVILEGES: 
            case TYPE_INFO: {
                iMetadataSource = this.m_connection.getMetadataSource(metadataSourceID, map, string, string2, bl);
                break;
            }
            default: {
                iMetadataSource = new DSIEmptyMetadataSource(this.m_log);
            }
        }
        return iMetadataSource;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl) throws ErrorException {
        if (!this.m_connection.getUseStrictCatalogFiltering() && arrayList.size() > 0 && "".equals(arrayList.get(0)) && (MetadataSourceID.TABLES.equals((Object)metadataSourceID) || MetadataSourceID.COLUMNS.equals((Object)metadataSourceID))) {
            arrayList.set(0, null);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl);
    }
}

