/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.sst;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FileBackedList
implements AutoCloseable {
    private final List<Long> pointers = new ArrayList<Long>();
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final Map<Integer, String> cache;
    private long filesize;

    public FileBackedList(File file, final int n) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.channel = this.raf.getChannel();
        this.filesize = this.raf.length();
        this.cache = new LinkedHashMap<Integer, String>(n, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry entry) {
                return this.size() > n;
            }
        };
    }

    public void add(String string) {
        try {
            this.writeToFile(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getAt(int n) {
        if (this.cache.containsKey(n)) {
            return this.cache.get(n);
        }
        try {
            String string = this.readFromFile(this.pointers.get(n));
            this.cache.put(n, string);
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String string) throws IOException {
        FileChannel fileChannel = this.channel;
        synchronized (fileChannel) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes(StandardCharsets.UTF_8));
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4).putInt(byteBuffer.array().length);
            this.channel.position(this.filesize);
            this.pointers.add(this.channel.position());
            byteBuffer2.flip();
            this.channel.write(byteBuffer2);
            this.channel.write(byteBuffer);
            this.filesize += (long)(4 + byteBuffer.array().length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromFile(long l) throws IOException {
        FileChannel fileChannel = this.channel;
        synchronized (fileChannel) {
            FileChannel fileChannel2 = this.channel.position(l);
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[4]);
            fileChannel2.read(byteBuffer);
            byteBuffer.flip();
            int n = byteBuffer.getInt();
            byteBuffer = ByteBuffer.wrap(new byte[n]);
            fileChannel2.read(byteBuffer);
            byteBuffer.flip();
            return new String(byteBuffer.array(), StandardCharsets.UTF_8);
        }
    }

    @Override
    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

