/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.NotSupportedException;
import com.monitorjbl.xlsx.impl.Supplier;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class StreamingCell
implements Cell {
    private static final Supplier NULL_SUPPLIER = new Supplier(){

        @Override
        public Object getContent() {
            return null;
        }
    };
    private static final String FALSE_AS_STRING = "0";
    private static final String TRUE_AS_STRING = "1";
    private int columnIndex;
    private int rowIndex;
    private final boolean use1904Dates;
    private Supplier contentsSupplier = NULL_SUPPLIER;
    private Object rawContents;
    private String formula;
    private String numericFormat;
    private Short numericFormatIndex;
    private String type;
    private Row row;
    private CellStyle cellStyle;
    private boolean formulaType;

    public StreamingCell(int n, int n2, boolean bl) {
        this.columnIndex = n;
        this.rowIndex = n2;
        this.use1904Dates = bl;
    }

    @Override
    public void setBlank() {
    }

    public void setContentSupplier(Supplier supplier) {
        this.contentsSupplier = supplier;
    }

    public void setRawContents(Object object) {
        this.rawContents = object;
    }

    public String getNumericFormat() {
        return this.numericFormat;
    }

    public void setNumericFormat(String string) {
        this.numericFormat = string;
    }

    public Short getNumericFormatIndex() {
        return this.numericFormatIndex;
    }

    public void setNumericFormatIndex(Short s) {
        this.numericFormatIndex = s;
    }

    public void setFormula(String string) {
        this.formula = string;
    }

    @Override
    public void removeFormula() {
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isFormulaType() {
        return this.formulaType;
    }

    public void setFormulaType(boolean bl) {
        this.formulaType = bl;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    @Override
    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public Row getRow() {
        return this.row;
    }

    @Override
    public CellType getCellType() {
        if (this.formulaType) {
            return CellType.FORMULA;
        }
        if (this.contentsSupplier.getContent() == null || this.type == null) {
            return CellType.BLANK;
        }
        if ("n".equals(this.type)) {
            return CellType.NUMERIC;
        }
        if ("s".equals(this.type) || "inlineStr".equals(this.type) || "str".equals(this.type)) {
            return CellType.STRING;
        }
        if ("str".equals(this.type)) {
            return CellType.FORMULA;
        }
        if ("b".equals(this.type)) {
            return CellType.BOOLEAN;
        }
        if ("e".equals(this.type)) {
            return CellType.ERROR;
        }
        throw new UnsupportedOperationException("Unsupported cell type '" + this.type + "'");
    }

    @Override
    @Deprecated
    public CellType getCellTypeEnum() {
        return this.getCellType();
    }

    @Override
    public String getStringCellValue() {
        Object object = this.contentsSupplier.getContent();
        return object == null ? "" : object.toString();
    }

    @Override
    public double getNumericCellValue() {
        return this.rawContents == null ? 0.0 : Double.parseDouble((String)this.rawContents);
    }

    @Override
    public Date getDateCellValue() {
        if (this.getCellType() == CellType.STRING) {
            throw new IllegalStateException("Cell type cannot be CELL_TYPE_STRING");
        }
        return this.rawContents == null ? null : HSSFDateUtil.getJavaDate(this.getNumericCellValue(), this.use1904Dates);
    }

    @Override
    public boolean getBooleanCellValue() {
        CellType cellType = this.getCellType();
        switch (cellType) {
            case BLANK: {
                return false;
            }
            case BOOLEAN: {
                return this.rawContents != null && TRUE_AS_STRING.equals(this.rawContents);
            }
            case FORMULA: {
                throw new NotSupportedException();
            }
        }
        throw StreamingCell.typeMismatch(CellType.BOOLEAN, cellType, false);
    }

    private static RuntimeException typeMismatch(CellType cellType, CellType cellType2, boolean bl) {
        String string = "Cannot get a " + StreamingCell.getCellTypeName(cellType) + " value from a " + StreamingCell.getCellTypeName(cellType2) + " " + (bl ? "formula " : "") + "cell";
        return new IllegalStateException(string);
    }

    private static String getCellTypeName(CellType cellType) {
        switch (cellType) {
            case BLANK: {
                return "blank";
            }
            case STRING: {
                return "text";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case ERROR: {
                return "error";
            }
            case NUMERIC: {
                return "numeric";
            }
            case FORMULA: {
                return "formula";
            }
        }
        return "#unknown cell type (" + (Object)((Object)cellType) + ")#";
    }

    @Override
    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    @Override
    public String getCellFormula() {
        if (!this.formulaType) {
            throw new IllegalStateException("This cell does not have a formula");
        }
        return this.formula;
    }

    @Override
    public CellType getCachedFormulaResultType() {
        if (this.formulaType) {
            if (this.contentsSupplier.getContent() == null || this.type == null) {
                return CellType.BLANK;
            }
            if ("n".equals(this.type)) {
                return CellType.NUMERIC;
            }
            if ("s".equals(this.type) || "inlineStr".equals(this.type) || "str".equals(this.type)) {
                return CellType.STRING;
            }
            if ("b".equals(this.type)) {
                return CellType.BOOLEAN;
            }
            if ("e".equals(this.type)) {
                return CellType.ERROR;
            }
            throw new UnsupportedOperationException("Unsupported cell type '" + this.type + "'");
        }
        throw new IllegalStateException("Only formula cells have cached results");
    }

    @Override
    @Deprecated
    public CellType getCachedFormulaResultTypeEnum() {
        return this.getCachedFormulaResultType();
    }

    @Override
    public void setCellType(CellType cellType) {
        throw new NotSupportedException();
    }

    @Override
    public Sheet getSheet() {
        throw new NotSupportedException();
    }

    @Override
    public void setCellValue(double d) {
        throw new NotSupportedException();
    }

    @Override
    public void setCellValue(Date date) {
        throw new NotSupportedException();
    }

    @Override
    public void setCellValue(Calendar calendar) {
        throw new NotSupportedException();
    }

    @Override
    public void setCellValue(RichTextString richTextString) {
        throw new NotSupportedException();
    }

    @Override
    public void setCellValue(String string) {
        throw new NotSupportedException();
    }

    @Override
    public void setCellFormula(String string) throws FormulaParseException {
        throw new NotSupportedException();
    }

    @Override
    public XSSFRichTextString getRichStringCellValue() {
        XSSFRichTextString xSSFRichTextString;
        CellType cellType = this.getCellType();
        switch (cellType) {
            case BLANK: {
                xSSFRichTextString = new XSSFRichTextString("");
                break;
            }
            case STRING: {
                xSSFRichTextString = new XSSFRichTextString(this.getStringCellValue());
                break;
            }
            default: {
                throw new NotSupportedException();
            }
        }
        return xSSFRichTextString;
    }

    @Override
    public void setCellValue(boolean bl) {
        throw new NotSupportedException();
    }

    @Override
    public void setCellValue(LocalDateTime localDateTime) {
    }

    @Override
    public LocalDateTime getLocalDateTimeCellValue() {
        throw new NotSupportedException();
    }

    @Override
    public void setCellErrorValue(byte by) {
        throw new NotSupportedException();
    }

    @Override
    public byte getErrorCellValue() {
        throw new NotSupportedException();
    }

    @Override
    public void setAsActiveCell() {
        throw new NotSupportedException();
    }

    @Override
    public CellAddress getAddress() {
        throw new NotSupportedException();
    }

    @Override
    public void setCellComment(Comment comment) {
        throw new NotSupportedException();
    }

    @Override
    public Comment getCellComment() {
        throw new NotSupportedException();
    }

    @Override
    public void removeCellComment() {
        throw new NotSupportedException();
    }

    @Override
    public Hyperlink getHyperlink() {
        throw new NotSupportedException();
    }

    @Override
    public void setHyperlink(Hyperlink hyperlink) {
        throw new NotSupportedException();
    }

    @Override
    public void removeHyperlink() {
        throw new NotSupportedException();
    }

    @Override
    public CellRangeAddress getArrayFormulaRange() {
        throw new NotSupportedException();
    }

    @Override
    public boolean isPartOfArrayFormulaGroup() {
        throw new NotSupportedException();
    }
}

