/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx;

import com.monitorjbl.xlsx.XmlUtils;
import com.monitorjbl.xlsx.exceptions.MissingSheetException;
import com.monitorjbl.xlsx.exceptions.OpenException;
import com.monitorjbl.xlsx.exceptions.ReadException;
import com.monitorjbl.xlsx.impl.StreamingSheetReader;
import com.monitorjbl.xlsx.impl.StreamingWorkbook;
import com.monitorjbl.xlsx.impl.StreamingWorkbookReader;
import com.monitorjbl.xlsx.impl.TempFileUtil;
import com.monitorjbl.xlsx.sst.BufferedStringsTable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.StaxHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.w3c.dom.NodeList;

public class StreamingReader
implements Iterable<Row>,
AutoCloseable {
    private File tmp;
    private final StreamingWorkbookReader workbook;

    public StreamingReader(StreamingWorkbookReader streamingWorkbookReader) {
        this.workbook = streamingWorkbookReader;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.workbook.first().iterator();
    }

    @Override
    public void close() throws IOException {
        try {
            this.workbook.close();
        }
        finally {
            if (this.tmp != null) {
                this.tmp.delete();
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int rowCacheSize = 10;
        private int bufferSize = 1024;
        private int sheetIndex = 0;
        private int sstCacheSize = -1;
        private String sheetName;
        private String password;

        public int getRowCacheSize() {
            return this.rowCacheSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public String getPassword() {
            return this.password;
        }

        public int getSstCacheSize() {
            return this.sstCacheSize;
        }

        public Builder rowCacheSize(int n) {
            this.rowCacheSize = n;
            return this;
        }

        public Builder bufferSize(int n) {
            this.bufferSize = n;
            return this;
        }

        public Builder sheetIndex(int n) {
            this.sheetIndex = n;
            return this;
        }

        public Builder sheetName(String string) {
            this.sheetName = string;
            return this;
        }

        public Builder password(String string) {
            this.password = string;
            return this;
        }

        public Builder sstCacheSize(int n) {
            this.sstCacheSize = n;
            return this;
        }

        public Workbook open(InputStream inputStream) {
            StreamingWorkbookReader streamingWorkbookReader = new StreamingWorkbookReader(this);
            streamingWorkbookReader.init(inputStream);
            return new StreamingWorkbook(streamingWorkbookReader);
        }

        public Workbook open(File file) {
            StreamingWorkbookReader streamingWorkbookReader = new StreamingWorkbookReader(this);
            streamingWorkbookReader.init(file);
            return new StreamingWorkbook(streamingWorkbookReader);
        }

        public StreamingReader read(InputStream inputStream) {
            File file = null;
            try {
                file = TempFileUtil.writeInputStreamToFile(inputStream, this.bufferSize);
                StreamingReader streamingReader = this.read(file);
                streamingReader.tmp = file;
                return streamingReader;
            }
            catch (IOException iOException) {
                throw new ReadException("Unable to read input stream", iOException);
            }
            catch (RuntimeException runtimeException) {
                file.delete();
                throw runtimeException;
            }
        }

        public StreamingReader read(File file) {
            try {
                Object object;
                OPCPackage oPCPackage;
                Object object2;
                Object object3;
                if (this.password != null) {
                    POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(file);
                    object3 = new EncryptionInfo(pOIFSFileSystem);
                    object2 = Decryptor.getInstance((EncryptionInfo)object3);
                    ((Decryptor)object2).verifyPassword(this.password);
                    oPCPackage = OPCPackage.open(((Decryptor)object2).getDataStream(pOIFSFileSystem));
                } else {
                    oPCPackage = OPCPackage.open(file);
                }
                boolean bl = false;
                object3 = new XSSFReader(oPCPackage);
                File file2 = null;
                if (this.sstCacheSize > 0) {
                    file2 = Files.createTempFile("", "", new FileAttribute[0]).toFile();
                    object2 = BufferedStringsTable.getSharedStringsTable(file2, this.sstCacheSize, oPCPackage);
                } else {
                    object2 = ((XSSFReader)object3).getSharedStringsTable();
                }
                StylesTable stylesTable = ((XSSFReader)object3).getStylesTable();
                NodeList nodeList = XmlUtils.searchForNodeList(XmlUtils.document(((XSSFReader)object3).getWorkbookData()), "/workbook/workbookPr");
                if (nodeList.getLength() == 1 && (object = nodeList.item(0).getAttributes().getNamedItem("date1904")) != null) {
                    bl = "1".equals(object.getTextContent());
                }
                if ((object = this.findSheet((XSSFReader)object3)) == null) {
                    throw new MissingSheetException("Unable to find sheet at index [" + this.sheetIndex + "]");
                }
                XMLEventReader xMLEventReader = StaxHelper.newXMLInputFactory().createXMLEventReader((InputStream)object);
                return new StreamingReader(new StreamingWorkbookReader((SharedStringsTable)object2, file2, oPCPackage, new StreamingSheetReader((SharedStringsTable)object2, stylesTable, xMLEventReader, bl, this.rowCacheSize), this));
            }
            catch (IOException iOException) {
                throw new OpenException("Failed to open file", iOException);
            }
            catch (XMLStreamException | OpenXML4JException exception) {
                throw new ReadException("Unable to read workbook", exception);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ReadException("Unable to read workbook - Decryption failed", generalSecurityException);
            }
        }

        private InputStream findSheet(XSSFReader xSSFReader) throws IOException, InvalidFormatException {
            Object object;
            int n = this.sheetIndex;
            if (this.sheetName != null) {
                n = -1;
                object = XmlUtils.searchForNodeList(XmlUtils.document(xSSFReader.getWorkbookData()), "/workbook/sheets/sheet");
                for (int i = 0; i < object.getLength(); ++i) {
                    if (!Objects.equals(object.item(i).getAttributes().getNamedItem("name").getTextContent(), this.sheetName)) continue;
                    n = i;
                }
                if (n < 0) {
                    return null;
                }
            }
            object = xSSFReader.getSheetsData();
            InputStream inputStream = null;
            int n2 = 0;
            while (object.hasNext()) {
                InputStream inputStream2 = (InputStream)object.next();
                if (n2++ != n) continue;
                inputStream = inputStream2;
                break;
            }
            return inputStream;
        }
    }
}

