/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.tx.CommitDecisionMaker;
import org.h2.mvstore.tx.RollbackDecisionMaker;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.tx.VersionedBitSet;
import org.h2.mvstore.tx.VersionedValueType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.util.StringUtils;
import org.h2.value.VersionedValue;

public class TransactionStore {
    final MVStore store;
    private final int timeoutMillis;
    private final MVMap<Integer, Object[]> preparedTransactions;
    final MVMap<Long, Object[]>[] undoLogs = new MVMap[65535];
    private final MVMap.Builder<Long, Object[]> undoLogBuilder;
    private final MVMap.Builder<Object, VersionedValue> mapBuilder;
    final AtomicReference<VersionedBitSet> openTransactions = new AtomicReference<VersionedBitSet>(new VersionedBitSet());
    final AtomicReference<BitSet> committingTransactions = new AtomicReference<BitSet>(new BitSet());
    private boolean init;
    private int maxTransactionId = 65535;
    private final AtomicReferenceArray<Transaction> transactions = new AtomicReferenceArray(65536);
    private static final String UNDO_LOG_NAME_PREFIX = "undoLog";
    private static final char UNDO_LOG_COMMITTED = '-';
    private static final char UNDO_LOG_OPEN = '.';
    private static final int MAX_OPEN_TRANSACTIONS = 65535;
    private static final int LOG_ID_BITS = 40;
    private static final long LOG_ID_MASK = 0xFFFFFFFFFFL;
    private static final RollbackListener ROLLBACK_LISTENER_NONE = new RollbackListener(){

        @Override
        public void onRollback(MVMap<Object, VersionedValue> mVMap, Object object, VersionedValue versionedValue, VersionedValue versionedValue2) {
        }
    };

    public static String getUndoLogName(boolean bl, int n) {
        return UNDO_LOG_NAME_PREFIX + (bl ? (char)'-' : '.') + (n > 0 ? String.valueOf(n) : "");
    }

    public TransactionStore(MVStore mVStore) {
        this(mVStore, new ObjectDataType(), 0);
    }

    public TransactionStore(MVStore mVStore, DataType dataType, int n) {
        this.store = mVStore;
        this.timeoutMillis = n;
        this.preparedTransactions = mVStore.openMap("openTransactions", new MVMap.Builder());
        VersionedValueType versionedValueType = new VersionedValueType(dataType);
        ArrayType arrayType = new ArrayType(new DataType[]{new ObjectDataType(), dataType, versionedValueType});
        this.undoLogBuilder = new MVMap.Builder().singleWriter().valueType(arrayType);
        VersionedValueType versionedValueType2 = new VersionedValueType(dataType);
        this.mapBuilder = ((MVMap.Builder)new MVMap.Builder().keyType(dataType)).valueType(versionedValueType2);
    }

    public void init() {
        if (!this.init) {
            for (String string : this.store.getMapNames()) {
                if (!string.startsWith(UNDO_LOG_NAME_PREFIX)) continue;
                if (string.length() > UNDO_LOG_NAME_PREFIX.length()) {
                    boolean bl;
                    boolean bl2 = bl = string.charAt(UNDO_LOG_NAME_PREFIX.length()) == '-';
                    if (this.store.hasData(string) || bl) {
                        int n = StringUtils.parseUInt31(string, UNDO_LOG_NAME_PREFIX.length() + 1, string.length());
                        VersionedBitSet versionedBitSet = this.openTransactions.get();
                        if (!versionedBitSet.get(n)) {
                            String string2;
                            int n2;
                            Object[] objectArray = this.preparedTransactions.get(n);
                            if (objectArray == null) {
                                n2 = 1;
                                string2 = null;
                            } else {
                                n2 = (Integer)objectArray[0];
                                string2 = (String)objectArray[1];
                            }
                            if (bl) {
                                n2 = 3;
                            }
                            Object m = this.store.openMap(string, this.undoLogBuilder);
                            this.undoLogs[n] = m;
                            Long l = (Long)((MVMap)m).lastKey();
                            assert (bl || l != null);
                            assert (bl || TransactionStore.getTransactionId(l) == n);
                            long l2 = l == null ? 0L : TransactionStore.getLogId(l) + 1L;
                            this.registerTransaction(n, n2, string2, l2, this.timeoutMillis, 0, ROLLBACK_LISTENER_NONE);
                            continue;
                        }
                    }
                }
                if (this.store.isReadOnly()) continue;
                this.store.removeMap(string);
            }
            this.init = true;
        }
    }

    public void endLeftoverTransactions() {
        List<Transaction> list = this.getOpenTransactions();
        for (Transaction transaction : list) {
            int n = transaction.getStatus();
            if (n == 3) {
                transaction.commit();
                continue;
            }
            if (n == 2) continue;
            transaction.rollback();
        }
    }

    public void setMaxTransactionId(int n) {
        DataUtils.checkArgument(n <= 65535, "Concurrent transactions limit is too high: {0}", n);
        this.maxTransactionId = n;
    }

    public boolean hasMap(String string) {
        return this.store.hasMap(string);
    }

    static long getOperationId(int n, long l) {
        DataUtils.checkArgument(n >= 0 && n < 0x1000000, "Transaction id out of range: {0}", n);
        DataUtils.checkArgument(l >= 0L && l <= 0xFFFFFFFFFFL, "Transaction log id out of range: {0}", l);
        return (long)n << 40 | l;
    }

    static int getTransactionId(long l) {
        return (int)(l >>> 40);
    }

    static long getLogId(long l) {
        return l & 0xFFFFFFFFFFL;
    }

    public List<Transaction> getOpenTransactions() {
        if (!this.init) {
            this.init();
        }
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        int n = 0;
        BitSet bitSet = this.openTransactions.get();
        while ((n = bitSet.nextSetBit(n + 1)) > 0) {
            Transaction transaction = this.getTransaction(n);
            if (transaction == null || transaction.getStatus() == 0) continue;
            arrayList.add(transaction);
        }
        return arrayList;
    }

    public synchronized void close() {
        this.store.commit();
    }

    public Transaction begin() {
        return this.begin(ROLLBACK_LISTENER_NONE, this.timeoutMillis, 0);
    }

    public Transaction begin(RollbackListener rollbackListener, int n, int n2) {
        if (n <= 0) {
            n = this.timeoutMillis;
        }
        Transaction transaction = this.registerTransaction(0, 1, null, 0L, n, n2, rollbackListener);
        return transaction;
    }

    private Transaction registerTransaction(int n, int n2, String string, long l, int n3, int n4, RollbackListener rollbackListener) {
        long l2;
        int n5;
        Object object;
        Object object2;
        boolean bl;
        do {
            object2 = this.openTransactions.get();
            if (n == 0) {
                n5 = ((BitSet)object2).nextClearBit(1);
            } else {
                n5 = n;
                assert (!((BitSet)object2).get(n5));
            }
            if (n5 > this.maxTransactionId) {
                throw DataUtils.newIllegalStateException(102, "There are {0} open transactions", n5 - 1);
            }
            object = ((VersionedBitSet)object2).clone();
            ((BitSet)object).set(n5);
            l2 = ((VersionedBitSet)object).getVersion() + 1L;
            ((VersionedBitSet)object).setVersion(l2);
        } while (!(bl = this.openTransactions.compareAndSet((VersionedBitSet)object2, (VersionedBitSet)object)));
        object2 = new Transaction(this, n5, l2, n2, string, l, n3, n4, rollbackListener);
        assert (this.transactions.get(n5) == null);
        this.transactions.set(n5, (Transaction)object2);
        if (this.undoLogs[n5] == null) {
            object = TransactionStore.getUndoLogName(n2 == 3, n5);
            Object m = this.store.openMap((String)object, this.undoLogBuilder);
            this.undoLogs[n5] = m;
        }
        return object2;
    }

    void storeTransaction(Transaction transaction) {
        if (transaction.getStatus() == 2 || transaction.getName() != null) {
            Object[] objectArray = new Object[]{transaction.getStatus(), transaction.getName()};
            this.preparedTransactions.put(transaction.getId(), objectArray);
            transaction.wasStored = true;
        }
    }

    long addUndoLogRecord(int n, long l, Object[] objectArray) {
        MVMap<Long, Object[]> mVMap = this.undoLogs[n];
        long l2 = TransactionStore.getOperationId(n, l);
        if (l == 0L && !mVMap.isEmpty()) {
            throw DataUtils.newIllegalStateException(102, "An old transaction with the same id is still open: {0}", n);
        }
        mVMap.append(l2, objectArray);
        return l2;
    }

    void removeUndoLogRecord(int n) {
        this.undoLogs[n].trimLast();
    }

    <K, V> void removeMap(TransactionMap<K, V> transactionMap) {
        this.store.removeMap(transactionMap.map, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Transaction transaction, boolean bl) {
        if (!this.store.isClosed()) {
            int n = transaction.transactionId;
            this.flipCommittingTransactionsBit(n, true);
            CommitDecisionMaker commitDecisionMaker = new CommitDecisionMaker();
            try {
                MVMap<Long, Object[]> mVMap = this.undoLogs[n];
                if (!bl) {
                    this.store.renameMap(mVMap, TransactionStore.getUndoLogName(true, n));
                }
                try {
                    Cursor<Object, Object[]> cursor = mVMap.cursor(null);
                    while (cursor.hasNext()) {
                        Long l = cursor.next();
                        Object[] objectArray = cursor.getValue();
                        int n2 = (Integer)objectArray[0];
                        MVMap<Object, VersionedValue> mVMap2 = this.openMap(n2);
                        if (mVMap2 == null) continue;
                        Object object = objectArray[1];
                        commitDecisionMaker.setUndoKey(l);
                        mVMap2.operate(object, VersionedValue.DUMMY, commitDecisionMaker);
                    }
                    mVMap.clear();
                }
                finally {
                    this.store.renameMap(mVMap, TransactionStore.getUndoLogName(false, n));
                }
            }
            finally {
                this.flipCommittingTransactionsBit(n, false);
            }
        }
    }

    private void flipCommittingTransactionsBit(int n, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2;
        boolean bl2;
        do {
            bitSet2 = this.committingTransactions.get();
            assert (bitSet2.get(n) != bl) : bl ? "Double commit" : "Mysterious bit's disappearance";
            bitSet = (BitSet)bitSet2.clone();
            bitSet.set(n, bl);
        } while (!(bl2 = this.committingTransactions.compareAndSet(bitSet2, bitSet)));
    }

    <K> MVMap<K, VersionedValue> openMap(String string, DataType dataType, DataType dataType2) {
        if (dataType == null) {
            dataType = new ObjectDataType();
        }
        if (dataType2 == null) {
            dataType2 = new ObjectDataType();
        }
        VersionedValueType versionedValueType = new VersionedValueType(dataType2);
        MVMap.BasicBuilder basicBuilder = ((MVMap.Builder)new MVMap.Builder().keyType(dataType)).valueType(versionedValueType);
        Object m = this.store.openMap(string, basicBuilder);
        return m;
    }

    MVMap<Object, VersionedValue> openMap(int n) {
        MVMap<Object, VersionedValue> mVMap = this.store.getMap(n);
        if (mVMap == null) {
            String string = this.store.getMapName(n);
            if (string == null) {
                return null;
            }
            mVMap = this.store.openMap(string, this.mapBuilder);
        }
        return mVMap;
    }

    void endTransaction(Transaction transaction, boolean bl) {
        VersionedBitSet versionedBitSet;
        VersionedBitSet versionedBitSet2;
        boolean bl2;
        transaction.closeIt();
        int n = transaction.transactionId;
        this.transactions.set(n, null);
        do {
            versionedBitSet2 = this.openTransactions.get();
            assert (versionedBitSet2.get(n));
            versionedBitSet = versionedBitSet2.clone();
            versionedBitSet.clear(n);
        } while (!(bl2 = this.openTransactions.compareAndSet(versionedBitSet2, versionedBitSet)));
        if (bl) {
            int n2;
            int n3;
            boolean bl3 = transaction.wasStored;
            if (bl3 && !this.preparedTransactions.isClosed()) {
                this.preparedTransactions.remove(n);
            }
            if (bl3 || this.store.getAutoCommitDelay() == 0) {
                this.store.tryCommit();
            } else if (this.isUndoEmpty() && (n3 = this.store.getUnsavedMemory()) * 4 > (n2 = this.store.getAutoCommitMemory()) * 3) {
                this.store.tryCommit();
            }
        }
    }

    private boolean isUndoEmpty() {
        BitSet bitSet = this.openTransactions.get();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            MVMap<Long, Object[]> mVMap = this.undoLogs[n];
            if (mVMap != null && !mVMap.isEmpty()) {
                return false;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return true;
    }

    Transaction getTransaction(int n) {
        return this.transactions.get(n);
    }

    void rollbackTo(Transaction transaction, long l, long l2) {
        int n = transaction.getId();
        MVMap<Long, Object[]> mVMap = this.undoLogs[n];
        RollbackDecisionMaker rollbackDecisionMaker = new RollbackDecisionMaker(this, n, l2, transaction.listener);
        for (long i = l - 1L; i >= l2; --i) {
            Long l3 = TransactionStore.getOperationId(n, i);
            mVMap.operate(l3, null, rollbackDecisionMaker);
            rollbackDecisionMaker.reset();
        }
    }

    Iterator<Change> getChanges(final Transaction transaction, final long l, final long l2) {
        final MVMap<Long, Object[]> mVMap = this.undoLogs[transaction.getId()];
        return new Iterator<Change>(){
            private long logId;
            private Change current;
            {
                this.logId = l - 1L;
            }

            private void fetchNext() {
                int n = transaction.getId();
                while (this.logId >= l2) {
                    Long l3 = TransactionStore.getOperationId(n, this.logId);
                    Object[] objectArray = (Object[])mVMap.get(l3);
                    --this.logId;
                    if (objectArray == null) {
                        if ((l3 = mVMap.floorKey(l3)) == null || TransactionStore.getTransactionId(l3) != n) break;
                        this.logId = TransactionStore.getLogId(l3);
                        continue;
                    }
                    int n2 = (Integer)objectArray[0];
                    MVMap<Object, VersionedValue> mVMap2 = TransactionStore.this.openMap(n2);
                    if (mVMap2 == null) continue;
                    VersionedValue versionedValue = (VersionedValue)objectArray[2];
                    this.current = new Change(mVMap2.getName(), objectArray[1], versionedValue == null ? null : versionedValue.getCurrentValue());
                    return;
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    this.fetchNext();
                }
                return this.current != null;
            }

            @Override
            public Change next() {
                if (!this.hasNext()) {
                    throw DataUtils.newUnsupportedOperationException("no data");
                }
                Change change = this.current;
                this.current = null;
                return change;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }

    public static class ArrayType
    implements DataType {
        private final int arrayLength;
        private final DataType[] elementTypes;

        ArrayType(DataType[] dataTypeArray) {
            this.arrayLength = dataTypeArray.length;
            this.elementTypes = dataTypeArray;
        }

        @Override
        public int getMemory(Object object) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                Object object2 = objectArray[i];
                if (object2 == null) continue;
                n += dataType.getMemory(object2);
            }
            return n;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                int n = dataType.compare(objectArray[i], objectArray2[i]);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.read(byteBuffer);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
            for (int i = 0; i < n; ++i) {
                this.write(writeBuffer, objectArray[i]);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                Object object2 = objectArray[i];
                if (object2 == null) {
                    writeBuffer.put((byte)0);
                    continue;
                }
                writeBuffer.put((byte)1);
                dataType.write(writeBuffer, object2);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            Object[] objectArray = new Object[this.arrayLength];
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                if (byteBuffer.get() != 1) continue;
                objectArray[i] = dataType.read(byteBuffer);
            }
            return objectArray;
        }
    }

    public static interface RollbackListener {
        public void onRollback(MVMap<Object, VersionedValue> var1, Object var2, VersionedValue var3, VersionedValue var4);
    }

    public static class Change {
        public final String mapName;
        public final Object key;
        public final Object value;

        public Change(String string, Object object, Object object2) {
            this.mapName = string;
            this.key = object;
            this.value = object2;
        }
    }
}

