/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.localization.VMessageKey;
import com.vertica.support.LogLevel;
import com.vertica.util.ServerException;
import java.util.Hashtable;
import java.util.Locale;

public class ServerErrorData {
    private static final Character SEVERITY = new Character('S');
    private static final Character MESSAGE = new Character('M');
    private static final Character DETAIL = new Character('D');
    private static final Character HINT = new Character('H');
    private static final Character POSITION = new Character('P');
    private static final Character WHERE = new Character('W');
    private static final Character FILE = new Character('F');
    private static final Character LINE = new Character('L');
    private static final Character ROUTINE = new Character('R');
    private static final Character SQLSTATE = new Character('C');
    private static final Character INTERNAL_POSITION = new Character('p');
    private static final Character INTERNAL_QUERY = new Character('q');
    private static final Character ERROR_CODE = new Character('V');
    private static final int DEFAULT_SERVER_ERRCODE = 100081;
    private final Hashtable<Character, String> m_mesgParts = new Hashtable();
    private final int m_verbosity;
    private VConnection m_conn;

    public ServerErrorData(String string, LogLevel logLevel, VConnection vConnection) {
        this.m_conn = vConnection;
        this.m_verbosity = logLevel.ordinal();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '\u0000') continue;
            int n2 = ++i;
            while (i < n && cArray[i] != '\u0000') {
                ++i;
            }
            String string2 = new String(cArray, n2, i - n2);
            this.m_mesgParts.put(new Character(c), string2);
        }
    }

    public ServerException buildException() {
        return new ServerException(this, this.m_conn);
    }

    public String getSQLState() {
        return this.m_mesgParts.get(SQLSTATE);
    }

    public String getMessage() {
        return this.m_mesgParts.get(MESSAGE);
    }

    public String getSeverity() {
        return this.m_mesgParts.get(SEVERITY);
    }

    public String getDetail() {
        return this.m_mesgParts.get(DETAIL);
    }

    public String getHint() {
        return this.m_mesgParts.get(HINT);
    }

    public int getPosition() {
        return this.getIntegerPart(POSITION);
    }

    public String getWhere() {
        return this.m_mesgParts.get(WHERE);
    }

    public String getFile() {
        return this.m_mesgParts.get(FILE);
    }

    public int getLine() {
        return this.getIntegerPart(LINE);
    }

    public String getRoutine() {
        return this.m_mesgParts.get(ROUTINE);
    }

    public String getInternalQuery() {
        return this.m_mesgParts.get(INTERNAL_QUERY);
    }

    public int getInternalPosition() {
        return this.getIntegerPart(INTERNAL_POSITION);
    }

    public int getErrorCode() {
        int n = this.getIntegerPart(ERROR_CODE);
        return n == 0 ? 100081 : n;
    }

    private int getIntegerPart(Character c) {
        String string = this.m_mesgParts.get(c);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public boolean isCancellelationError() {
        String string = this.getSQLState();
        return string == null ? false : string.equals("57014");
    }

    public boolean isParsingError() {
        String string = this.getSQLState();
        return string == null ? false : string.equals("42601");
    }

    public String toString() {
        Locale locale = Locale.getDefault();
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_mesgParts.get(SEVERITY);
        if (string != null) {
            stringBuffer.append(string).append(": ");
        }
        if ((string = this.m_mesgParts.get(MESSAGE)) != null) {
            stringBuffer.append(string);
        }
        if ((string = this.m_mesgParts.get(DETAIL)) != null) {
            stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_DETAIL.toString(), string));
        }
        if (this.m_verbosity > 0) {
            string = this.m_mesgParts.get(HINT);
            if (string != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_HINT.toString(), string));
            }
            if ((string = this.m_mesgParts.get(POSITION)) != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_POSITION.toString(), string));
            }
            if ((string = this.m_mesgParts.get(WHERE)) != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_WHERE.toString(), string));
            }
        }
        if (this.m_verbosity > 2) {
            String string2;
            String string3 = this.m_mesgParts.get(INTERNAL_QUERY);
            if (string3 != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_INTERNAL_QUERY.toString(), string3));
            }
            if ((string2 = this.m_mesgParts.get(INTERNAL_POSITION)) != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_INTERNAL_POSITION.toString(), string2));
            }
            String string4 = this.m_mesgParts.get(FILE);
            String string5 = this.m_mesgParts.get(LINE);
            String string6 = this.m_mesgParts.get(ROUTINE);
            if (string4 != null || string5 != null || string6 != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_LOCATION.toString(), string4, string6, string5));
            }
            if ((string = this.m_mesgParts.get(SQLSTATE)) != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_SQLSTATE.toString(), string));
            }
        }
        return stringBuffer.toString();
    }

    public int getNativeErrorCode() {
        return 0;
    }
}

