/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultset;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.resultset.AbstractInputStream;
import java.io.IOException;

public class BinaryStream
extends AbstractInputStream {
    public BinaryStream(IResultSet iResultSet, int n) {
        super(iResultSet, n);
    }

    public int available() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        return this.m_buffer.length - this.m_bufferOffset;
    }

    public int read() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (this.m_buffer.length > this.m_bufferOffset) {
            return this.adjustByte(this.m_buffer[this.m_bufferOffset++]);
        }
        if (this.m_moreData) {
            this.fetchNewData();
            if (0 == this.m_buffer.length) {
                return -1;
            }
            return this.adjustByte(this.m_buffer[this.m_bufferOffset++]);
        }
        return -1;
    }

    protected void fetchNewData() throws IOException {
        try {
            DataWrapper dataWrapper = new DataWrapper();
            this.m_moreData = this.m_result.getData(this.m_column, this.m_readOffset, 4000L, dataWrapper);
            this.m_bufferOffset = 0;
            this.m_readOffset += 4000;
            this.m_buffer = (byte[])dataWrapper.getObject();
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_READ_ERROR.name());
        }
    }

    private int adjustByte(byte by) {
        if (0 > by) {
            return by + 256;
        }
        return by;
    }
}

