/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.security;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.security.ISecurityContext;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class LocalSecurityContext
implements ISecurityContext {
    private GSSContext m_context;
    private ILogger m_log;

    public LocalSecurityContext(String string, Oid oid, ILogger iLogger) throws GSSException {
        LogUtilities.logFunctionEntrance(iLogger, string, oid, iLogger);
        this.m_log = iLogger;
        this.initializeContext(string, oid);
    }

    public ILogger getLogger() {
        return this.m_log;
    }

    public byte[] getToken() throws GSSException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return this.generateToken(new byte[0]);
    }

    public boolean isEstablished() {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return this.m_context.isEstablished();
    }

    public byte[] updateToken(byte[] byArray) throws GSSException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return this.generateToken(byArray);
    }

    private byte[] generateToken(byte[] byArray) throws GSSException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        byte[] byArray2 = this.m_context.initSecContext(byArray, 0, byArray.length);
        LogUtilities.logDebug(DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.GENERATED_TOKEN_LENGTH.name(), Integer.toString(byArray2 != null ? byArray2.length : 0)), this.getLogger());
        return byArray2;
    }

    private void initializeContext(String string, Oid oid) throws GSSException {
        GSSManager gSSManager = GSSManager.getInstance();
        GSSName gSSName = gSSManager.createName(string, null);
        LogUtilities.logDebug(DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.SERVER_NAME_RETURNED_BY_GSS.name(), gSSName != null ? ((Object)gSSName).toString() : "NULL"), this.getLogger());
        this.m_context = gSSManager.createContext(gSSName, oid, null, 0);
        this.m_context.requestMutualAuth(true);
        this.m_context.requestConf(true);
        this.m_context.requestInteg(true);
        this.m_context.requestCredDeleg(true);
    }
}

