/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.core.VConnectionPropertyKey;
import com.vertica.core.VDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.SConnection;
import com.vertica.jdbc.VerticaConnection;
import com.vertica.localization.VMessageKey;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;

class VerticaConnectionImpl
extends SConnection
implements VerticaConnection {
    private VConnection m_vconn;

    protected VerticaConnectionImpl(IConnection iConnection, String string) throws SQLException {
        super(iConnection, string);
        LogUtilities.logFunctionEntrance(iConnection.getConnectionLog(), iConnection, string);
        this.m_vconn = (VConnection)iConnection;
    }

    public Object getProperty(String string) throws SQLException {
        block24: {
            LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), string);
            String string2 = VConnectionPropertyKey.translatePropertyKey(string);
            if (string2 != null) {
                try {
                    if (string2.equalsIgnoreCase("autocommit")) {
                        return this.m_vconn.isAutoCommitEnabled();
                    }
                    if (string2.equalsIgnoreCase("directbatchinsert")) {
                        return this.m_vconn.getDirectBatchInsert();
                    }
                    if (string2.equalsIgnoreCase("database")) {
                        return this.m_vconn.getDatabaseName();
                    }
                    if (string2.equalsIgnoreCase("host")) {
                        return this.m_vconn.getHost();
                    }
                    if (string2.equalsIgnoreCase("locale")) {
                        return this.m_vconn.getServerLocale();
                    }
                    if (string2.equalsIgnoreCase("loglevel")) {
                        return this.m_vconn.getLogLevel();
                    }
                    if (string2.equalsIgnoreCase("lognamespace")) {
                        return this.m_vconn.getLogNamespace();
                    }
                    if (string2.equalsIgnoreCase("logpath")) {
                        return this.m_vconn.getLogPath();
                    }
                    if (string2.equalsIgnoreCase("logintimeout")) {
                        return this.m_vconn.getLoginTimeout();
                    }
                    if (string2.equalsIgnoreCase("readonly")) {
                        return this.m_vconn.isReadOnly();
                    }
                    if (string2.equalsIgnoreCase("resultbuffersize")) {
                        return this.m_vconn.getResultBufferSize();
                    }
                    if (string2.equalsIgnoreCase("port")) {
                        return this.m_vconn.getPort();
                    }
                    if (string2.equalsIgnoreCase("sessionlabel")) {
                        return this.m_vconn.getSessionLabel();
                    }
                    if (string2.equalsIgnoreCase("ssl")) {
                        return this.m_vconn.getSSLEnabled();
                    }
                    if (string2.equalsIgnoreCase("searchpath")) {
                        return this.m_vconn.getSearchPath();
                    }
                    if (string2.equalsIgnoreCase("threepartnaming")) {
                        return this.m_vconn.getUseThreePartNaming();
                    }
                    if (string2.equalsIgnoreCase("transactionisolation")) {
                        return this.m_vconn.getTxnIsolation();
                    }
                    if (string2.equalsIgnoreCase("user")) {
                        return this.m_vconn.getUser();
                    }
                    if (string2.equalsIgnoreCase("addtztotimestampparameters")) {
                        return this.m_vconn.getAddTzToTimestampParameters();
                    }
                    break block24;
                }
                catch (Exception exception) {
                    assert (false);
                    return null;
                }
            }
            if (string != null && string.equalsIgnoreCase("inlrs")) {
                return this.m_vconn.inLRS();
            }
        }
        return null;
    }

    public void setProperty(String string, Object object) throws SQLException {
        block13: {
            LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), string, object);
            String[] stringArray = VConnectionPropertyKey.translateSetting(string, object);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (string2 == null) {
                throw ExceptionConverter.toSQLException(VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_INVALID_PROPERTY.toString(), string), this.m_vconn.getWarningListener());
            }
            if (string3 == null) {
                HashSet<String> hashSet = VConnectionPropertyKey.getLegalValueSet(string2);
                if (hashSet != null) {
                    Object[] objectArray = new String[hashSet.size()];
                    objectArray = hashSet.toArray(objectArray);
                    Arrays.sort(objectArray);
                    throw ExceptionConverter.toSQLException(VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_ILLEGAL_PROPERTY_VALUE_SET.toString(), new String[]{object == null ? "null" : object.toString(), string, Arrays.toString(objectArray)}), this.m_vconn.getWarningListener());
                }
                throw ExceptionConverter.toSQLException(VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_ILLEGAL_PROPERTY_VALUE.toString(), new String[]{object == null ? "null" : object.toString(), string}), this.m_vconn.getWarningListener());
            }
            try {
                if (string2.equalsIgnoreCase("directbatchinsert")) {
                    this.m_vconn.setDirectBatchInsert(Boolean.parseBoolean(string3));
                    break block13;
                }
                if (string2.equalsIgnoreCase("locale")) {
                    this.m_vconn.setServerLocale(string3, true);
                    break block13;
                }
                if (string2.equalsIgnoreCase("loglevel")) {
                    this.m_vconn.setLogLevel(string3);
                    break block13;
                }
                if (string2.equalsIgnoreCase("lognamespace")) {
                    this.m_vconn.setLogPackage(string3);
                    break block13;
                }
                if (string2.equalsIgnoreCase("resultbuffersize")) {
                    this.m_vconn.setResultBufferSize(Integer.parseInt(string3));
                    break block13;
                }
                if (string2.equalsIgnoreCase("searchpath")) {
                    this.m_vconn.setSearchPath(string3, true);
                    break block13;
                }
                if (string2.equalsIgnoreCase("threepartnaming")) {
                    this.m_vconn.setUseThreePartNaming(Boolean.parseBoolean(string3));
                    break block13;
                }
                if (string2.equalsIgnoreCase("addtztotimestampparameters")) {
                    this.m_vconn.setAddTzToTimestampParameters(Boolean.parseBoolean(string3));
                    break block13;
                }
                throw ExceptionConverter.toSQLException(VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_PROPERTY_NOT_SETTABLE.toString(), string), this.m_vconn.getWarningListener());
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.toSQLException(errorException, this.m_vconn.getWarningListener());
            }
        }
    }

    VConnection getInternalConnection() {
        return (VConnection)this.getConnection();
    }
}

