/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.SResultSetMetaData;
import com.vertica.jdbc.SStatement;
import com.vertica.jdbc.SWarningListener;
import com.vertica.streams.resultset.AsciiStream;
import com.vertica.streams.resultset.BinaryStream;
import com.vertica.streams.resultset.CharacterStream;
import com.vertica.streams.resultset.IStream;
import com.vertica.streams.resultset.UnicodeStream;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.CursorPosition;
import com.vertica.utilities.TypeNames;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SForwardResultSet
implements ResultSet {
    protected ILogger m_logger = null;
    protected SResultSetMetaData m_resultMetaData = null;
    protected int m_currentRow = 0;
    protected IStream m_currentStream = null;
    protected boolean m_isOpen = false;
    protected IResultSet m_resultSet = null;
    protected List<? extends IColumn> m_resultSetColumns = null;
    protected SWarningListener m_warningListener = null;
    protected boolean m_wasLastValueNull = false;
    protected List<DataWrapper> m_cachedDataWrappers = null;
    private CursorPosition m_cursorPosition = CursorPosition.BEFORE_FIRST;
    private List<String> m_columnNameIndexes = null;
    private int m_numColumns;
    private SStatement m_parentStatement = null;

    protected SForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        try {
            this.m_logger = iLogger;
            LogUtilities.logFunctionEntrance(this.m_logger, sStatement, iResultSet, iLogger);
            this.m_isOpen = true;
            this.m_parentStatement = sStatement;
            this.m_resultSet = iResultSet;
            this.m_warningListener = null == sStatement ? new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), null) : sStatement.getWarningListener();
            if (null != this.m_resultSet) {
                this.m_resultSet.registerWarningListener(this.m_warningListener);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, this.m_warningListener, new Object[0]);
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, this.m_warningListener, new Object[0]);
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, this.m_warningListener, new Object[0]);
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isOpen = false;
        if (null != this.m_parentStatement) {
            this.m_parentStatement.markResultSetClosed(this);
            this.m_parentStatement = null;
        }
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
            this.m_resultSet = null;
        }
        if (null != this.m_resultMetaData) {
            this.m_resultMetaData.close();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            int n = this.m_columnNameIndexes.indexOf(string.toUpperCase(Locale.ENGLISH));
            if (-1 == n) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_NAME, this.m_warningListener, string);
            }
            return n + 1;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, this.m_warningListener, new Object[0]);
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Array getArray(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getArray(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, 0L);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                AsciiStream asciiStream = new AsciiStream(this.m_resultSet, n - 1);
                this.m_currentStream = asciiStream;
                return asciiStream;
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), "AsciiStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toBigDecimal(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(2));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (null != bigDecimal) {
            return bigDecimal.setScale(n2, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, 0L);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -4)) {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                BinaryStream binaryStream = new BinaryStream(this.m_resultSet, n - 1);
                this.m_currentStream = binaryStream;
                return binaryStream;
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), "BinaryStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toBoolean(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(16));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toByte(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(-6));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toBytes(dataWrapper);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(-2));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, 0L);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                CharacterStream characterStream = new CharacterStream(this.m_resultSet, n - 1);
                this.m_currentStream = characterStream;
                return characterStream;
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), "CharacterStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getClob(this.findColumn(string));
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1007;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentStatement.getStatement().getCursorName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                Date date = TypeConverter.toDate(dataWrapper, this.m_warningListener);
                if (!dataWrapper.isNull()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(date.getTime());
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    date = new Date(calendar.getTimeInMillis());
                }
                this.m_wasLastValueNull = dataWrapper.isNull();
                return date;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(91));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, calendar);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                Date date = TypeConverter.toDate(dataWrapper, calendar, this.m_warningListener);
                if (!dataWrapper.isNull()) {
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTimeInMillis(date.getTime());
                    calendar2.set(11, 0);
                    calendar2.set(12, 0);
                    calendar2.set(13, 0);
                    calendar2.set(14, 0);
                    date = new Date(calendar2.getTimeInMillis());
                }
                this.m_wasLastValueNull = dataWrapper.isNull();
                return date;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(91));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toDouble(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(8));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1000;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_resultSet.getFetchSize();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toFloat(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(7));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toInt(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(4));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toLong(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(-5));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (null == this.m_resultMetaData) {
                this.m_resultSetColumns = this.m_resultSet.getSelectColumns();
                this.m_resultMetaData = new SResultSetMetaData(this.m_resultSetColumns, this.m_logger, this.m_warningListener);
            }
            return this.m_resultMetaData;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                IColumn iColumn = this.m_resultSetColumns.get(n - 1);
                Object object = TypeConverter.toObject(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = dataWrapper.isNull();
                return object;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, map);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, map);
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getRef(this.findColumn(string));
    }

    @Override
    public int getRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.AFTER_LAST == this.m_cursorPosition || CursorPosition.BEFORE_FIRST == this.m_cursorPosition) {
                return 0;
            }
            return this.m_currentRow;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public long getRowCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_resultSet.getRowCount();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toShort(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(5));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getShort(this.findColumn(string));
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentStatement;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getString(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toString(dataWrapper, iColumn.getTypeMetadata());
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(12));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getString(this.findColumn(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                IColumn iColumn = this.m_resultSetColumns.get(n - 1);
                Time time = TypeConverter.toTime(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
                if (!dataWrapper.isNull()) {
                    Calendar calendar = GregorianCalendar.getInstance();
                    calendar.setTimeInMillis(time.getTime());
                    calendar.set(1, 1970);
                    calendar.set(2, 0);
                    calendar.set(5, 1);
                    time = new Time(calendar.getTimeInMillis());
                }
                this.m_wasLastValueNull = dataWrapper.isNull();
                return time;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(92));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                IColumn iColumn = this.m_resultSetColumns.get(n - 1);
                Time time = TypeConverter.toTime(dataWrapper, calendar, iColumn.getTypeMetadata(), this.m_warningListener);
                if (!dataWrapper.isNull()) {
                    Calendar calendar2 = GregorianCalendar.getInstance();
                    calendar2.setTimeInMillis(time.getTime());
                    calendar2.set(1, 1970);
                    calendar2.set(2, 0);
                    calendar2.set(5, 1);
                    time = new Time(calendar2.getTimeInMillis());
                }
                this.m_wasLastValueNull = dataWrapper.isNull();
                return time;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(92));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toTimestamp(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(93));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, calendar);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toTimestamp(dataWrapper, calendar, iColumn.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(93));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public int getType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1003;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, 0L);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                UnicodeStream unicodeStream = new UnicodeStream(this.m_resultSet, n - 1);
                this.m_currentStream = unicodeStream;
                return unicodeStream;
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, String.valueOf(n), "UnicodeStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public URL getURL(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public URL getURL(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getURL(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.AFTER_LAST == this.m_cursorPosition;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.BEFORE_FIRST == this.m_cursorPosition;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.AT_FIRST == this.m_cursorPosition || CursorPosition.AT_FIRST_AT_LAST == this.m_cursorPosition;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.AT_LAST == this.m_cursorPosition || CursorPosition.AT_FIRST_AT_LAST == this.m_cursorPosition;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, this.m_warningListener, new Object[0]);
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (null == this.m_resultSet) {
                return false;
            }
            boolean bl = this.m_resultSet.moveToNextRow();
            this.updateCursorPosition(bl, this.m_resultSet.hasMoreRows());
            ++this.m_currentRow;
            this.m_warningListener.clear();
            return bl;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, this.m_warningListener, new Object[0]);
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean relative(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.getType() == 1003) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, this.m_warningListener, new Object[0]);
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowDeleted();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowInserted();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowUpdated();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (n) {
                case 1000: 
                case 1001: 
                case 1002: {
                    break;
                }
                default: {
                    throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.UNKNOWN_FETCH_DIRECTION, this.m_warningListener, String.valueOf(n));
                }
            }
            if (1003 == this.getType() && 1000 != n) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, this.m_warningListener, new Object[0]);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            boolean bl;
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            int n2 = this.getStatement().getMaxRows();
            boolean bl2 = bl = 0 <= n;
            if (0 != n2) {
                boolean bl3 = bl = bl && n2 >= n;
            }
            if (!bl) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_FETCH_SIZE, this.m_warningListener, String.valueOf(n), String.valueOf(0), String.valueOf(0 == n2 ? Double.POSITIVE_INFINITY : (double)n2));
            }
            this.m_resultSet.setFetchSize(n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, array);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, array);
            this.updateArray(this.findColumn(string), array);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, n);
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bigDecimal);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, bigDecimal);
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, n);
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, blob);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, blob);
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bl);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, bl);
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, by);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, by);
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, byArray);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, byArray);
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, reader, n2);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, n);
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clob);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clob);
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, date);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, date);
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, d);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, d);
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, Float.valueOf(f));
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, Float.valueOf(f));
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, l);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, l);
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateNull(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object);
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, n);
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, ref);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, ref);
        this.updateRef(this.findColumn(string), ref);
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, s);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, s);
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, string);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, string2);
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, time);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, time);
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, timestamp);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, timestamp);
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_wasLastValueNull;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    void initializeColumnNameMap() throws SQLException {
        if (null == this.m_columnNameIndexes) {
            this.m_columnNameIndexes = new ArrayList<String>();
            this.m_cachedDataWrappers = new ArrayList<DataWrapper>();
            this.m_numColumns = this.getMetaData().getColumnCount();
            for (int i = 0; i < this.m_numColumns; ++i) {
                this.m_columnNameIndexes.add(this.m_resultSetColumns.get(i).getName().toUpperCase(Locale.ENGLISH));
                this.m_cachedDataWrappers.add(new DataWrapper());
            }
        }
    }

    protected synchronized void checkIfOpen() throws SQLException {
        if (!this.m_isOpen) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.RESULTSET_CLOSED, this.m_warningListener, new Object[0]);
        }
        if (null == this.m_parentStatement) {
            this.close();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.PARENT_CLOSED, this.m_warningListener, new Object[0]);
        }
    }

    protected void checkIfValidColumnNumber(int n) throws SQLException {
        if (1 > n || this.m_numColumns < n) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, this.m_warningListener, String.valueOf(n));
        }
    }

    protected void checkIfValidRowNumber() throws SQLException {
        if (0 == this.m_currentRow) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.CURSOR_BEFORE_FIRST_ROW, this.m_warningListener, new Object[0]);
        }
        if (CursorPosition.AFTER_LAST == this.m_cursorPosition) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.CURSOR_AFTER_LAST_ROW, this.m_warningListener, new Object[0]);
        }
    }

    protected void closeCurrentStream() throws SQLException {
        if (null == this.m_currentStream) {
            return;
        }
        try {
            this.m_currentStream.close();
            this.m_currentStream = null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected DataWrapper getData(int n, long l) throws SQLException {
        this.checkIfValidColumnNumber(n);
        this.checkIfValidRowNumber();
        --n;
        try {
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n);
            this.m_resultSet.getData(n, 0L, l, dataWrapper);
            return dataWrapper;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener);
        }
    }

    private void updateCursorPosition(boolean bl, boolean bl2) throws SQLException {
        switch (this.m_cursorPosition) {
            case BEFORE_FIRST: {
                if (!bl) {
                    this.m_cursorPosition = CursorPosition.AFTER_LAST;
                    break;
                }
                if (bl && bl2) {
                    this.m_cursorPosition = CursorPosition.AT_FIRST;
                    break;
                }
                this.m_cursorPosition = CursorPosition.AT_FIRST_AT_LAST;
                break;
            }
            case AT_FIRST: {
                if (bl && bl2) {
                    this.m_cursorPosition = CursorPosition.DURING;
                    break;
                }
                this.m_cursorPosition = CursorPosition.AT_LAST;
                break;
            }
            case DURING: {
                if (bl && bl2) break;
                this.m_cursorPosition = CursorPosition.AT_LAST;
                break;
            }
            case AT_LAST: 
            case AT_FIRST_AT_LAST: {
                if (bl && bl2) {
                    throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_CURSOR_TRANSITION, this.m_warningListener, new Object[0]);
                }
                this.m_cursorPosition = CursorPosition.AFTER_LAST;
                break;
            }
            case AFTER_LAST: {
                break;
            }
            default: {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_CURSOR_TRANSITION, this.m_warningListener, this.m_cursorPosition.toString());
            }
        }
    }
}

