/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.SCallableStatement;
import com.vertica.jdbc.SConnection;
import com.vertica.jdbc.SDatabaseMetaData;
import com.vertica.jdbc.SPreparedStatement;
import com.vertica.jdbc.SStatement;
import com.vertica.support.ILogger;
import com.vertica.support.exceptions.GeneralException;
import java.sql.SQLException;

public class JDBCObjectFactory {
    private static JDBCObjectFactory s_factory = null;

    static JDBCObjectFactory getInstance() {
        return s_factory;
    }

    static void setInstance(JDBCObjectFactory jDBCObjectFactory) throws GeneralException {
        if (null == jDBCObjectFactory) {
            throw new GeneralException(1, JDBCMessageKey.INITIALIZE_FACTORY.name());
        }
        s_factory = jDBCObjectFactory;
    }

    protected JDBCObjectFactory() {
    }

    protected SCallableStatement createCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return new SCallableStatement(string, iStatement, sConnection, n);
    }

    protected SConnection createConnection(IConnection iConnection, String string) throws SQLException {
        return new SConnection(iConnection, string);
    }

    protected SDatabaseMetaData createDatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        return new SDatabaseMetaData(sConnection, iLogger);
    }

    protected SPreparedStatement createPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return new SPreparedStatement(string, iStatement, sConnection, n);
    }

    protected SStatement createStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return new SStatement(iStatement, sConnection, n);
    }
}

