/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnectionPropertyKey;
import com.vertica.core.VDriver;
import com.vertica.jdbc.AbstractDataSource;
import com.vertica.jdbc.AbstractDriver;
import com.vertica.jdbc.JDBCObjectFactory;
import com.vertica.jdbc.VJDBCObjectFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DataSource
extends AbstractDataSource {
    private Map<String, String> m_properties = new HashMap<String, String>();

    public boolean areBatchInsertsDirect() {
        String string = this.m_properties.get("directbatchinsert");
        if (null == string) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public String getDatabase() {
        return this.m_properties.get("database");
    }

    public String getHost() {
        return this.m_properties.get("host");
    }

    public String getLocale() {
        return this.m_properties.get("locale");
    }

    public int getLoginTimeout() {
        String string = this.m_properties.get("logintimeout");
        if (null == string) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public long getResultBufferSize() {
        String string = this.m_properties.get("resultbuffersize");
        if (null == string) {
            return 8192L;
        }
        return Long.valueOf(string);
    }

    public short getPort() {
        String string = this.m_properties.get("port");
        if (null == string) {
            return 5433;
        }
        return Short.valueOf(string);
    }

    public boolean isReadOnly() {
        String string = this.m_properties.get("readonly");
        if (null == string) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public String getSearchPath() {
        String string = this.m_properties.get("searchpath");
        if (null == string) {
            return "";
        }
        return string;
    }

    public String getSessionLabel() {
        return this.m_properties.get("sessionlabel");
    }

    public int getTransactionIsolation() {
        String string = this.m_properties.get("transactionisolation");
        if (null == string) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public boolean isAutoCommitOnByDefault() {
        String string = this.m_properties.get("autocommit");
        if (null == string) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    public boolean isSslEnabled() {
        String string = this.m_properties.get("ssl");
        if (null == string) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public void setAutoCommitOnByDefault(boolean bl) {
        this.m_properties.put("autocommit", String.valueOf(bl));
    }

    public void setBatchInsertsDirect(boolean bl) {
        this.m_properties.put("directbatchinsert", String.valueOf(bl));
    }

    public void setDatabase(String string) {
        this.m_properties.put("database", string);
    }

    public void setHost(String string) {
        this.m_properties.put("host", string);
    }

    public void setLocale(String string) {
        this.m_properties.put("locale", string);
    }

    public void setLoginTimeout(int n) {
        this.m_properties.put("logintimeout", String.valueOf(n));
    }

    public void setResultBufferSize(long l) {
        this.m_properties.put("resultbuffersize", String.valueOf(l));
    }

    public void setPort(short s) {
        this.m_properties.put("port", String.valueOf(s));
    }

    public void setReadOnly(boolean bl) {
        this.m_properties.put("readonly", String.valueOf(bl));
    }

    public void setSessionLabel(String string) {
        this.m_properties.put("sessionlabel", string);
    }

    public void setSslEnabled(boolean bl) {
        this.m_properties.put("ssl", String.valueOf(bl));
    }

    public void setThreePartNaming(boolean bl) {
        this.m_properties.put("threepartnaming", String.valueOf(bl));
    }

    public void setSearchPath(String string) {
        this.m_properties.put("searchpath", string);
    }

    public boolean useThreePartNaming() {
        String string = this.m_properties.get("threepartnaming");
        if (null == string) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    protected JDBCObjectFactory createJDBCObjectFactory() {
        return new VJDBCObjectFactory();
    }

    protected Properties getProperties() {
        Properties properties = super.getProperties();
        for (Map.Entry<String, String> entry : this.m_properties.entrySet()) {
            if (null == entry.getValue()) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    protected String getSubProtocol() {
        return "vertica";
    }

    protected boolean parseSubName(String string, Properties properties) {
        return VConnectionPropertyKey.parseSubName(string, properties);
    }

    static {
        AbstractDataSource.initialize(VDriver.class.getName());
        AbstractDriver.setErrorMessageComponentName("Vertica");
    }
}

