/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.exceptions;

import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.dsi.exceptions.InvalidArgumentException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.AbstractDriver;
import com.vertica.support.ILogger;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.utilities.StateUtilities;
import java.sql.SQLException;

public class ExceptionConverter {
    public static SQLException toSQLException(Exception exception, IWarningListener iWarningListener) {
        if (exception instanceof SQLException) {
            return (SQLException)exception;
        }
        IMessageSource iMessageSource = iWarningListener.getMessageSource();
        SQLException sQLException = null;
        if (exception instanceof NullPointerException) {
            String string = iMessageSource.loadMessage(iWarningListener.getLocale(), 1, JDBCMessageKey.NULL_ERROR.name());
            sQLException = new SQLException(string, JDBCMessageKey.NULL_ERROR.getSQLState(), 0);
        } else if (exception instanceof InputOutputException) {
            InputOutputException inputOutputException = (InputOutputException)exception;
            inputOutputException.loadMessage(iWarningListener.getMessageSource(), iWarningListener.getLocale());
            sQLException = new SQLException(inputOutputException.getMessage(), "HY000", inputOutputException.getErrorCode());
        } else if (exception instanceof InvalidArgumentException) {
            InvalidArgumentException invalidArgumentException = (InvalidArgumentException)exception;
            invalidArgumentException.loadMessage(iWarningListener.getMessageSource(), iWarningListener.getLocale());
            sQLException = new SQLException(invalidArgumentException.getMessage(), "HY000", invalidArgumentException.getErrorCode());
        } else if (exception instanceof ErrorException) {
            ErrorException errorException = (ErrorException)exception;
            errorException.loadMessage(iMessageSource, iWarningListener.getLocale());
            String string = errorException.hasCustomState() ? errorException.getCustomState() : StateUtilities.getSQLState(errorException.getDiagState());
            sQLException = new SQLException(errorException.getMessage(), string, errorException.getNativeErrorCode(null, null));
        } else {
            sQLException = new SQLException(AbstractDriver.getErrorMessageComponentName() + exception.getLocalizedMessage(), "HY000", 0);
        }
        sQLException.initCause(exception);
        sQLException.setStackTrace(exception.getStackTrace());
        return sQLException;
    }

    public static SQLException toSQLException(Exception exception, IWarningListener iWarningListener, ILogger iLogger) {
        SQLException sQLException = ExceptionConverter.toSQLException(exception, iWarningListener);
        LogUtilities.logError(sQLException, iLogger);
        return sQLException;
    }
}

