/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.utilities.MetadataColumn;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.Searchable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataColumnFactory {
    public static ArrayList<MetadataColumn> createMetadataColumns(IStatement iStatement, MetadataSourceID metadataSourceID) throws ErrorException {
        LogUtilities.logFunctionEntrance(iStatement.getLog(), new Object[]{iStatement, metadataSourceID});
        switch (metadataSourceID) {
            case COLUMN_PRIVILEGES: {
                return MetadataColumnFactory.createColumnPrivilegesMetadata(iStatement);
            }
            case COLUMNS: {
                return MetadataColumnFactory.createColumnsMetadata(iStatement);
            }
            case FOREIGN_KEYS: {
                return MetadataColumnFactory.createForeignKeysMetadata(iStatement);
            }
            case PRIMARY_KEYS: {
                return MetadataColumnFactory.createPrimaryKeysMetadata(iStatement);
            }
            case PROCEDURE_COLUMNS: {
                return MetadataColumnFactory.createProcedureColumnsMetadata(iStatement);
            }
            case PROCEDURES: {
                return MetadataColumnFactory.createProceduresMetadata(iStatement);
            }
            case SPECIAL_COLUMNS: {
                return MetadataColumnFactory.createSpecialColumnsMetadata(iStatement);
            }
            case STATISTICS: {
                return MetadataColumnFactory.createStatisticsMetadata(iStatement);
            }
            case TABLE_PRIVILEGES: {
                return MetadataColumnFactory.createTablePrivilegesMetadata(iStatement);
            }
            case CATALOG_ONLY: 
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: 
            case TABLES: 
            case TABLETYPE_ONLY: {
                return MetadataColumnFactory.createTablesMetadata(iStatement, metadataSourceID);
            }
            case TYPE_INFO: {
                return MetadataColumnFactory.createTypeInfoMetadata();
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), metadataSourceID.toString());
    }

    private static ArrayList<MetadataColumn> createColumnPrivilegesMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 83);
            int n4 = MetadataColumnFactory.getMaxLength(iConnection, 68);
            int n5 = MetadataColumnFactory.getMaxLength(iConnection, 85);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.GRANTOR);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("GRANTOR");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n5);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.GRANTEE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("GRANTEE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n5);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIVILEGE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PRIVILEGE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(32L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.ISGRANTABLE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("IS_GRANTABLE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(3L);
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createColumnsMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 83);
            int n4 = MetadataColumnFactory.getMaxLength(iConnection, 68);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TYPE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(128L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_SIZE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.BUFFER_LENGTH);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("BUFFER_LENGTH");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DECIMAL_DIGITS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DECIMAL_DIGITS");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NUM_PREC_RADIX);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NUM_PREC_RADIX");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NULLABLE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NULLABLE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("REMARKS");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(254L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_DEF);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_DEF");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(4000L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATA_TYPE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("SQL_DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATETIME_SUB);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("SQL_DATETIME_SUB");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.CHAR_OCTET_LENGTH);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("CHAR_OCTET_LENGTH");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.ORDINAL_POSITION);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("ORDINAL_POSITION");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.IS_NULLABLE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("IS_NULLABLE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(254L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("USER_DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createForeignKeysMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 83);
            int n4 = MetadataColumnFactory.getMaxLength(iConnection, 68);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PKTABLE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PKTABLE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PKTABLE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_COLUMN_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PKCOLUMN_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("FKTABLE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("FKTABLE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("FKTABLE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_COLUMN_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("FKCOLUMN_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.KEY_SEQ);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("KEY_SEQ");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.FOREIGN_KEY_UPDATE_RULE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("UPDATE_RULE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.FOREIGN_KEY_DELETE_RULE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DELETE_RULE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("FK_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PK_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DEFERRABILITY);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DEFERRABILITY");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createPrimaryKeysMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 83);
            int n4 = MetadataColumnFactory.getMaxLength(iConnection, 68);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_COLUMN_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.KEY_SEQ);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("KEY_SEQ");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PK_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createProcedureColumnsMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 78);
            int n4 = MetadataColumnFactory.getMaxLength(iConnection, 68);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PROCEDURE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PROCEDURE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PROCEDURE_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PROCEDURE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.PROCEDURE_COLUMN_TYPE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TYPE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(128L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_SIZE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.BUFFER_LENGTH);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("BUFFER_LENGTH");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DECIMAL_DIGITS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DECIMAL_DIGITS");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NUM_PREC_RADIX);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NUM_PREC_RADIX");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NULLABLE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NULLABLE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("REMARKS");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(254L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_DEF);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_DEF");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(4000L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATA_TYPE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("SQL_DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATETIME_SUB);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("SQL_DATETIME_SUB");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.CHAR_OCTET_LENGTH);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("CHAR_OCTET_LENGTH");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.ORDINAL_POSITION);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("ORDINAL_POSITION");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.IS_NULLABLE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("IS_NULLABLE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(254L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("USER_DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createProceduresMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 78);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PROCEDURE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PROCEDURE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PROCEDURE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PROCEDURE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.NUM_INPUT_PARAMS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NUM_INPUT_PARAMS");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.NUM_OUTPUT_PARAMS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NUM_OUTPUT_PARAMS");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.NUM_RESULT_SETS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NUM_RESULT_SETS");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("REMARKS");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(254L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.PROCEDURE_TYPE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PROCEDURE_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createSpecialColumnsMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 68);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SCOPE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("SCOPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TYPE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(128L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_SIZE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.BUFFER_LENGTH);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("BUFFER_LENGTH");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DECIMAL_DIGITS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DECIMAL_DIGITS");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.PSEUDO);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PSEUDO_COLUMN");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("USER_DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createStatisticsMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 83);
            int n4 = MetadataColumnFactory.getMaxLength(iConnection, 68);
            int n5 = MetadataColumnFactory.getMaxLength(iConnection, 76);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NON_UNIQUE_INDEX);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NON_UNIQUE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.INDEX_QUALIFIER);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("INDEX_QUALIFIER");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n5);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.INDEX_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("INDEX_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.INDEX_TYPE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.ORDINAL_POSITION);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("ORDINAL_POSITION");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(1), MetadataSourceColumnTag.INDEX_SORT_SEQUENCE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("ASC_OR_DESC");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(1L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.INDEX_CARDINALITY);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("CARDINALITY");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.INDEX_PAGES);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PAGES");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.INDEX_FILTER_CONDITION);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("FILTER_CONDITION");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createTablePrivilegesMetadata(IStatement iStatement) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 83);
            int n4 = MetadataColumnFactory.getMaxLength(iConnection, 85);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.GRANTOR);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("GRANTOR");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.GRANTEE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("GRANTEE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n4);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIVILEGE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("PRIVILEGE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(32L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.ISGRANTABLE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("IS_GRANTABLE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(3L);
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createTablesMetadata(IStatement iStatement, MetadataSourceID metadataSourceID) throws ErrorException {
        IConnection iConnection = iStatement.getParentConnection();
        try {
            int n = MetadataColumnFactory.getMaxLength(iConnection, 66);
            int n2 = MetadataColumnFactory.getMaxLength(iConnection, 81);
            int n3 = MetadataColumnFactory.getMaxLength(iConnection, 83);
            ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_CAT");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n);
            metadataColumn.setNullColumn(MetadataSourceID.TABLES != metadataSourceID && MetadataSourceID.CATALOG_ONLY != metadataSourceID && MetadataSourceID.CATALOG_SCHEMA_ONLY != metadataSourceID);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_SCHEM");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n2);
            metadataColumn.setNullColumn(MetadataSourceID.TABLES != metadataSourceID && MetadataSourceID.SCHEMA_ONLY != metadataSourceID && MetadataSourceID.CATALOG_SCHEMA_ONLY != metadataSourceID);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(n3);
            metadataColumn.setNullColumn(MetadataSourceID.TABLES != metadataSourceID);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_TYPE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TABLE_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(32L);
            metadataColumn.setNullColumn(MetadataSourceID.TABLES != metadataSourceID && MetadataSourceID.TABLETYPE_ONLY != metadataSourceID);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("REMARKS");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(254L);
            metadataColumn.setNullColumn(MetadataSourceID.TABLES != metadataSourceID);
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createTypeInfoMetadata() throws ErrorException {
        ArrayList<MetadataColumn> arrayList = new ArrayList<MetadataColumn>();
        try {
            MetadataColumn metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("TYPE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(128L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("COLUMN_SIZE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.LITERAL_PREFIX);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("LITERAL_PREFIX");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(32L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.LITERAL_SUFFIX);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("LITERAL_SUFFIX");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(32L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CREATE_PARAM);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("CREATE_PARAMS");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(32L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NULLABLE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NULLABLE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.CASE_SENSITIVE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("CASE_SENSITIVE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SEARCHABLE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("SEARCHABLE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.UNSIGNED_ATTRIBUTE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("UNSIGNED_ATTRIBUTE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.FIXED_PREC_SCALE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("FIXED_PREC_SCALE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.AUTO_UNIQUE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("AUTO_UNIQUE_VALUE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.LOCAL_TYPE_NAME);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("LOCAL_TYPE_NAME");
            metadataColumn.setName(metadataColumn.getLabel());
            metadataColumn.setColumnLength(128L);
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.MINIMUM_SCALE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("MINIMUM_SCALE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.MAXIMUM_SCALE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("MAXIMUM_SCALE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATA_TYPE);
            metadataColumn.setNullable(Nullable.NO_NULLS);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("SQL_DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATETIME_SUB);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("SQL_DATETIME_SUB");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.NUM_PREC_RADIX);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("NUM_PREC_RADIX");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.INTERVAL_PRECISION);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("INTERVAL_PRECISION");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            metadataColumn = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            metadataColumn.setNullable(Nullable.NULLABLE);
            metadataColumn.setSearchable(Searchable.PREDICATE_NONE);
            metadataColumn.setUpdatable(Updatable.READ_ONLY);
            metadataColumn.setLabel("USER_DATA_TYPE");
            metadataColumn.setName(metadataColumn.getLabel());
            arrayList.add(metadataColumn);
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new GeneralException(exception.getLocalizedMessage(), 0);
        }
    }

    private static int getMaxLength(IConnection iConnection, int n) throws NumericOverflowException, IncorrectTypeException, BadPropertyKeyException, ErrorException {
        int n2 = iConnection.getProperty(n).getInt();
        if (0 == n2) {
            return 1024;
        }
        return n2;
    }
}

