/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.utilities;

import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import java.io.UnsupportedEncodingException;

public class Variant {
    public static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;
    public static final long UINT32_MIN_VALUE = 0L;
    public static final int TYPE_WSTRING = 0;
    public static final int TYPE_UINT16 = 2;
    public static final int TYPE_UINT32 = 3;
    public static final int TYPE_UINT64 = 4;
    public static final int TYPE_INT16 = 5;
    public static final int TYPE_INT32 = 6;
    public static final int TYPE_INT64 = 7;
    public static final int TYPE_NULL = 8;
    public static final int TYPE_BINARY = 9;
    private int m_type;
    private Object m_value;

    public Variant(int n, Object object) throws IncorrectTypeException, NumericOverflowException {
        switch (n) {
            case 0: {
                if (object == null || object instanceof String) break;
                throw new IncorrectTypeException();
            }
            case 5: {
                if (object instanceof Short) break;
                throw new IncorrectTypeException();
            }
            case 2: {
                if (object instanceof Character) break;
                throw new IncorrectTypeException();
            }
            case 6: {
                if (object instanceof Integer) break;
                throw new IncorrectTypeException();
            }
            case 3: {
                if (!(object instanceof Long)) {
                    throw new IncorrectTypeException();
                }
                long l = (Long)object;
                if (0xFFFFFFFFL >= l && 0L <= l) break;
                throw new NumericOverflowException();
            }
            case 4: 
            case 7: {
                if (object instanceof Long) break;
                throw new IncorrectTypeException();
            }
            case 8: {
                if (null == object) break;
                throw new IncorrectTypeException();
            }
            case 9: {
                throw new IncorrectTypeException();
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
        this.m_type = n;
        this.m_value = object;
    }

    public char getChar() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                int n = ((Short)this.m_value).intValue();
                if (0 <= n) {
                    return (char)n;
                }
                throw new NumericOverflowException();
            }
            case 3: {
                long l = (Long)this.m_value;
                if (65535L >= l) {
                    return (char)l;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                int n = (Integer)this.m_value;
                if (65535 >= n && 0 <= n) {
                    return (char)n;
                }
                throw new NumericOverflowException();
            }
            case 7: {
                long l = (Long)this.m_value;
                if (65535L >= l && 0L <= l) {
                    return (char)l;
                }
                throw new NumericOverflowException();
            }
            case 0: {
                try {
                    long l = Long.parseLong((String)this.m_value);
                    if (65535L >= l && 0L <= l) {
                        return (char)l;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: 
            case 9: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public int getInt() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                return ((Short)this.m_value).intValue();
            }
            case 3: {
                long l = (Long)this.m_value;
                if (Integer.MAX_VALUE >= l) {
                    return (int)l;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                return (Integer)this.m_value;
            }
            case 7: {
                long l = (Long)this.m_value;
                if (Integer.MAX_VALUE >= l && Integer.MIN_VALUE <= l) {
                    return (short)l;
                }
                throw new NumericOverflowException();
            }
            case 0: {
                try {
                    long l = Long.parseLong((String)this.m_value);
                    if (Integer.MAX_VALUE >= l && Integer.MIN_VALUE <= l) {
                        return (int)l;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: 
            case 9: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public long getLong() throws IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                return ((Short)this.m_value).longValue();
            }
            case 3: {
                return (Long)this.m_value;
            }
            case 6: {
                return ((Integer)this.m_value).longValue();
            }
            case 7: {
                return (Long)this.m_value;
            }
            case 0: {
                try {
                    return Long.parseLong((String)this.m_value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: 
            case 9: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public short getShort() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                char c = ((Character)this.m_value).charValue();
                if (Short.MAX_VALUE >= c) {
                    return (short)c;
                }
                throw new NumericOverflowException();
            }
            case 5: {
                return (Short)this.m_value;
            }
            case 3: {
                long l = (Long)this.m_value;
                if (32767L >= l) {
                    return (short)l;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                int n = (Integer)this.m_value;
                if (Short.MAX_VALUE >= n && Short.MIN_VALUE <= n) {
                    return (short)n;
                }
                throw new NumericOverflowException();
            }
            case 7: {
                long l = (Long)this.m_value;
                if (32767L >= l && -32768L <= l) {
                    return (short)l;
                }
                throw new NumericOverflowException();
            }
            case 0: {
                try {
                    long l = Long.parseLong((String)this.m_value);
                    if (32767L >= l && -32768L <= l) {
                        return (short)l;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: 
            case 9: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public String getString() {
        if (null == this.m_value) {
            return null;
        }
        if (2 == this.m_type) {
            int n = Character.getNumericValue(((Character)this.m_value).charValue());
            return String.valueOf(n);
        }
        return this.m_value.toString();
    }

    public byte[] getStringAsUTF8() throws IncorrectTypeException, UnsupportedEncodingException {
        if (null == this.m_value) {
            return null;
        }
        return this.getString().getBytes("UTF-8");
    }

    public int getType() {
        return this.m_type;
    }

    public String toString() {
        if (null == this.m_value) {
            return "Variant[type: " + String.valueOf(this.m_type) + ", value: null]";
        }
        return "Variant[type: " + String.valueOf(this.m_type) + ", value: " + this.m_value.toString() + "]";
    }

    public boolean equals(Object object) {
        if (null == object || !(object instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)object;
        if (null == this.m_value) {
            return null == variant.m_value;
        }
        return this.m_value.equals(variant.m_value);
    }
}

