/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.interfaces.ITransactionStateListener;
import com.vertica.dsi.core.utilities.AttributeDataMap;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.ConnectionSetting;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.BadAuthException;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.security.IIntegratedSecurityManager;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.SettingReader;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionUtilities;
import java.util.Locale;

public abstract class DSIConnection
implements IConnection {
    public static final String REQ_INDICATOR = "?";
    protected ITransactionStateListener m_transactionListener;
    protected AttributeDataMap m_connectionProperties = new AttributeDataMap();
    private IEnvironment m_environment;
    private IIntegratedSecurityManager m_ISManager;
    private IWarningListener m_warningListener = null;
    private Locale m_locale = null;

    protected DSIConnection(IEnvironment iEnvironment) throws ErrorException {
        this.m_environment = iEnvironment;
        try {
            this.loadProperties();
            this.m_locale = ExceptionUtilities.createLocale(SettingReader.readSetting("DriverLocale"));
            LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
    }

    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    public void createSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    public Variant getCustomProperty(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return null;
    }

    public int getCustomPropertyType(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return 0;
    }

    public String getDataSourceName() throws ErrorException {
        try {
            return this.getProperty(41).getString();
        }
        catch (BadPropertyKeyException badPropertyKeyException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPKEY.name(), "Data Source Name", (Throwable)badPropertyKeyException);
        }
    }

    public IIntegratedSecurityManager getIntegratedSecurityManager() {
        return this.m_ISManager;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public IMessageSource getMessageSource() {
        return this.m_environment.getMessageSource();
    }

    public IEnvironment getParentEnvironment() {
        return this.m_environment;
    }

    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null == this.m_connectionProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (this.m_connectionProperties.isProperty(n)) {
            return this.m_connectionProperties.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    public boolean isAlive() {
        Variant variant = this.m_connectionProperties.getProperty(20);
        assert (null != variant);
        try {
            return variant.getLong() != 1L;
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return false;
        }
    }

    public boolean isCustomProperty(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return false;
    }

    public void registerTransactionStateListener(ITransactionStateListener iTransactionStateListener) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), iTransactionStateListener);
        this.m_transactionListener = iTransactionStateListener;
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    public void releaseSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    public void rollback(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    public void setCustomProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    public void setIntegratedSecurityManager(IIntegratedSecurityManager iIntegratedSecurityManager) {
        this.m_ISManager = iIntegratedSecurityManager;
    }

    public void setInvokerAndClassLoader(Object object, Object object2) {
    }

    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null == this.m_connectionProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        this.m_connectionProperties.setProperty(n, variant);
    }

    public String toNativeSQL(String string) {
        return String.valueOf(string);
    }

    protected Variant getOptionalSetting(String string, ConnSettingRequestMap connSettingRequestMap) {
        return connSettingRequestMap.getProperty(string);
    }

    protected Variant getRequiredSetting(String string, ConnSettingRequestMap connSettingRequestMap) throws BadAuthException {
        Variant variant = connSettingRequestMap.getProperty(string);
        if (null == variant) {
            throw new BadAuthException(2, DSIMessageKey.REQ_SETTING_NOT_FOUND.name(), string);
        }
        return variant;
    }

    protected void verifyOptionalSetting(String string, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        this.verifyOptionalSetting(string, string, connSettingRequestMap, connSettingResponseMap);
    }

    protected void verifyOptionalSetting(String string, String string2, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        if (null == connSettingRequestMap.getProperty(string)) {
            ConnectionSetting connectionSetting = new ConnectionSetting(0);
            connectionSetting.setLabel(string2);
            try {
                connectionSetting.insertValue(new Variant(0, REQ_INDICATOR));
            }
            catch (Exception exception) {
                try {
                    LogUtilities.logError(exception, this.getConnectionLog());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            connSettingResponseMap.setProperty(string, connectionSetting);
        }
    }

    protected void verifyRequiredSetting(String string, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        this.verifyRequiredSetting(string, string, connSettingRequestMap, connSettingResponseMap);
    }

    protected void verifyRequiredSetting(String string, String string2, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        if (null == connSettingRequestMap.getProperty(string)) {
            ConnectionSetting connectionSetting = new ConnectionSetting(1);
            connectionSetting.setLabel(string2);
            try {
                connectionSetting.insertValue(new Variant(0, REQ_INDICATOR));
            }
            catch (Exception exception) {
                try {
                    LogUtilities.logError(exception, this.getConnectionLog());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            connSettingResponseMap.setProperty(string, connectionSetting);
        }
    }

    private void loadProperties() throws ErrorException, IncorrectTypeException, NumericOverflowException {
        this.m_connectionProperties.setProperty(1, 0, "Y");
        this.m_connectionProperties.setProperty(2, 0, "Y");
        this.m_connectionProperties.setProperty(3, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(4, 3, 127L);
        this.m_connectionProperties.setProperty(5, 3, 1L);
        this.m_connectionProperties.setProperty(6, 3, 256L);
        this.m_connectionProperties.setProperty(7, 3, 0L);
        this.m_connectionProperties.setProperty(8, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(9, 0, "Y");
        this.m_connectionProperties.setProperty(10, 0, ".");
        this.m_connectionProperties.setProperty(11, 0, "catalog");
        this.m_connectionProperties.setProperty(12, 3, 31L);
        this.m_connectionProperties.setProperty(13, 0, "");
        this.m_connectionProperties.setProperty(14, 0, "Y");
        this.m_connectionProperties.setProperty(15, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(16, 3, 1L);
        this.m_connectionProperties.setProperty(17, 6, 0);
        this.m_connectionProperties.setProperty(18, 3, 1L);
        this.m_connectionProperties.setProperty(19, 3, 1L);
        this.m_connectionProperties.setProperty(21, 3, 0L);
        this.m_connectionProperties.setProperty(20, 3, 0L);
        this.m_connectionProperties.setProperty(22, 0, "");
        this.m_connectionProperties.setProperty(26, 3, 1L);
        this.m_connectionProperties.setProperty(23, 3, 0L);
        this.m_connectionProperties.setProperty(24, 3, 1024L);
        this.m_connectionProperties.setProperty(25, 3, 0L);
        this.m_connectionProperties.setProperty(27, 3, 1L);
        this.m_connectionProperties.setProperty(28, 2, Character.valueOf('\u0002'));
        this.m_connectionProperties.setProperty(29, 3, 0L);
        this.m_connectionProperties.setProperty(30, 3, 0L);
        this.m_connectionProperties.setProperty(31, 3, 0L);
        this.m_connectionProperties.setProperty(32, 3, 0L);
        this.m_connectionProperties.setProperty(33, 3, 0L);
        this.m_connectionProperties.setProperty(34, 3, 0L);
        this.m_connectionProperties.setProperty(35, 3, 0L);
        this.m_connectionProperties.setProperty(36, 3, 0L);
        this.m_connectionProperties.setProperty(37, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(38, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(39, 3, 0L);
        this.m_connectionProperties.setProperty(40, 0, "Y");
        this.m_connectionProperties.setProperty(43, 3, 7L);
        this.m_connectionProperties.setProperty(41, 0, "TEXT");
        this.m_connectionProperties.setProperty(42, 0, "00.00.0000");
        this.m_connectionProperties.setProperty(44, 3, 0L);
        this.m_connectionProperties.setProperty(45, 3, 1L);
        this.m_connectionProperties.setProperty(46, 0, "N");
        this.m_connectionProperties.setProperty(47, 3, 0L);
        this.m_connectionProperties.setProperty(48, 3, 0L);
        this.m_connectionProperties.setProperty(49, 3, 0L);
        this.m_connectionProperties.setProperty(50, 3, 0L);
        this.m_connectionProperties.setProperty(51, 3, 0L);
        this.m_connectionProperties.setProperty(52, 3, 0L);
        this.m_connectionProperties.setProperty(53, 3, 0L);
        this.m_connectionProperties.setProperty(54, 3, 0L);
        this.m_connectionProperties.setProperty(55, 0, "Y");
        this.m_connectionProperties.setProperty(56, 2, Character.valueOf('\u0002'));
        this.m_connectionProperties.setProperty(57, 2, Character.valueOf('\u0004'));
        this.m_connectionProperties.setProperty(58, 0, "\"");
        this.m_connectionProperties.setProperty(59, 3, 0L);
        this.m_connectionProperties.setProperty(60, 3, 4L);
        this.m_connectionProperties.setProperty(61, 0, "N");
        this.m_connectionProperties.setProperty(62, 0, "");
        this.m_connectionProperties.setProperty(63, 0, "Y");
        this.m_connectionProperties.setProperty(64, 3, 0L);
        this.m_connectionProperties.setProperty(65, 3, 0L);
        this.m_connectionProperties.setProperty(66, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(67, 3, 0L);
        this.m_connectionProperties.setProperty(68, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(69, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(70, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(71, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(72, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(73, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(74, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(75, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(76, 2, Character.valueOf('\u00ff'));
        this.m_connectionProperties.setProperty(77, 3, 0L);
        this.m_connectionProperties.setProperty(78, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(79, 3, 0L);
        this.m_connectionProperties.setProperty(80, 0, "N");
        this.m_connectionProperties.setProperty(81, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(82, 3, 0L);
        this.m_connectionProperties.setProperty(83, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(84, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(85, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(86, 0, "N");
        this.m_connectionProperties.setProperty(87, 0, "Y");
        this.m_connectionProperties.setProperty(88, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(89, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(90, 3, 0xFFFFFFL);
        this.m_connectionProperties.setProperty(91, 5, (short)1);
        this.m_connectionProperties.setProperty(92, 3, 127L);
        this.m_connectionProperties.setProperty(93, 0, "N");
        this.m_connectionProperties.setProperty(94, 0, "N");
        this.m_connectionProperties.setProperty(95, 3, 2L);
        this.m_connectionProperties.setProperty(96, 0, "procedure");
        this.m_connectionProperties.setProperty(97, 0, "Y");
        this.m_connectionProperties.setProperty(98, 2, Character.valueOf('\u0003'));
        this.m_connectionProperties.setProperty(99, 0, "schema");
        this.m_connectionProperties.setProperty(100, 3, 29L);
        this.m_connectionProperties.setProperty(101, 0, "");
        this.m_connectionProperties.setProperty(102, 0, "");
        this.m_connectionProperties.setProperty(103, 3, 1L);
        this.m_connectionProperties.setProperty(104, 3, 335743L);
        this.m_connectionProperties.setProperty(105, 3, 31L);
        this.m_connectionProperties.setProperty(106, 3, 14712831L);
        this.m_connectionProperties.setProperty(107, 3, 14946049L);
        this.m_connectionProperties.setProperty(108, 3, 14974975L);
        this.m_connectionProperties.setProperty(109, 3, 0xE7FFFFL);
        this.m_connectionProperties.setProperty(110, 3, 0x1000000L);
        this.m_connectionProperties.setProperty(111, 3, 14847745L);
        this.m_connectionProperties.setProperty(112, 3, 10510847L);
        this.m_connectionProperties.setProperty(113, 3, 14712831L);
        this.m_connectionProperties.setProperty(114, 3, 14712831L);
        this.m_connectionProperties.setProperty(115, 3, 14712831L);
        this.m_connectionProperties.setProperty(116, 3, 0L);
        this.m_connectionProperties.setProperty(117, 3, 0L);
        this.m_connectionProperties.setProperty(118, 3, 14946049L);
        this.m_connectionProperties.setProperty(119, 3, 0xE3F3FFL);
        this.m_connectionProperties.setProperty(120, 3, 10510847L);
        this.m_connectionProperties.setProperty(121, 3, 14712831L);
        this.m_connectionProperties.setProperty(122, 3, 14712831L);
        this.m_connectionProperties.setProperty(123, 3, 14880513L);
        this.m_connectionProperties.setProperty(124, 3, 14913281L);
        this.m_connectionProperties.setProperty(125, 3, 14712831L);
        this.m_connectionProperties.setProperty(126, 3, 14946049L);
        this.m_connectionProperties.setProperty(127, 3, 0xE7FFFFL);
        this.m_connectionProperties.setProperty(128, 3, 31981567L);
        this.m_connectionProperties.setProperty(129, 3, 31716351L);
        this.m_connectionProperties.setProperty(130, 3, 31981567L);
        this.m_connectionProperties.setProperty(131, 3, 7L);
        this.m_connectionProperties.setProperty(132, 0, "table");
        this.m_connectionProperties.setProperty(133, 3, 511L);
        this.m_connectionProperties.setProperty(134, 3, 511L);
        this.m_connectionProperties.setProperty(135, 3, 1048575L);
        this.m_connectionProperties.setProperty(136, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(137, 3, 1L);
        this.m_connectionProperties.setProperty(138, 3, 3L);
        this.m_connectionProperties.setProperty(139, 0, "");
        this.m_connectionProperties.setProperty(140, 3, 0L);
        this.m_connectionProperties.setProperty(141, 3, 0L);
        this.m_connectionProperties.setProperty(142, 3, 0L);
        this.m_connectionProperties.setProperty(143, 3, 0L);
        this.m_connectionProperties.setProperty(144, 3, 0L);
        this.m_connectionProperties.setProperty(145, 3, 0L);
        this.m_connectionProperties.setProperty(146, 3, 0L);
        this.m_connectionProperties.setProperty(147, 3, 0L);
        this.m_connectionProperties.setProperty(148, 3, 0L);
        this.m_connectionProperties.setProperty(149, 3, 2L);
        this.m_connectionProperties.setProperty(150, 0, "N");
        this.m_connectionProperties.setProperty(151, 0, "\\");
        this.m_connectionProperties.setProperty(152, 3, 0L);
        this.m_connectionProperties.setProperty(153, 3, 0L);
        this.m_connectionProperties.setProperty(154, 3, 0L);
        this.m_connectionProperties.setProperty(155, 3, 0L);
        this.m_connectionProperties.setProperty(156, 3, 0L);
        this.m_connectionProperties.setProperty(159, 3, 16L);
        this.m_connectionProperties.setProperty(157, 3, 0L);
        this.m_connectionProperties.setProperty(158, 3, 16135L);
        this.m_connectionProperties.setProperty(160, 3, 346L);
        this.m_connectionProperties.setProperty(161, 3, 16L);
        this.m_connectionProperties.setProperty(162, 3, 15L);
        this.m_connectionProperties.setProperty(163, 3, 6L);
        this.m_connectionProperties.setProperty(164, 3, 15L);
        this.m_connectionProperties.setProperty(165, 3, 0L);
        this.m_connectionProperties.setProperty(1000, 5, (short)0);
        this.m_connectionProperties.setProperty(1001, 3, 0L);
        this.m_connectionProperties.setProperty(1002, new Variant(3, 0L));
    }
}

