/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.VConnectionPropertyKey;
import com.vertica.core.VConnectionPropertyValue;
import com.vertica.core.VDriver;
import com.vertica.core.VEnvironment;
import com.vertica.core.VStatement;
import com.vertica.dataengine.SimpleQueryExecutor;
import com.vertica.dataengine.VMetadataSource;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dataengine.VResultSet;
import com.vertica.dsi.core.impl.DSIConnection;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.interfaces.ITransactionStateListener;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.ConnectionSetting;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.BadAuthException;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.io.AuthMD5ResponseMessage;
import com.vertica.io.CancelRequestMessage;
import com.vertica.io.CopyErrorRequestMessage;
import com.vertica.io.ErrorResponseMessage;
import com.vertica.io.KeyDataResponseMessage;
import com.vertica.io.Message;
import com.vertica.io.MessageType;
import com.vertica.io.PasswordRequestMessage;
import com.vertica.io.ProtocolStream;
import com.vertica.io.ReadyForQueryResponseMessage;
import com.vertica.io.ResponseMessage;
import com.vertica.io.StartupRequestMessage;
import com.vertica.io.SyncRequestMessage;
import com.vertica.io.TerminateRequestMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogLevel;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.WarningCode;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.util.LRSException;
import com.vertica.util.LRSWork;
import com.vertica.util.ServerErrorData;
import com.vertica.util.ServerException;
import com.vertica.util.TransactionStateException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VConnection
extends DSIConnection {
    private static final int MAX_LABEL_LENGTH = 255;
    private static final String LOG_PREFIX_NAME = "vjdbc";
    private static SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat("MM-dd_HH.mm.ss.SSSS");
    private static final AtomicInteger s_connectionCounter = new AtomicInteger(0);
    public static final String VERTICA_CHARSET;
    private DSILogger m_log;
    private String m_logPackage;
    private String m_logPath;
    private ProtocolStream m_protocolStream;
    private SimpleQueryExecutor m_simpleQueryExecutor;
    private AtomicInteger m_statementCounter;
    private String m_host;
    private String m_dbname;
    private String m_user;
    private boolean m_useSSL;
    private String m_password;
    private int m_port;
    private int m_loginTimeout;
    private String m_sessionLabel;
    private boolean m_directBatchInsert;
    private long m_resultBufferSize;
    private boolean m_useThreePartNaming;
    private boolean m_stringBatchInsert;
    private String m_locale;
    private String m_searchPath;
    private boolean m_areLongStringEnabled;
    private int m_cancelKey;
    private int m_serverProcId;
    private String m_serverVersion = "00.00.0000";
    private static Map<MetadataParamsKey, VMetadataSource> m_metadataCache;
    private boolean m_inLRS;
    private List<LRSWork> m_lrsWorkQueue;
    private boolean m_isConnected;
    private boolean m_useStandardConformingStrings;
    private boolean m_useStrictCatalogFiltering;
    private boolean m_addTzToTimestampParameters;
    private boolean m_inTransactionAPICall;
    private boolean m_withinTransaction;
    private char m_serverTransactionState;
    private VQueryExecutor m_currentCopyExecutor;
    private VResultSet m_currentOpenResult;

    protected VConnection(VEnvironment vEnvironment) throws ErrorException {
        super(vEnvironment);
        if (VERTICA_CHARSET == null) {
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_NO_UTF8.toString());
        }
        this.getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_log, vEnvironment);
        this.m_simpleQueryExecutor = new SimpleQueryExecutor(this);
        this.m_statementCounter = new AtomicInteger();
        this.m_lrsWorkQueue = new ArrayList<LRSWork>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl = false;
        try {
            this.loadPreConnectSettings(connSettingRequestMap);
            LogUtilities.logInfo(String.format("Connecting as %s to %s on %s:%d", this.m_user, this.m_dbname, this.m_host, this.m_port), (ILogger)this.m_log);
            this.m_protocolStream = new ProtocolStream(this);
            if (this.m_useSSL) {
                this.m_protocolStream.enableSSL();
            }
            this.startup();
            this.authenticate();
            this.readStartupMessages();
            this.m_isConnected = true;
            this.getMetadataSource(MetadataSourceID.TYPE_INFO, new HashMap<MetadataSourceColumnTag, String>(), "\\", "\"", false);
            this.loadPostConnectSettings(connSettingRequestMap);
            this.setConnectionProperties();
            bl = true;
            this.m_protocolStream.enableOpenChecking();
        }
        finally {
            if (!bl) {
                this.close();
            } else {
                LogUtilities.logInfo("Connection is ready", (ILogger)this.m_log);
            }
        }
    }

    private void loadPreConnectSettings(ConnSettingRequestMap connSettingRequestMap) throws GeneralException, BadAuthException {
        this.m_host = this.getRequiredSetting("host", connSettingRequestMap).getString();
        this.m_dbname = this.getRequiredSetting("database", connSettingRequestMap).getString();
        this.m_user = this.getRequiredSetting("user", connSettingRequestMap).getString();
        this.m_password = this.getRequiredSetting("password", connSettingRequestMap).getString();
        Variant variant = null;
        try {
            variant = this.getOptionalSetting("port", connSettingRequestMap);
            this.m_port = variant == null ? 5433 : (int)variant.getShort();
        }
        catch (UtilsException utilsException) {
            this.m_port = 5433;
            this.warnBadParameter("port", variant);
        }
        variant = this.getOptionalSetting("loglevel", connSettingRequestMap);
        this.setLogLevel(variant == null ? VConnectionPropertyValue.DEFAULT_LOG_LEVEL.toString() : variant.getString());
        variant = this.getOptionalSetting("lognamespace", connSettingRequestMap);
        this.setLogPackage(variant == null ? "com.vertica" : variant.getString());
        variant = this.getOptionalSetting("logpath", connSettingRequestMap);
        this.setLogPath(variant == null ? "" : variant.getString());
        try {
            variant = this.getOptionalSetting("resultbuffersize", connSettingRequestMap);
            this.setResultBufferSize(variant == null ? 8192L : variant.getLong());
        }
        catch (GeneralException generalException) {
            this.setResultBufferSize(8192L);
            this.warnBadParameter("resultbuffersize", variant);
        }
        catch (UtilsException utilsException) {
            this.setResultBufferSize(8192L);
            this.warnBadParameter("resultbuffersize", variant);
        }
        try {
            variant = this.getOptionalSetting("logintimeout", connSettingRequestMap);
            this.setLoginTimeout(variant == null ? 0 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setLoginTimeout(0);
            this.warnBadParameter("logintimeout", variant);
        }
        variant = this.getOptionalSetting("sessionlabel", connSettingRequestMap);
        String string = variant == null ? "jdbc-" + VDriver.DRIVER_VERSION + "-" + UUID.randomUUID().toString() : variant.getString();
        this.setSessionLabel(string);
        variant = this.getOptionalSetting("directbatchinsert", connSettingRequestMap);
        this.setDirectBatchInsert(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("stringbatchinsert", connSettingRequestMap);
        this.setStringBatchInsert(variant == null ? true : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("strictcatalogfiltering", connSettingRequestMap);
        this.setUseStrictCatalogFiltering(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("addtztotimestampparameters", connSettingRequestMap);
        this.setAddTzToTimestampParameters(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("ssl", connSettingRequestMap);
        this.setUseSSL(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("threepartnaming", connSettingRequestMap);
        this.setUseThreePartNaming(variant == null ? true : Boolean.parseBoolean(variant.getString()));
    }

    private void loadPostConnectSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        block22: {
            Object object;
            Variant variant;
            block21: {
                variant = null;
                try {
                    this.setProperty(139, new Variant(0, this.m_user));
                }
                catch (BadAttrValException badAttrValException) {
                    assert (false);
                }
                catch (UtilsException utilsException) {
                    if ($assertionsDisabled) break block21;
                    throw new AssertionError();
                }
            }
            try {
                variant = this.getOptionalSetting("autocommit", connSettingRequestMap);
                boolean bl = variant == null ? true : Boolean.parseBoolean(variant.getString());
                this.setProperty(19, new Variant(3, bl ? 1L : 0L));
            }
            catch (BadAttrValException badAttrValException) {
                this.warnBadParameter("autocommit", variant);
            }
            catch (UtilsException utilsException) {
                this.warnBadParameter("autocommit", variant);
            }
            try {
                variant = this.getOptionalSetting("readonly", connSettingRequestMap);
                boolean bl = variant == null ? false : Boolean.parseBoolean(variant.getString());
                object = new Variant(3, bl ? 1L : 0L);
                if (bl) {
                    this.setProperty(16, (Variant)object);
                } else {
                    this.setPropertySDKOnly(16, (Variant)object);
                }
            }
            catch (BadAttrValException badAttrValException) {
                this.warnBadParameter("readonly", variant);
            }
            catch (UtilsException utilsException) {
                this.warnBadParameter("readonly", variant);
            }
            try {
                variant = this.getOptionalSetting("transactionisolation", connSettingRequestMap);
                int n = variant == null ? 0 : variant.getInt();
                this.setProperty(26, new Variant(3, n));
            }
            catch (BadAttrValException badAttrValException) {
                this.warnBadParameter("transactionisolation", variant);
            }
            catch (UtilsException utilsException) {
                this.warnBadParameter("transactionisolation", variant);
            }
            variant = this.getOptionalSetting("locale", connSettingRequestMap);
            if (variant != null) {
                this.setServerLocale(variant.getString(), true);
            }
            String string = (variant = this.getOptionalSetting("searchpath", connSettingRequestMap)) == null ? "" : variant.getString();
            this.setSearchPath(string, true);
            variant = this.getOptionalSetting("connsettings", connSettingRequestMap);
            Object object2 = object = variant == null ? "" : variant.getString();
            if (!"".equals(object)) {
                this.m_simpleQueryExecutor.execute((String)object);
            }
            try {
                this.setProperty(20, new Variant(3, 0L));
            }
            catch (BadAttrValException badAttrValException) {
                assert (false);
            }
            catch (UtilsException utilsException) {
                if ($assertionsDisabled) break block22;
                throw new AssertionError();
            }
        }
    }

    private void warnBadParameter(String string, Variant variant) {
        String string2 = this.getMessageSource().loadMessage(this.getLocale(), 101, VMessageKey.ERROR_ILLEGAL_PARAM_VALUE.toString(), new String[]{string, variant == null ? "null" : variant.getString()}, false);
        LogUtilities.logWarning(string2, (ILogger)this.m_log);
        this.getWarningListener().postWarning(new Warning(WarningCode.INVALID_CONNECTION_STRING_ATTRIBUTE, string2));
    }

    private void setConnectionProperties() throws ErrorException {
        block6: {
            try {
                this.setProperty(1, new Variant(0, "N"));
                this.setProperty(2, new Variant(0, "N"));
                long l = 0L;
                l = 64L;
                l |= 1L;
                l |= 2L;
                l |= 0x20L;
                l |= 4L;
                l |= 8L;
                this.setProperty(4, new Variant(3, l |= 0x10L));
                this.setProperty(5, new Variant(3, 0L));
                l = 32L;
                l |= 8L;
                l |= 0x8000L;
                l |= 0x40L;
                l |= 0x1000L;
                l |= 0x40L;
                l |= 0x200L;
                l |= 0x2000L;
                l |= 0x4000L;
                this.setProperty(6, new Variant(3, l |= 0x100L));
                this.setProperty(140, new Variant(3, 2L));
                l = 3L;
                this.setProperty(141, new Variant(3, l));
                this.setProperty(7, new Variant(3, 0L));
                this.setProperty(8, new Variant(3, 1L));
                this.setProperty(10, new Variant(0, "."));
                this.setProperty(11, new Variant(0, "catalog"));
                l = 21L;
                this.setProperty(12, new Variant(3, l));
                this.setProperty(13, new Variant(0, ""));
                this.setProperty(14, new Variant(0, "Y"));
                this.setProperty(15, new Variant(3, 0L));
                Variant variant = new Variant(3, 1597951L);
                Variant variant2 = new Variant(3, 25087L);
                Variant variant3 = new Variant(3, 25087L);
                long l2 = 0x1BF1FFL;
                Variant variant4 = new Variant(3, l2);
                Variant variant5 = new Variant(3, l2 | (this.m_areLongStringEnabled ? 512L : 0L));
                Variant variant6 = new Variant(3, 769L);
                Variant variant7 = new Variant(3, 262144L);
                Variant variant8 = new Variant(3, 0L);
                this.setProperty(106, variant);
                this.setProperty(107, new Variant(3, 3072L));
                this.setProperty(108, new Variant(3, 4353L));
                this.setProperty(109, variant4);
                this.setProperty(111, new Variant(3, 164097L));
                this.setProperty(112, variant3);
                this.setProperty(113, variant2);
                this.setProperty(114, variant2);
                this.setProperty(115, variant);
                this.setProperty(116, new Variant(3, 549145L));
                this.setProperty(117, new Variant(3, 0x116119L));
                this.setProperty(118, this.m_areLongStringEnabled ? variant7 : variant8);
                this.setProperty(119, this.m_areLongStringEnabled ? variant6 : variant8);
                this.setProperty(120, variant3);
                this.setProperty(121, variant2);
                this.setProperty(122, variant);
                this.setProperty(123, new Variant(3, 0x110101L));
                this.setProperty(124, new Variant(3, 229633L));
                this.setProperty(125, variant);
                this.setProperty(126, new Variant(3, 0xC00L | (this.m_areLongStringEnabled ? 262144L : 0L)));
                this.setProperty(127, variant5);
                this.setProperty(128, variant4);
                this.setProperty(130, variant5);
                this.setProperty(28, new Variant(3, 2L));
                this.setProperty(29, new Variant(3, 0L));
                this.setProperty(30, new Variant(3, 0L));
                this.setProperty(31, new Variant(3, 0L));
                this.setProperty(32, new Variant(3, 0L));
                this.setProperty(27, new Variant(3, 3L));
                l = 3L;
                this.setProperty(33, new Variant(3, l));
                l = 16L;
                l |= 4L;
                l |= 0x400L;
                this.setProperty(34, new Variant(3, l |= 1L));
                this.setProperty(35, new Variant(3, 0L));
                this.setProperty(36, new Variant(3, 1L));
                this.setProperty(37, new Variant(3, 1L));
                this.setProperty(38, new Variant(3, 1L));
                this.setProperty(39, new Variant(3, 0L));
                this.setProperty(40, new Variant(0, "N"));
                l = 1L;
                l |= 2L;
                l |= 4L;
                l |= 8L;
                l |= 0x10L;
                l |= 0x20L;
                l |= 0x40L;
                l |= 0x80L;
                l |= 0x100L;
                l |= 0x400L;
                l |= 0x800L;
                l |= 0x1000L;
                l |= 0x2000L;
                l |= 0x4000L;
                l |= 0x8000L;
                this.setProperty(43, new Variant(3, l |= 0x200L));
                this.setProperty(41, new Variant(0, VDriver.SERVER_PRODUCT_NAME));
                this.setProperty(42, new Variant(0, this.m_serverVersion));
                this.setProperty(44, new Variant(3, 0L));
                l = 2L;
                this.setProperty(45, new Variant(3, l));
                this.setProperty(46, new Variant(0, "N"));
                this.setProperty(47, new Variant(3, 0L));
                this.setProperty(48, new Variant(3, 0L));
                this.setProperty(49, new Variant(3, 0L));
                this.setProperty(50, new Variant(3, 0L));
                l = 1L;
                l |= 4L;
                this.setProperty(51, new Variant(3, l |= 2L));
                l = 1L;
                l |= 4L;
                this.setProperty(52, new Variant(3, l |= 2L));
                this.setProperty(53, new Variant(3, 0L));
                this.setProperty(54, new Variant(3, 1L));
                this.setProperty(1000, new Variant(5, (short)1));
                this.setProperty(1001, new Variant(3, 0L));
                this.setProperty(142, new Variant(3, 0L));
                this.setProperty(143, new Variant(3, 0L));
                this.setProperty(55, new Variant(0, "Y"));
                this.setProperty(144, new Variant(3, 1L));
                this.setProperty(145, new Variant(3, 1L));
                this.setProperty(56, new Variant(3, 2L));
                this.setProperty(57, new Variant(2, Character.valueOf('\u0004')));
                this.setProperty(58, new Variant(0, "\""));
                this.setProperty(59, new Variant(3, 0L));
                this.setProperty(146, new Variant(3, 0L));
                l = 1L;
                l |= 2L;
                this.setProperty(60, new Variant(3, l |= 4L));
                this.setProperty(61, new Variant(0, "N"));
                this.setProperty(147, new Variant(3, 0L));
                this.setProperty(148, new Variant(3, 0L));
                this.setProperty(1002, new Variant(3, 0L));
                Character c = Character.valueOf('\u0000');
                Character c2 = Character.valueOf('\u0080');
                this.setProperty(63, new Variant(0, "Y"));
                this.setProperty(64, new Variant(3, 0L));
                this.setProperty(65, this.m_areLongStringEnabled ? new Variant(3, new Long(32000000L)) : variant8);
                this.setProperty(66, new Variant(2, c));
                this.setProperty(67, this.m_areLongStringEnabled ? new Variant(3, new Long(32000000L)) : variant8);
                this.setProperty(68, new Variant(2, c2));
                this.setProperty(69, new Variant(2, c));
                this.setProperty(70, new Variant(2, c));
                this.setProperty(71, new Variant(2, c));
                this.setProperty(72, new Variant(2, c));
                this.setProperty(73, new Variant(2, Character.valueOf('\u0640')));
                this.setProperty(74, new Variant(2, c));
                this.setProperty(75, new Variant(2, c));
                this.setProperty(76, new Variant(2, c2));
                this.setProperty(77, new Variant(3, 0L));
                this.setProperty(78, new Variant(2, c2));
                this.setProperty(79, new Variant(3, this.m_areLongStringEnabled ? new Long(32000000L) : 0x800000L));
                this.setProperty(80, new Variant(0, this.m_areLongStringEnabled ? "Y" : "N"));
                this.setProperty(81, new Variant(2, c2));
                this.setProperty(82, new Variant(3, 0L));
                this.setProperty(83, new Variant(2, c2));
                this.setProperty(84, new Variant(2, c));
                this.setProperty(85, new Variant(2, c2));
                this.setProperty(86, new Variant(0, "Y"));
                this.setProperty(87, new Variant(0, "Y"));
                this.setProperty(88, new Variant(3, 1L));
                this.setProperty(89, new Variant(3, 1L));
                l = 1L;
                l |= 2L;
                l |= 4L;
                l |= 8L;
                l |= 0x10L;
                l |= 0x20L;
                l |= 0x40L;
                l |= 0x80L;
                l |= 0x40000L;
                l |= 0x100L;
                l |= 0x200L;
                l |= 0x400L;
                l |= 0x800L;
                l |= 0x10000L;
                l |= 0x100000L;
                l |= 0x200000L;
                l |= 0x400000L;
                l |= 0x1000L;
                l |= 0x2000L;
                l |= 0x4000L;
                this.setProperty(90, new Variant(3, l |= 0x8000L));
                this.setProperty(91, new Variant(5, (short)1));
                l = 64L;
                l |= 4L;
                l |= 0x20L;
                l |= 1L;
                l |= 8L;
                l |= 0x10L;
                this.setProperty(92, new Variant(3, l |= 2L));
                this.setProperty(93, new Variant(0, "Y"));
                this.setProperty(95, new Variant(3, 1L));
                this.setProperty(149, new Variant(3, 1L));
                this.setProperty(96, new Variant(0, "function"));
                this.setProperty(97, new Variant(0, "N"));
                this.setProperty(98, new Variant(2, Character.valueOf('\u0004')));
                this.setProperty(150, new Variant(0, "N"));
                this.setProperty(99, new Variant(0, "schema"));
                l = 21L;
                this.setProperty(100, new Variant(3, l));
                this.setProperty(151, new Variant(0, "\\"));
                this.setProperty(101, new Variant(0, this.m_host));
                this.setProperty(102, new Variant(0, ""));
                this.setProperty(103, new Variant(3, 1L));
                l = 7L;
                this.setProperty(154, new Variant(3, l));
                this.setProperty(155, new Variant(3, 0L));
                this.setProperty(156, new Variant(3, 0L));
                l = 1024L;
                l |= 0x40L;
                l |= 0x800L;
                l |= 0x20L;
                l |= 0x100L;
                this.setProperty(159, new Variant(3, l |= 0x10L));
                l = 1L;
                l |= 0x10L;
                l |= 0x20L;
                this.setProperty(157, new Variant(3, l |= 4L));
                l = 2048L;
                l |= 0x1000L;
                l |= 1L;
                l |= 0x400L;
                l |= 2L;
                l |= 4L;
                l |= 0x2000L;
                this.setProperty(158, new Variant(3, l |= 0x80L));
                l = 2L;
                l |= 8L;
                l |= 0x10L;
                l |= 0x80L;
                l |= 0x40L;
                this.setProperty(160, new Variant(3, l |= 0x100L));
                this.setProperty(94, new Variant(0, "Y"));
                l = 128L;
                l |= 0x20L;
                l |= 0x400L;
                l |= 0x100L;
                l |= 0x2000L;
                l |= 0x1000L;
                l |= 0x1000L;
                this.setProperty(161, new Variant(3, l |= 0x10L));
                l = 4L;
                l |= 2L;
                this.setProperty(162, new Variant(3, l |= 1L));
                l = 1L;
                l |= 2L;
                l |= 8L;
                l |= 0x10L;
                l |= 0x20L;
                l |= 0x40L;
                this.setProperty(163, new Variant(3, l |= 0x80L));
                l = 1L;
                l |= 2L;
                l |= 8L;
                this.setProperty(164, new Variant(3, l |= 4L));
                l = 1L;
                this.setProperty(152, new Variant(3, 0L));
                this.setProperty(153, new Variant(3, 0L));
                l = 8192L;
                l |= 0x100000L;
                l |= 0x100000L;
                l |= 1L;
                l |= 2L;
                l |= 0x40L;
                l |= 4L;
                l |= 0x10L;
                l |= 8L;
                l |= 0x400000L;
                l |= 0x800000L;
                l |= 0x80L;
                l |= 0x100L;
                l |= 0x200L;
                l |= 0x400L;
                l |= 0x40000L;
                l |= 0x800L;
                this.setProperty(104, new Variant(3, l |= 0x1000L));
                l = 31L;
                this.setProperty(105, new Variant(3, l));
                l = 7L;
                this.setProperty(131, new Variant(3, l));
                this.setProperty(132, new Variant(0, "table"));
                l = 1L;
                l |= 4L;
                l |= 8L;
                l |= 0x10L;
                l |= 0x20L;
                l |= 0x40L;
                l |= 0x80L;
                this.setProperty(133, new Variant(3, l |= 0x100L));
                this.setProperty(134, new Variant(3, l));
                l = 131072L;
                l |= 0x40000L;
                l |= 0x80000L;
                l |= 2L;
                l |= 0x200L;
                l |= 8L;
                l |= 4L;
                l |= 0x10L;
                l |= 0x100000L;
                l |= 0x400L;
                l |= 0x800L;
                l |= 0x20L;
                l |= 1L;
                l |= 0x40L;
                l |= 0x1000L;
                l |= 0x2000L;
                l |= 0x4000L;
                l |= 0x80L;
                this.setProperty(135, new Variant(3, l |= 0x100L));
                this.setProperty(136, new Variant(2, Character.valueOf('\u0003')));
                l = 10L;
                this.setProperty(137, new Variant(3, l));
                l = 3L;
                this.setProperty(138, new Variant(3, l));
            }
            catch (BadAttrValException badAttrValException) {
                assert (false) : badAttrValException.getMessage();
            }
            catch (IncorrectTypeException incorrectTypeException) {
                assert (false) : incorrectTypeException.getMessage();
            }
            catch (NumericOverflowException numericOverflowException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)numericOverflowException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void disconnect() {
        block28: {
            block27: {
                LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
                if (!this.m_isConnected) {
                    return;
                }
                this.m_protocolStream.sendMessage(new TerminateRequestMessage());
                this.m_protocolStream.flush();
                Object var3_1 = null;
                this.m_protocolStream.close();
                try {
                    this.setProperty(20, new Variant(3, 0L));
                }
                catch (BadAttrValException badAttrValException) {
                    assert (false);
                }
                catch (ErrorException errorException) {
                    assert (false);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    assert (false);
                }
                catch (NumericOverflowException numericOverflowException) {
                    if ($assertionsDisabled) break block27;
                    throw new AssertionError();
                }
            }
            this.m_isConnected = false;
            {
                break block28;
                catch (GeneralException generalException) {
                    block29: {
                        LogUtilities.logError(generalException, (ILogger)this.m_log);
                        Object var3_2 = null;
                        this.m_protocolStream.close();
                        try {
                            this.setProperty(20, new Variant(3, 0L));
                        }
                        catch (BadAttrValException badAttrValException) {
                            assert (false);
                        }
                        catch (ErrorException errorException) {
                            assert (false);
                        }
                        catch (IncorrectTypeException incorrectTypeException) {
                            assert (false);
                        }
                        catch (NumericOverflowException numericOverflowException) {
                            if ($assertionsDisabled) break block29;
                            throw new AssertionError();
                        }
                    }
                    this.m_isConnected = false;
                }
            }
            catch (Throwable throwable) {
                block30: {
                    Object var3_3 = null;
                    this.m_protocolStream.close();
                    try {
                        this.setProperty(20, new Variant(3, 0L));
                    }
                    catch (BadAttrValException badAttrValException) {
                        assert (false);
                    }
                    catch (ErrorException errorException) {
                        assert (false);
                    }
                    catch (IncorrectTypeException incorrectTypeException) {
                        assert (false);
                    }
                    catch (NumericOverflowException numericOverflowException) {
                        if ($assertionsDisabled) break block30;
                        throw new AssertionError();
                    }
                }
                this.m_isConnected = false;
                throw throwable;
            }
        }
    }

    @Override
    public VStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        VStatement vStatement = new VStatement(this);
        return vStatement;
    }

    @Override
    public DSILogger getConnectionLog() {
        if (this.m_log == null) {
            this.m_log = new DSILogger("vjdbc-" + s_connectionCounter.incrementAndGet() + "-" + LOG_DATE_FORMAT.format(new Date()) + ".log");
        }
        return this.m_log;
    }

    @Override
    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        block23: {
            try {
                if (n == 19) {
                    String string = variant.getLong() == 1L ? "on" : "off";
                    this.executeTransactionStatement("set session autocommit to " + string, true);
                } else if (n == 26) {
                    if (variant.getLong() == 1L) {
                        this.m_simpleQueryExecutor.execute("set session characteristics as transaction isolation level read uncommitted");
                    } else if (variant.getLong() == 2L) {
                        this.m_simpleQueryExecutor.execute("set session characteristics as transaction isolation level read committed");
                    } else if (variant.getLong() == 4L) {
                        this.m_simpleQueryExecutor.execute("set session characteristics as transaction isolation level repeatable read");
                    } else if (variant.getLong() == 8L) {
                        this.m_simpleQueryExecutor.execute("set session characteristics as transaction isolation level serializable");
                    } else {
                        try {
                            variant = new Variant(3, 2L);
                        }
                        catch (IncorrectTypeException incorrectTypeException) {
                        }
                        catch (NumericOverflowException numericOverflowException) {}
                    }
                } else if (n == 16) {
                    if (variant.getLong() == 1L) {
                        this.m_simpleQueryExecutor.execute("set session characteristics as transaction read only");
                    } else if (variant.getLong() == 0L) {
                        this.m_simpleQueryExecutor.execute("set session characteristics as transaction read write");
                    } else assert (false);
                }
                super.setProperty(n, variant);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                if ($assertionsDisabled) break block23;
                throw new AssertionError();
            }
        }
    }

    public void setPropertySDKOnly(int n, Variant variant) {
        block2: {
            try {
                super.setProperty(n, variant);
            }
            catch (ErrorException errorException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        this.verifyRequiredSetting("host", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("port", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("database", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("user", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("password", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("loglevel", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("logpath", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("lognamespace", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("autocommit", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("directbatchinsert", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("logintimeout", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("readonly", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("resultbuffersize", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("sessionlabel", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ssl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("threepartnaming", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("transactionisolation", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("connsettings", connSettingRequestMap, connSettingResponseMap);
        Iterator<String> iterator = connSettingResponseMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            ConnectionSetting connectionSetting = connSettingResponseMap.getProperty(string);
            ArrayList<Variant> arrayList = VConnectionPropertyKey.getLegalValueVariants(string);
            if (arrayList != null) {
                connectionSetting.setValues(arrayList);
            }
            connectionSetting.setLabel(VConnectionPropertyKey.getProperyDescription(string));
        }
        return connSettingResponseMap;
    }

    @Override
    public void beginTransaction() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_withinTransaction = true;
    }

    public boolean withinTransaction() {
        return this.m_withinTransaction;
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.executeTransactionStatement("commit", true);
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.executeTransactionStatement("rollback", true);
    }

    @Override
    public void createSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        this.executeTransactionStatement("savepoint " + this.quoteIdentifier(string), false);
    }

    @Override
    public void releaseSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        this.executeTransactionStatement("release savepoint " + this.quoteIdentifier(string), false);
    }

    @Override
    public void rollback(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        this.executeTransactionStatement("rollback to " + this.quoteIdentifier(string), true);
    }

    private String quoteIdentifier(String string) {
        if (!string.startsWith("\"")) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeTransactionStatement(String string, boolean bl) throws ErrorException {
        try {
            assert (!this.m_inTransactionAPICall);
            while (bl && this.inLRS()) {
                assert (this.m_currentOpenResult != null);
                this.m_currentOpenResult.close();
            }
            this.m_inTransactionAPICall = true;
            this.m_simpleQueryExecutor.execute(string);
        }
        finally {
            this.m_inTransactionAPICall = false;
        }
    }

    public boolean inTransactionAPICall() {
        return this.m_inTransactionAPICall;
    }

    public void cancelCurrentStatement() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ProtocolStream protocolStream = new ProtocolStream(this);
        protocolStream.sendMessage(new CancelRequestMessage(this.m_serverProcId, this.m_cancelKey));
        protocolStream.flush();
        protocolStream.close();
    }

    private void startup() throws GeneralException {
        String[][] stringArray = new String[][]{{"user", this.m_user}, {"database", this.m_dbname}, {"client_encoding", "UNICODE"}, {"DateStyle", "ISO"}, {"client_pid", this.getProcessId().toString()}, {"client_label", this.m_sessionLabel}};
        this.m_protocolStream.sendMessage(new StartupRequestMessage(stringArray));
    }

    private void authenticate() throws ErrorException {
        boolean bl;
        ResponseMessage responseMessage;
        block17: {
            responseMessage = null;
            bl = false;
            boolean bl2 = false;
            try {
                do {
                    responseMessage = this.m_protocolStream.readMessage();
                    switch (responseMessage.getType()) {
                        case AuthCrypt: {
                            LogUtilities.logInfo("Server has requested crypt authentication.", (ILogger)this.m_log);
                            throw new BadAuthException(101, VMessageKey.ERROR_AUTH_FAILED_BAD_ALGO.toString(), "");
                        }
                        case AuthMD5: {
                            Object object = ((AuthMD5ResponseMessage)responseMessage).getSalt();
                            LogUtilities.logInfo("Server has requested MD5 authentication.", (ILogger)this.m_log);
                            this.m_protocolStream.sendMessage(new PasswordRequestMessage(this.m_user, this.m_password, (byte[])object));
                            break;
                        }
                        case AuthPassword: {
                            LogUtilities.logInfo("Server has requested password authentication.", (ILogger)this.m_log);
                            this.m_protocolStream.sendMessage(new PasswordRequestMessage(this.m_password));
                            break;
                        }
                        case AuthPasswordExpired: {
                            LogUtilities.logError("The password for " + this.m_user + " has expired.", (ILogger)this.m_log);
                            throw new BadAuthException(101, VMessageKey.ERROR_AUTH_FAILED_PW_EXPIRED.toString(), "");
                        }
                        case AuthK5: {
                            LogUtilities.logInfo("Server has requested Kerberos 5 authentication.", (ILogger)this.m_log);
                            throw new BadAuthException(101, VMessageKey.ERROR_AUTH_FAILED_BAD_ALGO.toString(), "");
                        }
                        case AuthSCM: {
                            LogUtilities.logInfo("Server has requested SCM authentication.", (ILogger)this.m_log);
                            throw new BadAuthException(101, VMessageKey.ERROR_AUTH_FAILED_BAD_ALGO.toString(), "");
                        }
                        case AuthPasswordGrace: {
                            Object object = this.getMessageSource().loadMessage(this.getLocale(), 101, VMessageKey.WARNING_PW_EXPIRING.toString(), this.m_user, false);
                            LogUtilities.logWarning((String)object, (ILogger)this.m_log);
                            Warning warning = new Warning(WarningCode.GENERAL_WARNING, (String)object);
                            IWarningListener iWarningListener = this.getWarningListener();
                            iWarningListener.postWarning(warning);
                            break;
                        }
                        case AuthOk: {
                            LogUtilities.logInfo("User " + this.m_user + " successfully authenticated.", (ILogger)this.m_log);
                        }
                        case Error: {
                            bl2 = true;
                        }
                    }
                } while (!bl2);
            }
            catch (ErrorException errorException) {
                LogUtilities.logError(errorException, (ILogger)this.m_log);
                bl = true;
                if (!(errorException instanceof BadAuthException)) break block17;
                throw errorException;
            }
        }
        if (responseMessage != null && responseMessage.getType().equals((Object)MessageType.Error)) {
            throw ((ErrorResponseMessage)responseMessage).getErrorData().buildException();
        }
        assert (bl || responseMessage.getType().equals((Object)MessageType.AuthOk));
        if (bl) {
            throw new BadAuthException(101, VMessageKey.ERROR_AUTH_FAILED.toString(), "");
        }
    }

    private void readStartupMessages() throws ErrorException {
        Object object;
        ResponseMessage responseMessage;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        block5: while (true) {
            responseMessage = this.m_protocolStream.readMessage();
            switch (responseMessage.getType()) {
                case ReadyForQuery: {
                    char c = ((ReadyForQueryResponseMessage)responseMessage).getTxnState();
                    this.setServerTxnState(c, false, false);
                    return;
                }
                case KeyData: {
                    object = (KeyDataResponseMessage)responseMessage;
                    this.m_cancelKey = ((KeyDataResponseMessage)object).getKey();
                    this.m_serverProcId = ((KeyDataResponseMessage)object).getServerProcessId();
                    continue block5;
                }
                case Error: {
                    object = (ErrorResponseMessage)responseMessage;
                    throw ((ErrorResponseMessage)object).getErrorData().buildException();
                }
            }
            break;
        }
        object = responseMessage.getType();
        throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNEXPECTED_TYPE.toString(), object == null ? "null" : ((Enum)object).toString());
    }

    private Integer getProcessId() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (stringBuffer.length() > 0) break;
        }
        try {
            return Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setLongStringsEnabled(boolean bl) {
        this.m_areLongStringEnabled = bl;
    }

    public void setServerVersion(String string) {
        try {
            string = string.substring(1);
            String[] stringArray = string.split("[.]");
            int n = this.tryParseInt(stringArray[0]);
            int n2 = this.tryParseInt(stringArray[1]);
            int n3 = 0;
            int n4 = 0;
            if (stringArray.length > 2) {
                String[] stringArray2;
                String[] stringArray3 = stringArray[2].split("-");
                if (stringArray3.length > 0) {
                    n3 = this.tryParseInt(stringArray3[0]);
                }
                if (stringArray3.length > 1 && ((n4 = this.tryParseInt((stringArray2 = stringArray3[1].split("_"))[0])) < 0 || n4 > 99)) {
                    n4 = 0;
                }
            }
            this.m_serverVersion = String.format("%02d.%02d.%02d%02d", n, n2, n3, n4);
        }
        catch (Exception exception) {
            LogUtilities.logError("Could not parse the server version string. Server version will remain " + this.m_serverVersion, (ILogger)this.m_log);
        }
        LogUtilities.logInfo("Server version is " + this.m_serverVersion, (ILogger)this.m_log);
    }

    private int tryParseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LogUtilities.logError(numberFormatException, (ILogger)this.m_log);
        }
        return n;
    }

    public final ProtocolStream getProtocolStream() {
        return this.m_protocolStream;
    }

    public boolean inLRS() {
        return this.m_inLRS;
    }

    public void setInLRS(boolean bl) {
        if (bl != this.m_inLRS) {
            LogUtilities.logInfo("LRS mode " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        }
        this.m_inLRS = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeLRSWorkQueue() throws ErrorException {
        try {
            for (LRSWork lRSWork : this.m_lrsWorkQueue) {
                lRSWork.execute();
            }
        }
        finally {
            this.m_lrsWorkQueue.clear();
        }
    }

    public void enqueueLRSWork(LRSWork lRSWork) {
        this.m_lrsWorkQueue.add(lRSWork);
    }

    public synchronized void ensureNotInLRS(String string, long l) throws LRSException, ErrorException {
        if (this.m_currentOpenResult != null) {
            this.m_currentOpenResult.tryFinishReadingResult();
        }
        if (this.m_inLRS) {
            assert (this.m_currentOpenResult != null);
            throw new LRSException(string, this.m_currentOpenResult.getResultBufferSize());
        }
    }

    public void setCurrentCopy(VQueryExecutor vQueryExecutor) throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, vQueryExecutor);
        this.m_currentCopyExecutor = vQueryExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCurrentCopy() throws ErrorException {
        try {
            if (this.m_currentCopyExecutor != null) {
                this.m_currentCopyExecutor.endCopy();
            }
        }
        finally {
            this.m_currentCopyExecutor = null;
        }
    }

    public VQueryExecutor getCurrentCopyExecutor() {
        return this.m_currentCopyExecutor;
    }

    public synchronized void handleError(boolean bl, ErrorException errorException) throws ErrorException {
        LogUtilities.logError(errorException, (ILogger)this.m_log);
        if (errorException instanceof LRSException || errorException instanceof TransactionStateException) {
            return;
        }
        try {
            Object object;
            boolean bl2 = false;
            if (errorException instanceof ServerException) {
                object = ((ServerException)errorException).getError();
                String string = ((ServerErrorData)object).getSeverity();
                if ("FATAL".equalsIgnoreCase(string)) {
                    this.close();
                    return;
                }
                bl2 = "ROLLBACK".equalsIgnoreCase(string);
            } else if (this.getCurrentCopyExecutor() != null) {
                bl = false;
                object = errorException;
                if (errorException.getCause() != null) {
                    object = errorException.getCause();
                }
                this.m_protocolStream.sendMessage(new CopyErrorRequestMessage((Throwable)object));
            } else {
                bl = true;
            }
            if (bl) {
                this.m_protocolStream.sendMessage(new SyncRequestMessage());
                this.m_protocolStream.flush();
            }
            object = this.m_protocolStream.readMessage();
            while (!((Message)object).getType().equals((Object)MessageType.ReadyForQuery)) {
                object = this.m_protocolStream.readMessage();
            }
            this.setInLRS(false);
            this.setCurrentCopy(null);
            this.setCurrentResult(null);
            this.setServerTxnState(((ReadyForQueryResponseMessage)object).getTxnState(), bl2, false);
        }
        catch (TransactionStateException transactionStateException) {
            assert (false) : transactionStateException.getMessage();
        }
        catch (ErrorException errorException2) {
            LogUtilities.logError(errorException2, (ILogger)this.m_log);
            this.close();
            throw errorException2;
        }
    }

    public String makeStatementName() {
        return "s" + this.m_statementCounter.incrementAndGet();
    }

    public VMetadataSource getMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        MetadataParamsKey metadataParamsKey = new MetadataParamsKey(metadataSourceID, map, string, string2, bl, this.m_areLongStringEnabled);
        VMetadataSource vMetadataSource = m_metadataCache.get(metadataParamsKey);
        if (vMetadataSource == null) {
            vMetadataSource = new VMetadataSource(this, metadataSourceID, map, string, string2, bl);
            switch (metadataSourceID) {
                case TYPE_INFO: {
                    m_metadataCache.put(metadataParamsKey, vMetadataSource);
                }
            }
            return vMetadataSource;
        }
        return new VMetadataSource(this, metadataSourceID, map, string, string2, bl, (VResultSet)vMetadataSource.getResultSet());
    }

    public ITransactionStateListener getTransactionStateListener() {
        return this.m_transactionListener;
    }

    public void setCurrentResult(VResultSet vResultSet) {
        LogUtilities.logFunctionEntrance(this.m_log, vResultSet);
        this.m_currentOpenResult = vResultSet;
    }

    public VResultSet getCurrentResult() {
        return this.m_currentOpenResult;
    }

    public void setServerTxnState(char c, boolean bl, boolean bl2) throws TransactionStateException {
        if (this.m_serverTransactionState != c) {
            this.m_serverTransactionState = c;
            this.m_withinTransaction = c == 'T';
            try {
                if (bl && !this.isAutoCommitEnabled() && c == 'I') {
                    if (bl2) {
                        this.getTransactionStateListener().notifyRollback();
                    } else {
                        this.getTransactionStateListener().notifyCommit();
                    }
                }
            }
            catch (ErrorException errorException) {
                throw new TransactionStateException(errorException);
            }
        }
    }

    public char getServerTxnState() {
        return this.m_serverTransactionState;
    }

    public boolean isAutoCommitEnabled() {
        try {
            return this.getProperty(19).getLong() == 1L;
        }
        catch (IncorrectTypeException incorrectTypeException) {
        }
        catch (BadPropertyKeyException badPropertyKeyException) {
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    public boolean isReadOnly() {
        try {
            Variant variant = this.getProperty(16);
            return variant.getLong() == 1L;
        }
        catch (IncorrectTypeException incorrectTypeException) {
        }
        catch (BadPropertyKeyException badPropertyKeyException) {
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    public String getDatabaseName() {
        return this.m_dbname;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getLogPath() {
        return this.m_logPath;
    }

    public void setLogPath(String string) {
        this.m_logPath = string;
    }

    public int getLoginTimeout() {
        return this.m_loginTimeout;
    }

    public void setLoginTimeout(int n) {
        LogUtilities.logInfo("Login timeout set to " + n, (ILogger)this.m_log);
        this.m_loginTimeout = n;
    }

    public void setSessionLabel(String string) {
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        LogUtilities.logInfo("Session label is " + string, (ILogger)this.m_log);
        this.m_sessionLabel = string;
    }

    public String getSessionLabel() {
        return this.m_sessionLabel;
    }

    public boolean getSSLEnabled() {
        return this.m_useSSL;
    }

    public int getTxnIsolation() {
        try {
            return this.getProperty(26).getInt();
        }
        catch (Exception exception) {
            return 2;
        }
    }

    public void setLogLevel(String string) {
        LogUtilities.logInfo("Log level set to " + string, (ILogger)this.m_log);
        this.m_log.setLogLevel(LogLevel.getLogLevel(string));
    }

    public String getLogLevel() {
        return this.m_log.getLogLevel().toString();
    }

    public void setLogPackage(String string) {
        LogUtilities.logInfo("Log package set to " + string, (ILogger)this.m_log);
        this.m_logPackage = string;
        this.m_log.setLogPackage(string);
    }

    public String getLogNamespace() {
        return this.m_logPackage;
    }

    public void setServerLocale(String string, boolean bl) throws ErrorException {
        if (bl) {
            this.m_simpleQueryExecutor.execute("set locale to '" + string + "'");
        }
        this.m_locale = string;
    }

    public String getServerLocale() {
        return this.m_locale;
    }

    public void setUseStrictCatalogFiltering(boolean bl) {
        LogUtilities.logInfo("Strict catalog filtering " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_useStrictCatalogFiltering = bl;
    }

    public boolean getUseStrictCatalogFiltering() {
        return this.m_useStrictCatalogFiltering;
    }

    public void setAddTzToTimestampParameters(boolean bl) {
        LogUtilities.logInfo("AddTzToTimestampParameters" + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_addTzToTimestampParameters = bl;
    }

    public boolean getAddTzToTimestampParameters() {
        return this.m_addTzToTimestampParameters;
    }

    public boolean getDirectBatchInsert() {
        return this.m_directBatchInsert;
    }

    public void setDirectBatchInsert(boolean bl) {
        LogUtilities.logInfo("Direct batch insert " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_directBatchInsert = bl;
    }

    public long getResultBufferSize() {
        return this.m_resultBufferSize;
    }

    public void setResultBufferSize(long l) throws GeneralException {
        if (l <= 0L) {
            l = Long.MAX_VALUE;
        }
        if (this.m_resultBufferSize != l) {
            LogUtilities.logInfo("ResultBufferSize set to " + l, (ILogger)this.m_log);
        }
        this.m_resultBufferSize = l;
    }

    public String getServer() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean useStandardConformingStrings() {
        return this.m_useStandardConformingStrings;
    }

    public void setUseStandardConformingStrings(boolean bl) {
        LogUtilities.logInfo("Standard conforming strings " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_useStandardConformingStrings = bl;
    }

    public String getCatalogName() {
        return this.m_useThreePartNaming ? "'" + this.m_dbname + "'" : "NULL";
    }

    public boolean getUseThreePartNaming() {
        return this.m_useThreePartNaming;
    }

    public void setUseThreePartNaming(boolean bl) {
        block4: {
            LogUtilities.logInfo("Three part naming " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
            this.m_useThreePartNaming = bl;
            try {
                if (bl) {
                    this.setProperty(9, new Variant(0, "Y"));
                    this.setProperty(22, new Variant(0, this.m_dbname));
                } else {
                    this.setProperty(9, new Variant(0, "N"));
                    this.setProperty(22, new Variant(0, null));
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)exception.getMessage());
            }
        }
    }

    public void setUseSSL(boolean bl) {
        LogUtilities.logInfo("SSL " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_useSSL = bl;
    }

    public boolean getReadOnly() {
        try {
            return this.getProperty(16).getLong() == 1L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getUser() {
        return this.m_user;
    }

    public void setSearchPath(String string, boolean bl) throws ErrorException {
        if ("".equals(string = string.trim())) {
            return;
        }
        String[] stringArray = string.split(",");
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2 * stringArray.length + 19);
        stringBuilder.append("set search_path to ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(this.quoteIdentifier(stringArray[i].trim()));
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(",");
        }
        this.m_searchPath = string;
        if (bl) {
            this.m_simpleQueryExecutor.execute(stringBuilder.toString());
        }
    }

    public String getSearchPath() throws ErrorException, IncorrectTypeException {
        VResultSet vResultSet = this.m_simpleQueryExecutor.execute("show search_path");
        vResultSet.moveToNextRow();
        DataWrapper dataWrapper = new DataWrapper();
        vResultSet.getData(1, 0L, -1L, dataWrapper);
        return dataWrapper.getVarChar();
    }

    public boolean useStringBatchInserts() {
        return this.m_stringBatchInsert;
    }

    public void setStringBatchInsert(boolean bl) {
        this.m_stringBatchInsert = bl;
    }

    public boolean isClosed() {
        return !this.m_isConnected;
    }

    static {
        boolean bl = true;
        try {
            Charset.forName("UTF-8");
            "test".getBytes("UTF-8");
        }
        catch (Exception exception) {
            bl = false;
        }
        VERTICA_CHARSET = bl ? "UTF-8" : null;
        m_metadataCache = new ConcurrentHashMap<MetadataParamsKey, VMetadataSource>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetadataParamsKey {
        public MetadataSourceID m_type;
        public Map<MetadataSourceColumnTag, String> m_restrictions;
        public String m_escapeChar;
        public String m_idQuoteChar;
        public boolean m_filterAsId;
        public boolean m_longStringsEnabled;

        public MetadataParamsKey(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl, boolean bl2) {
            this.m_type = metadataSourceID;
            this.m_restrictions = map;
            this.m_escapeChar = string;
            this.m_idQuoteChar = string2;
            this.m_filterAsId = bl;
            this.m_longStringsEnabled = bl2;
        }

        public int hashCode() {
            return this.m_type.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof MetadataParamsKey) {
                MetadataParamsKey metadataParamsKey = (MetadataParamsKey)object;
                if (this.m_type == metadataParamsKey.m_type && this.m_escapeChar == metadataParamsKey.m_escapeChar && this.m_idQuoteChar == metadataParamsKey.m_idQuoteChar && this.m_filterAsId == metadataParamsKey.m_filterAsId && this.m_longStringsEnabled == metadataParamsKey.m_longStringsEnabled && this.m_restrictions.size() == metadataParamsKey.m_restrictions.size()) {
                    for (Map.Entry<MetadataSourceColumnTag, String> entry : this.m_restrictions.entrySet()) {
                        if (metadataParamsKey.m_restrictions.containsKey((Object)entry.getKey())) {
                            String string = metadataParamsKey.m_restrictions.get((Object)entry.getKey());
                            String string2 = entry.getValue();
                            if (string2 == null) {
                                string2 = "";
                            }
                            if (string == null) {
                                string = "";
                            }
                            if (string.equals(string2)) continue;
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

