/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.ssl;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

class TdsTlsOutputStream
extends FilterOutputStream {
    private static int OFFSET = System.getProperty("java.version").startsWith("1.8.") ? 256 : 0;
    private final List bufferedRecords = new ArrayList();
    private int totalSize;

    TdsTlsOutputStream(OutputStream out) {
        super(out);
    }

    private void deferRecord(byte[] record, int off, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(record, off, tmp, 0, len);
        this.bufferedRecords.add(tmp);
        this.totalSize += len;
    }

    private void flushBufferedRecords() throws IOException {
        byte[] tmp = new byte[this.totalSize];
        int off = 0;
        for (int i = 0; i < this.bufferedRecords.size(); ++i) {
            byte[] x = (byte[])this.bufferedRecords.get(i);
            System.arraycopy(x, 0, tmp, off, x.length);
            off += x.length;
        }
        this.putTdsPacket(tmp, 0, off);
        this.bufferedRecords.clear();
        this.totalSize = 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 5 || off > OFFSET) {
            this.out.write(b, off, len);
            return;
        }
        int contentType = b[off + 0] & 0xFF;
        int length = (b[off + 3] & 0xFF) << 8 | b[off + 4] & 0xFF;
        if (contentType < 20 || contentType > 23 || length != len - 5) {
            this.putTdsPacket(b, off, len);
            return;
        }
        switch (contentType) {
            case 23: {
                this.out.write(b, off, len);
                break;
            }
            case 20: {
                this.deferRecord(b, off, len);
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                if (len >= 9) {
                    byte hsType = b[off + 5];
                    int hsLen = (b[off + 6] & 0xFF) << 16 | (b[off + 7] & 0xFF) << 8 | b[off + 8] & 0xFF;
                    if (hsLen == len - 9 && hsType == 1) {
                        this.putTdsPacket(b, off, len);
                        break;
                    }
                    this.deferRecord(b, off, len);
                    if (hsLen == len - 9 && hsType == 16) break;
                    this.flushBufferedRecords();
                    break;
                }
            }
            default: {
                this.out.write(b, off, len);
            }
        }
    }

    void putTdsPacket(byte[] b, int off, int len) throws IOException {
        byte[] tdsHdr = new byte[8];
        tdsHdr[0] = 18;
        tdsHdr[1] = 1;
        tdsHdr[2] = (byte)(len + 8 >> 8);
        tdsHdr[3] = (byte)(len + 8);
        this.out.write(tdsHdr, 0, tdsHdr.length);
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }
}

