/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.id;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

@Immutable
public final class Actor
implements Serializable,
Comparable<Actor>,
JSONAware {
    private final Subject subject;
    private final Issuer issuer;
    private final Actor parent;

    public Actor(Subject subject) {
        this(subject, null, null);
    }

    public Actor(Subject subject, Issuer issuer, Actor parent) {
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.subject = subject;
        this.issuer = issuer;
        this.parent = parent;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public Actor getParent() {
        return this.parent;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put("sub", this.subject.getValue());
        if (this.issuer != null) {
            o.put("iss", this.issuer.getValue());
        }
        if (this.parent != null) {
            o.put("act", this.parent.toJSONObject());
        }
        return o;
    }

    @Override
    public int compareTo(Actor other) {
        return this.toJSONString().compareTo(other.toJSONString());
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Actor)) {
            return false;
        }
        Actor actor = (Actor)o;
        if (!this.subject.equals(actor.subject)) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(actor.issuer) : actor.issuer != null) {
            return false;
        }
        return this.parent != null ? this.parent.equals(actor.parent) : actor.parent == null;
    }

    public int hashCode() {
        int result = this.subject.hashCode();
        result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    public static Actor parse(JSONObject jsonObject) throws ParseException {
        Subject sub = new Subject(JSONObjectUtils.getString(jsonObject, "sub"));
        Issuer iss = null;
        if (jsonObject.containsKey("iss")) {
            iss = new Issuer(JSONObjectUtils.getString(jsonObject, "iss"));
        }
        Actor parent = Actor.parseTopLevel(jsonObject);
        return new Actor(sub, iss, parent);
    }

    public static Actor parseTopLevel(JSONObject jsonObject) throws ParseException {
        if (!jsonObject.containsKey("act")) {
            return null;
        }
        return Actor.parse(JSONObjectUtils.getJSONObject(jsonObject, "act"));
    }
}

