/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class AuthorizationErrorResponse
extends AuthorizationResponse
implements ErrorResponse {
    private static final Set<ErrorObject> stdErrors = new HashSet<ErrorObject>();
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    public AuthorizationErrorResponse(URI redirectURI, ErrorObject error, State state, ResponseMode rm) {
        super(redirectURI, state, rm);
        if (error == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = error;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public ResponseMode impliedResponseMode() {
        return this.getResponseMode() != null ? this.getResponseMode() : ResponseMode.QUERY;
    }

    @Override
    public Map<String, String> toParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error", this.error.getCode());
        if (this.error.getDescription() != null) {
            params.put("error_description", this.error.getDescription());
        }
        if (this.error.getURI() != null) {
            params.put("error_uri", this.error.getURI().toString());
        }
        if (this.getState() != null) {
            params.put("state", this.getState().getValue());
        }
        return params;
    }

    public static AuthorizationErrorResponse parse(URI redirectURI, Map<String, String> params) throws ParseException {
        if (StringUtils.isBlank(params.get("error"))) {
            throw new ParseException("Missing error code");
        }
        String errorCode = params.get("error");
        String errorDescription = params.get("error_description");
        String errorURIString = params.get("error_uri");
        URI errorURI = null;
        if (errorURIString != null) {
            try {
                errorURI = new URI(errorURIString);
            }
            catch (URISyntaxException e) {
                throw new ParseException("Invalid error URI: " + errorURIString, e);
            }
        }
        ErrorObject error = new ErrorObject(errorCode, errorDescription, 302, errorURI);
        State state = State.parse(params.get("state"));
        return new AuthorizationErrorResponse(redirectURI, error, state, null);
    }

    public static AuthorizationErrorResponse parse(URI uri) throws ParseException {
        Map<String, String> params;
        if (uri.getRawFragment() != null) {
            params = URLUtils.parseParameters(uri.getRawFragment());
        } else if (uri.getRawQuery() != null) {
            params = URLUtils.parseParameters(uri.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthorizationErrorResponse.parse(URIUtils.getBaseURI(uri), params);
    }

    public static AuthorizationErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        URI location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirection URL / HTTP Location header");
        }
        return AuthorizationErrorResponse.parse(location);
    }

    public static AuthorizationErrorResponse parse(HTTPRequest httpRequest) throws ParseException {
        URI baseURI;
        try {
            baseURI = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        if (httpRequest.getQuery() != null) {
            return AuthorizationErrorResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getQuery()));
        }
        if (httpRequest.getFragment() != null) {
            return AuthorizationErrorResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }

    static {
        stdErrors.add(OAuth2Error.INVALID_REQUEST);
        stdErrors.add(OAuth2Error.UNAUTHORIZED_CLIENT);
        stdErrors.add(OAuth2Error.ACCESS_DENIED);
        stdErrors.add(OAuth2Error.UNSUPPORTED_RESPONSE_TYPE);
        stdErrors.add(OAuth2Error.INVALID_SCOPE);
        stdErrors.add(OAuth2Error.SERVER_ERROR);
        stdErrors.add(OAuth2Error.TEMPORARILY_UNAVAILABLE);
    }
}

