/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class AuthorizationCodeGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.AUTHORIZATION_CODE;
    private final AuthorizationCode code;
    private final URI redirectURI;
    private final CodeVerifier codeVerifier;

    public AuthorizationCodeGrant(AuthorizationCode code, URI redirectURI) {
        this(code, redirectURI, null);
    }

    public AuthorizationCodeGrant(AuthorizationCode code, URI redirectURI, CodeVerifier codeVerifier) {
        super(GRANT_TYPE);
        if (code == null) {
            throw new IllegalArgumentException("The authorisation code must not be null");
        }
        this.code = code;
        this.redirectURI = redirectURI;
        this.codeVerifier = codeVerifier;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public CodeVerifier getCodeVerifier() {
        return this.codeVerifier;
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        params.put("code", this.code.getValue());
        if (this.redirectURI != null) {
            params.put("redirect_uri", this.redirectURI.toString());
        }
        if (this.codeVerifier != null) {
            params.put("code_verifier", this.codeVerifier.getValue());
        }
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorizationCodeGrant)) {
            return false;
        }
        AuthorizationCodeGrant codeGrant = (AuthorizationCodeGrant)o;
        if (!this.code.equals(codeGrant.code)) {
            return false;
        }
        if (this.redirectURI != null ? !this.redirectURI.equals(codeGrant.redirectURI) : codeGrant.redirectURI != null) {
            return false;
        }
        return this.codeVerifier != null ? this.codeVerifier.equals(codeGrant.codeVerifier) : codeGrant.codeVerifier == null;
    }

    public int hashCode() {
        int result = this.code.hashCode();
        result = 31 * result + (this.redirectURI != null ? this.redirectURI.hashCode() : 0);
        result = 31 * result + (this.codeVerifier != null ? this.codeVerifier.hashCode() : 0);
        return result;
    }

    public static AuthorizationCodeGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            String msg = "Missing \"grant_type\" parameter";
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
        }
        if (!GrantType.parse(grantTypeString).equals(GRANT_TYPE)) {
            String msg = "The \"grant_type\" must be \"" + GRANT_TYPE + "\"";
            throw new ParseException(msg, OAuth2Error.UNSUPPORTED_GRANT_TYPE.appendDescription(": " + msg));
        }
        String codeString = params.get("code");
        if (codeString == null || codeString.trim().isEmpty()) {
            String msg = "Missing or empty \"code\" parameter";
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
        }
        AuthorizationCode code = new AuthorizationCode(codeString);
        String redirectURIString = params.get("redirect_uri");
        URI redirectURI = null;
        if (redirectURIString != null) {
            try {
                redirectURI = new URI(redirectURIString);
            }
            catch (URISyntaxException e) {
                String msg = "Invalid \"redirect_uri\" parameter: " + e.getMessage();
                throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg), e);
            }
        }
        String codeVerifierString = params.get("code_verifier");
        CodeVerifier codeVerifier = null;
        if (StringUtils.isNotBlank(codeVerifierString)) {
            try {
                codeVerifier = new CodeVerifier(codeVerifierString);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage(), e);
            }
        }
        return new AuthorizationCodeGrant(code, redirectURI, codeVerifier);
    }
}

