/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.ClientAssertion;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

final class JwtHelper {
    JwtHelper() {
    }

    static ClientAssertion buildJwt(AsymmetricKeyCredential credential, String jwtAudience) throws AuthenticationException {
        SignedJWT jwt;
        if (credential == null) {
            throw new IllegalArgumentException("credential is null");
        }
        long time = System.currentTimeMillis();
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().audience(Collections.singletonList(jwtAudience)).issuer(credential.getClientId()).notBeforeTime(new Date(time)).expirationTime(new Date(time + 600000L)).subject(credential.getClientId()).build();
        try {
            JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.RS256);
            ArrayList<Base64> certs = new ArrayList<Base64>();
            certs.add(new Base64(credential.getPublicCertificate()));
            builder.x509CertChain(certs);
            builder.x509CertThumbprint(new Base64URL(credential.getPublicCertificateHash()));
            jwt = new SignedJWT(builder.build(), claimsSet);
            RSASSASigner signer = new RSASSASigner(credential.getKey());
            jwt.sign(signer);
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
        return new ClientAssertion(jwt.serialize());
    }
}

