/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.DOMCDATASectionImpl;
import org.w3c.tidy.DOMCommentImpl;
import org.w3c.tidy.DOMDocumentImpl;
import org.w3c.tidy.DOMDocumentTypeImpl;
import org.w3c.tidy.DOMElementImpl;
import org.w3c.tidy.DOMNodeImpl;
import org.w3c.tidy.DOMProcessingInstructionImpl;
import org.w3c.tidy.DOMTextImpl;
import org.w3c.tidy.Dict;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class Node {
    public static final short RootNode = 0;
    public static final short DocTypeTag = 1;
    public static final short CommentTag = 2;
    public static final short ProcInsTag = 3;
    public static final short TextNode = 4;
    public static final short StartTag = 5;
    public static final short EndTag = 6;
    public static final short StartEndTag = 7;
    public static final short CDATATag = 8;
    public static final short SectionTag = 9;
    public static final short AspTag = 10;
    public static final short JsteTag = 11;
    public static final short PhpTag = 12;
    protected Node parent = null;
    protected Node prev = null;
    protected Node next = null;
    protected Node last = null;
    protected int start;
    protected int end;
    protected byte[] textarray;
    protected short type;
    protected boolean closed;
    protected boolean implicit;
    protected boolean linebreak;
    protected Dict was;
    protected Dict tag;
    protected String element;
    protected AttVal attributes;
    protected Node content;
    private static final String[] nodeTypeString = new String[]{"RootNode", "DocTypeTag", "CommentTag", "ProcInsTag", "TextNode", "StartTag", "EndTag", "StartEndTag", "SectionTag", "AspTag", "PhpTag"};
    protected org.w3c.dom.Node adapter = null;

    public Node() {
        this(4, null, 0, 0);
    }

    public Node(short s, byte[] byArray, int n, int n2) {
        this.start = n;
        this.end = n2;
        this.textarray = byArray;
        this.type = s;
        this.closed = false;
        this.implicit = false;
        this.linebreak = false;
        this.was = null;
        this.tag = null;
        this.element = null;
        this.attributes = null;
        this.content = null;
    }

    public Node(short s, byte[] byArray, int n, int n2, String string, TagTable tagTable) {
        this.start = n;
        this.end = n2;
        this.textarray = byArray;
        this.type = s;
        this.closed = false;
        this.implicit = false;
        this.linebreak = false;
        this.was = null;
        this.tag = null;
        this.element = string;
        this.attributes = null;
        this.content = null;
        if (s == 5 || s == 7 || s == 6) {
            tagTable.findTag(this);
        }
    }

    protected Object clone() {
        Node node = new Node();
        node.parent = this.parent;
        if (this.textarray != null) {
            node.textarray = new byte[this.end - this.start];
            node.start = 0;
            node.end = this.end - this.start;
            if (node.end > 0) {
                System.arraycopy(this.textarray, this.start, node.textarray, node.start, node.end);
            }
        }
        node.type = this.type;
        node.closed = this.closed;
        node.implicit = this.implicit;
        node.linebreak = this.linebreak;
        node.was = this.was;
        node.tag = this.tag;
        if (this.element != null) {
            node.element = this.element;
        }
        if (this.attributes != null) {
            node.attributes = (AttVal)this.attributes.clone();
        }
        return node;
    }

    public AttVal getAttrByName(String string) {
        AttVal attVal = this.attributes;
        while (!(attVal == null || string != null && attVal.attribute != null && attVal.attribute.equals(string))) {
            attVal = attVal.next;
        }
        return attVal;
    }

    public void checkAttributes(Lexer lexer) {
        AttVal attVal = this.attributes;
        while (attVal != null) {
            attVal.checkAttribute(lexer, this);
            attVal = attVal.next;
        }
    }

    public void checkUniqueAttributes(Lexer lexer) {
        AttVal attVal = this.attributes;
        while (attVal != null) {
            if (attVal.asp == null && attVal.php == null) {
                attVal.checkUniqueAttribute(lexer, this);
            }
            attVal = attVal.next;
        }
    }

    public void addAttribute(String string, String string2) {
        AttVal attVal = new AttVal(null, null, null, null, 34, string, string2);
        attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
        if (this.attributes == null) {
            this.attributes = attVal;
        } else {
            AttVal attVal2 = this.attributes;
            while (attVal2.next != null) {
                attVal2 = attVal2.next;
            }
            attVal2.next = attVal;
        }
    }

    public void removeAttribute(AttVal attVal) {
        AttVal attVal2 = null;
        AttVal attVal3 = this.attributes;
        while (attVal3 != null) {
            AttVal attVal4 = attVal3.next;
            if (attVal3 == attVal) {
                if (attVal2 != null) {
                    attVal2.next = attVal4;
                } else {
                    this.attributes = attVal4;
                }
            } else {
                attVal2 = attVal3;
            }
            attVal3 = attVal4;
        }
    }

    public Node findDocType() {
        Node node = this.content;
        while (node != null && node.type != 1) {
            node = node.next;
        }
        return node;
    }

    public void discardDocType() {
        Node node = this.findDocType();
        if (node != null) {
            if (node.prev != null) {
                node.prev.next = node.next;
            } else {
                node.parent.content = node.next;
            }
            if (node.next != null) {
                node.next.prev = node.prev;
            }
            node.next = null;
        }
    }

    public static Node discardElement(Node node) {
        Node node2 = null;
        if (node != null) {
            node2 = node.next;
            Node.removeNode(node);
        }
        return node2;
    }

    public static void insertNodeAtStart(Node node, Node node2) {
        node2.parent = node;
        if (node.content == null) {
            node.last = node2;
        } else {
            node.content.prev = node2;
        }
        node2.next = node.content;
        node2.prev = null;
        node.content = node2;
    }

    public static void insertNodeAtEnd(Node node, Node node2) {
        node2.parent = node;
        node2.prev = node.last;
        if (node.last != null) {
            node.last.next = node2;
        } else {
            node.content = node2;
        }
        node.last = node2;
    }

    public static void insertNodeAsParent(Node node, Node node2) {
        node2.content = node;
        node2.last = node;
        node2.parent = node.parent;
        node.parent = node2;
        if (node2.parent.content == node) {
            node2.parent.content = node2;
        }
        if (node2.parent.last == node) {
            node2.parent.last = node2;
        }
        node2.prev = node.prev;
        node.prev = null;
        if (node2.prev != null) {
            node2.prev.next = node2;
        }
        node2.next = node.next;
        node.next = null;
        if (node2.next != null) {
            node2.next.prev = node2;
        }
    }

    public static void insertNodeBeforeElement(Node node, Node node2) {
        Node node3;
        node2.parent = node3 = node.parent;
        node2.next = node;
        node2.prev = node.prev;
        node.prev = node2;
        if (node2.prev != null) {
            node2.prev.next = node2;
        }
        if (node3.content == node) {
            node3.content = node2;
        }
    }

    public static void insertNodeAfterElement(Node node, Node node2) {
        Node node3;
        node2.parent = node3 = node.parent;
        if (node3 != null && node3.last == node) {
            node3.last = node2;
        } else {
            node2.next = node.next;
            if (node2.next != null) {
                node2.next.prev = node2;
            }
        }
        node.next = node2;
        node2.prev = node;
    }

    public static void trimEmptyElement(Lexer lexer, Node node) {
        TagTable tagTable = lexer.configuration.tt;
        if (lexer.canPrune(node)) {
            if (node.type != 4) {
                Report.warning(lexer, node, null, (short)18);
            }
            Node.discardElement(node);
        } else if (node.tag == tagTable.tagP && node.content == null) {
            Node node2 = lexer.inferredTag("br");
            Node.coerceNode(lexer, node, tagTable.tagBr);
            Node.insertNodeAfterElement(node, node2);
        }
    }

    public static void trimTrailingSpace(Lexer lexer, Node node, Node node2) {
        byte by;
        TagTable tagTable = lexer.configuration.tt;
        if (node2 != null && node2.type == 4 && node2.end > node2.start && ((by = lexer.lexbuf[node2.end - 1]) == 160 || by == 32)) {
            if (node.tag == tagTable.tagTd || node.tag == tagTable.tagTh) {
                if (node2.end > node2.start + 1) {
                    --node2.end;
                }
            } else {
                --node2.end;
                if ((node.tag.model & 0x10) != 0 && (node.tag.model & 0x400) == 0) {
                    lexer.insertspace = true;
                }
                if (node2.start == node2.end) {
                    Node.trimEmptyElement(lexer, node2);
                }
            }
        }
    }

    public static void trimInitialSpace(Lexer lexer, Node node, Node node2) {
        if (node2.type == 4 && node2.textarray[node2.start] == 32 && node2.start < node2.end) {
            if ((node.tag.model & 0x10) != 0 && (node.tag.model & 0x400) == 0 && node.parent.content != node) {
                Node node3 = node.prev;
                if (node3 != null && node3.type == 4) {
                    if (node3.textarray[node3.end - 1] != 32) {
                        node3.textarray[node3.end++] = 32;
                    }
                    ++node.start;
                } else {
                    Node node4 = lexer.newNode();
                    if (node.start >= node.end) {
                        node4.start = 0;
                        node4.end = 1;
                        node4.textarray = new byte[1];
                    } else {
                        node4.start = node.start++;
                        node4.end = node.start;
                        node4.textarray = node.textarray;
                    }
                    node4.textarray[node4.start] = 32;
                    node4.prev = node3;
                    if (node3 != null) {
                        node3.next = node4;
                    }
                    node4.next = node;
                    node.prev = node4;
                    node4.parent = node.parent;
                }
            }
            ++node2.start;
        }
    }

    public static void trimSpaces(Lexer lexer, Node node) {
        Node node2 = node.content;
        TagTable tagTable = lexer.configuration.tt;
        if (node2 != null && node2.type == 4 && node.tag != tagTable.tagPre) {
            Node.trimInitialSpace(lexer, node, node2);
        }
        if ((node2 = node.last) != null && node2.type == 4) {
            Node.trimTrailingSpace(lexer, node, node2);
        }
    }

    public boolean isDescendantOf(Dict dict) {
        Node node = this.parent;
        while (node != null) {
            if (node.tag == dict) {
                return true;
            }
            node = node.parent;
        }
        return false;
    }

    public static void insertDocType(Lexer lexer, Node node, Node node2) {
        TagTable tagTable = lexer.configuration.tt;
        Report.warning(lexer, node, node2, (short)29);
        while (node.tag != tagTable.tagHtml) {
            node = node.parent;
        }
        Node.insertNodeBeforeElement(node, node2);
    }

    public Node findBody(TagTable tagTable) {
        Node node = this.content;
        while (node != null && node.tag != tagTable.tagHtml) {
            node = node.next;
        }
        if (node == null) {
            return null;
        }
        node = node.content;
        while (node != null && node.tag != tagTable.tagBody) {
            node = node.next;
        }
        return node;
    }

    public boolean isElement() {
        return this.type == 5 || this.type == 7;
    }

    public static void moveBeforeTable(Node node, Node node2, TagTable tagTable) {
        Node node3 = node.parent;
        while (node3 != null) {
            if (node3.tag == tagTable.tagTable) {
                if (node3.parent.content == node3) {
                    node3.parent.content = node2;
                }
                node2.prev = node3.prev;
                node2.next = node3;
                node3.prev = node2;
                node2.parent = node3.parent;
                if (node2.prev == null) break;
                node2.prev.next = node2;
                break;
            }
            node3 = node3.parent;
        }
    }

    public static void fixEmptyRow(Lexer lexer, Node node) {
        if (node.content == null) {
            Node node2 = lexer.inferredTag("td");
            Node.insertNodeAtEnd(node, node2);
            Report.warning(lexer, node, node2, (short)7);
        }
    }

    public static void coerceNode(Lexer lexer, Node node, Dict dict) {
        Node node2 = lexer.inferredTag(dict.name);
        Report.warning(lexer, node, node2, (short)15);
        node.was = node.tag;
        node.tag = dict;
        node.type = (short)5;
        node.implicit = true;
        node.element = dict.name;
    }

    public static void removeNode(Node node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        }
        if (node.parent != null) {
            if (node.parent.content == node) {
                node.parent.content = node.next;
            }
            if (node.parent.last == node) {
                node.parent.last = node.prev;
            }
        }
        node.next = null;
        node.prev = null;
        node.parent = null;
    }

    public static boolean insertMisc(Node node, Node node2) {
        if (node2.type == 2 || node2.type == 3 || node2.type == 8 || node2.type == 9 || node2.type == 10 || node2.type == 11 || node2.type == 12) {
            Node.insertNodeAtEnd(node, node2);
            return true;
        }
        return false;
    }

    public static boolean isNewNode(Node node) {
        if (node != null && node.tag != null) {
            return (node.tag.model & 0x100000) != 0;
        }
        return true;
    }

    public boolean hasOneChild() {
        return this.content != null && this.content.next == null;
    }

    public Node findHTML(TagTable tagTable) {
        Node node = this.content;
        while (node != null && node.tag != tagTable.tagHtml) {
            node = node.next;
        }
        return node;
    }

    public Node findHEAD(TagTable tagTable) {
        Node node = this.findHTML(tagTable);
        if (node != null) {
            node = node.content;
            while (node != null && node.tag != tagTable.tagHead) {
                node = node.next;
            }
        }
        return node;
    }

    public boolean checkNodeIntegrity() {
        Node node;
        boolean bl = false;
        if (this.prev != null && this.prev.next != this) {
            return false;
        }
        if (this.next != null && this.next.prev != this) {
            return false;
        }
        if (this.parent != null) {
            if (this.prev == null && this.parent.content != this) {
                return false;
            }
            if (this.next == null && this.parent.last != this) {
                return false;
            }
            node = this.parent.content;
            while (node != null) {
                if (node == this) {
                    bl = true;
                    break;
                }
                node = node.next;
            }
            if (!bl) {
                return false;
            }
        }
        node = this.content;
        while (node != null) {
            if (!node.checkNodeIntegrity()) {
                return false;
            }
            node = node.next;
        }
        return true;
    }

    public static void addClass(Node node, String string) {
        AttVal attVal = node.getAttrByName("class");
        if (attVal != null) {
            attVal.value = attVal.value + " " + string;
        } else {
            node.addAttribute("class", string);
        }
    }

    public String toString() {
        String string = "";
        Node node = this;
        while (node != null) {
            string = string + "[Node type=";
            string = string + nodeTypeString[node.type];
            string = string + ",element=";
            string = node.element != null ? string + node.element : string + "null";
            if (node.type == 4 || node.type == 2 || node.type == 3) {
                string = string + ",text=";
                if (node.textarray != null && node.start <= node.end) {
                    string = string + "\"";
                    string = string + Lexer.getString(node.textarray, node.start, node.end - node.start);
                    string = string + "\"";
                } else {
                    string = string + "null";
                }
            }
            string = string + ",content=";
            string = node.content != null ? string + node.content.toString() : string + "null";
            string = string + "]";
            if (node.next != null) {
                string = string + ",";
            }
            node = node.next;
        }
        return string;
    }

    protected org.w3c.dom.Node getAdapter() {
        if (this.adapter == null) {
            switch (this.type) {
                case 0: {
                    this.adapter = new DOMDocumentImpl(this);
                    break;
                }
                case 5: 
                case 7: {
                    this.adapter = new DOMElementImpl(this);
                    break;
                }
                case 1: {
                    this.adapter = new DOMDocumentTypeImpl(this);
                    break;
                }
                case 2: {
                    this.adapter = new DOMCommentImpl(this);
                    break;
                }
                case 4: {
                    this.adapter = new DOMTextImpl(this);
                    break;
                }
                case 8: {
                    this.adapter = new DOMCDATASectionImpl(this);
                    break;
                }
                case 3: {
                    this.adapter = new DOMProcessingInstructionImpl(this);
                    break;
                }
                default: {
                    this.adapter = new DOMNodeImpl(this);
                }
            }
        }
        return this.adapter;
    }

    protected Node cloneNode(boolean bl) {
        Node node = (Node)this.clone();
        if (bl) {
            Node node2 = this.content;
            while (node2 != null) {
                Node node3 = node2.cloneNode(bl);
                Node.insertNodeAtEnd(node, node3);
                node2 = node2.next;
            }
        }
        return node;
    }

    protected void setType(short s) {
        this.type = s;
    }
}

