/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Vector;
import oracle.net.TNSAddress.AddressList;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavAddressList
extends AddressList
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int sBuflength;

    public NavAddressList(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        super(schemaObjectFactoryInterface);
    }

    public void navigate(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        this.navigate2(connStrategy, stringBuffer, 0);
    }

    private void navigate2(ConnStrategy connStrategy, StringBuffer stringBuffer, int n) {
        int n2;
        boolean bl = false;
        ++n;
        this.sBuflength = stringBuffer.length();
        stringBuffer.append("(ADDRESS_LIST=");
        if (this.sourceRoute) {
            this.activeChildren = this.children;
            ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(connStrategy, stringBuffer);
            for (n2 = 1; n2 < this.activeChildren.size(); ++n2) {
                ((NavSchemaObject)this.activeChildren.elementAt(n2)).addToString(connStrategy);
            }
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (n2 = 0; n2 < this.activeChildren.size(); ++n2) {
                if (this.getChildrenType(n2) == 1) {
                    bl = true;
                    ((NavAddressList)this.activeChildren.elementAt(n2)).navigate2(connStrategy, stringBuffer, n);
                    continue;
                }
                ((NavSchemaObject)this.activeChildren.elementAt(n2)).navigate(connStrategy, stringBuffer);
            }
        }
        if (!(--n == 0 && bl || this.sourceRoute)) {
            this.closeNVPair(connStrategy, false);
        } else {
            this.closeNVPair(connStrategy, true);
        }
        stringBuffer.setLength(this.sBuflength);
    }

    public void addToString(ConnStrategy connStrategy) {
        String string = this.toString();
        for (int i = connStrategy.cOpts.size() - 1; i >= 0 && !((ConnOption)connStrategy.cOpts.elementAt((int)i)).done; --i) {
            ((ConnOption)connStrategy.cOpts.elementAt((int)i)).conn_data.append(string);
        }
    }

    public String toString() {
        String string = new String("");
        string = string + "(ADDRESS_LIST=";
        for (int i = 0; i < this.children.size(); ++i) {
            string = string + ((NavSchemaObject)this.children.elementAt(i)).toString();
        }
        if (this.sourceRoute) {
            string = string + "(SOURCE_ROUTE=yes)(HOP_COUNT=0)";
        }
        if (this.loadBalance) {
            string = string + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            string = string + "(FAILOVER=false)";
        }
        string = string + ")";
        return string;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public int getChildrenType(int n) {
        return ((NavSchemaObject)this.children.elementAt(n)).isA();
    }

    public NavAddress getChild(int n) {
        return (NavAddress)this.children.elementAt(n);
    }

    private void closeNVPair(ConnStrategy connStrategy, boolean bl) {
        for (int i = connStrategy.cOpts.size() - 1; i >= 0 && !((ConnOption)connStrategy.cOpts.elementAt((int)i)).done && (bl || connStrategy.cOpts.size() - 1 - i < this.getChildrenSize()); --i) {
            if (this.sourceRoute) {
                ((ConnOption)connStrategy.cOpts.elementAt((int)i)).conn_data.append("(SOURCE_ROUTE=yes)");
                ((ConnOption)connStrategy.cOpts.elementAt((int)i)).conn_data.append("(HOP_COUNT=0)");
            }
            ((ConnOption)connStrategy.cOpts.elementAt((int)i)).conn_data.append(")");
        }
    }
}

