/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

public class OracleBufferedStream
extends InputStream {
    byte[] buf;
    int pos = 0;
    int count = 0;
    boolean closed = false;
    int chunkSize;
    OracleStatement statement;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:39:36_PST_2008";

    public OracleBufferedStream(int n) {
        this.chunkSize = n;
        this.buf = new byte[n];
    }

    public OracleBufferedStream(OracleStatement oracleStatement, int n) {
        this(n);
        this.statement = oracleStatement;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public boolean needBytes() throws IOException {
        throw new IOException("You should not call this method");
    }

    public int flushBytes(int n) {
        int n2 = n > this.count - this.pos ? this.count - this.pos : n;
        this.pos += n2;
        return n2;
    }

    public int writeBytes(byte[] byArray, int n, int n2) {
        int n3 = n2 > this.count - this.pos ? this.count - this.pos : n2;
        System.arraycopy(this.buf, this.pos, byArray, n, n3);
        this.pos += n3;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.readInternal();
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.readInternal();
            }
        }
    }

    private final int readInternal() throws IOException {
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (this.needBytes()) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.readInternal(byArray, n, n2);
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.readInternal(byArray, n, n2);
            }
        }
    }

    private final int readInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        if (this.closed || this.isNull()) {
            return -1;
        }
        int n4 = n2 > byArray.length ? n3 + byArray.length : n3 + n2;
        if (!this.needBytes()) {
            return -1;
        }
        n3 += this.writeBytes(byArray, n3, n4 - n3);
        while (n3 < n4 && this.needBytes()) {
            n3 += this.writeBytes(byArray, n3, n4 - n3);
        }
        return n3 - n;
    }

    public int available() throws IOException {
        if (this.closed || this.isNull()) {
            return 0;
        }
        return this.count - this.pos;
    }

    public boolean isNull() throws IOException {
        return false;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(int n) throws IOException {
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.skipInternal(n);
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.skipInternal(n);
            }
        }
    }

    private final int skipInternal(int n) throws IOException {
        int n2;
        int n3 = n;
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (!this.needBytes()) {
            return -1;
        }
        for (n2 = 0; n2 < n3 && this.needBytes(); n2 += this.flushBytes(n3 - n2)) {
        }
        return n2;
    }
}

