/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.timedio.InStreamMgr;
import com.sybase.jdbc4.utils.BufferInterval;
import java.sql.SQLException;

public class BufferPool {
    public static final int BUFF_SIZE = 4096;
    private BufferInterval _head;
    private int _bufSize;
    private int _packetSize;
    private InStreamMgr _inMgr;
    private boolean _noLimit;
    protected static final boolean DEBUG = false;
    private volatile long _inMemoryBICount = 0L;

    public BufferPool(InStreamMgr inStreamMgr, SybProperty sybProperty) throws SQLException {
        this._inMgr = inStreamMgr;
        this._noLimit = sybProperty.getInteger(13) <= 0;
        this._packetSize = sybProperty.getInteger(12);
        this._bufSize = sybProperty.getBufferSize();
        this._head = this.makeBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetBufSize(int n) {
        if (this._packetSize == n) {
            return;
        }
        this._packetSize = n;
        if (this._bufSize < 2 * n && !this._noLimit) {
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                while (this._head != null) {
                    BufferInterval bufferInterval = this._head;
                    if (bufferInterval._length != this._bufSize) break;
                    BufferInterval bufferInterval2 = this._head._next;
                    this._head.detach();
                    this._head = bufferInterval2;
                }
                this._bufSize = 2 * n;
                this.put(this.makeBuffer());
            }
        }
        if (this._bufSize < 2 * n) {
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                this._bufSize = 2 * n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(BufferInterval bufferInterval) {
        if (this._noLimit) {
            return true;
        }
        boolean bl = false;
        block3: while (true) {
            if (bl) {
                this.checkMgr();
                return false;
            }
            bl = true;
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                if (bufferInterval == null) {
                    return false;
                }
                if (this._head == null) {
                    this._head = bufferInterval;
                    continue;
                }
                boolean bl2 = false;
                BufferInterval bufferInterval2 = this._head;
                while (bufferInterval2 != null) {
                    if (bufferInterval2.merge(bufferInterval, bl2)) {
                        if (bl2) {
                            bufferInterval2.detach();
                            break;
                        }
                        bufferInterval = bufferInterval2;
                        bl2 = true;
                    }
                    bufferInterval2 = bufferInterval2._next;
                }
                if (bl2) {
                    if (bufferInterval._prev == null || bufferInterval._prev._length >= bufferInterval._length) {
                        continue;
                    }
                    bufferInterval.detach();
                }
                bufferInterval2 = null;
                BufferInterval bufferInterval3 = this._head;
                while (bufferInterval3 != null) {
                    if (bufferInterval._length >= bufferInterval3._length) {
                        if (bufferInterval3 == this._head) {
                            this._head = bufferInterval;
                        }
                        bufferInterval.attachBefore(bufferInterval3);
                        continue block3;
                    }
                    bufferInterval2 = bufferInterval3;
                    bufferInterval3 = bufferInterval3._next;
                }
                bufferInterval.attachAfter(bufferInterval2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMgr() {
        InStreamMgr inStreamMgr = this._inMgr;
        synchronized (inStreamMgr) {
            if (this._head != null && this._head._length >= this._packetSize) {
                this._inMgr.notify();
            }
        }
    }

    public synchronized BufferInterval getBI(boolean bl) {
        if (this._head == null || this._head._length < this._packetSize) {
            if (bl || this._noLimit) {
                return this.makeBuffer();
            }
            return null;
        }
        BufferInterval bufferInterval = this._head;
        BufferInterval bufferInterval2 = this._head._next;
        this._head.detach();
        this._head = bufferInterval2;
        return bufferInterval;
    }

    private BufferInterval makeBuffer() {
        byte[] byArray = new byte[this._bufSize];
        BufferInterval bufferInterval = new BufferInterval(byArray, 0, byArray.length, this);
        this.incrementInMemoryBICount();
        return bufferInterval;
    }

    public synchronized void incrementInMemoryBICount() {
        ++this._inMemoryBICount;
    }

    public synchronized void decrementInMemoryBICount() {
        if (this._inMemoryBICount > 0L) {
            --this._inMemoryBICount;
        }
    }

    public long getInMemoryBICount() {
        return this._inMemoryBICount;
    }

    public synchronized void resetInMemoryBICount() {
        this._inMemoryBICount = 0L;
    }
}

