/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.SrvDataFormat;
import com.sybase.jdbc4.tds.SrvDataToken;
import com.sybase.jdbc4.tds.SrvFormatToken;
import com.sybase.jdbc4.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc4.tds.SrvTypeFormatter;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.tds.Token;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;

public class SrvReturnValueToken
extends Token
implements SrvDataToken,
SrvFormatToken,
Dumpable {
    private int _totalLength;
    private TdsInputStream _in;
    private SrvDataFormat _currentFormat;

    public SrvReturnValueToken(TdsInputStream tdsInputStream) throws IOException {
        this._totalLength = tdsInputStream.readShort();
        this._currentFormat = new ReturnFormat(tdsInputStream);
        this._in = tdsInputStream;
    }

    @Override
    public TdsInputStream getStream() {
        return this._in;
    }

    @Override
    public void setFormatter(SrvTypeFormatter srvTypeFormatter) {
    }

    @Override
    public void addFormat(DataFormat dataFormat) {
    }

    public int getLength() {
        return 0;
    }

    @Override
    public int getFormatCount() {
        return 1;
    }

    @Override
    public DataFormat formatAt(int n) {
        return this._currentFormat;
    }

    @Override
    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(172)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "RETURN_VALUE Token (0x" + HexConverts.hexConvert(172, 1) + ");");
            } else {
                dumpInfo.addInfo("Token", 1, "RETURN_VALUE Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLength);
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(6)) {
                dumpInfo.addInfo(this._currentFormat.dump(dumpFilter));
            }
        }
        SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter(this, null, false);
        Object[] objectArray = srvJavaTypeFormatter.convertData(this);
        if (dumpFilter.includesToken(172) && (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(6))) {
            int[] nArray = srvJavaTypeFormatter.getDataLengths();
            int[] nArray2 = srvJavaTypeFormatter.getLengthSizes();
            if (dumpInfo != null) {
                dumpInfo.addInfo("TDSFmt", 0, "Returned Data ");
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Length", nArray2[0], nArray[0]);
                }
                dumpInfo.addValue("Data", nArray[0], objectArray[0]);
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 172;
    }

    private class ReturnFormat
    extends SrvDataFormat
    implements Dumpable {
        protected ReturnFormat(TdsInputStream tdsInputStream) throws IOException {
            try {
                this._nameLen = tdsInputStream.readUnsignedByte();
                this._name = tdsInputStream.readString(this._nameLen);
                if (this._name == null) {
                    this._name = "";
                }
                this._status = tdsInputStream.readUnsignedByte();
                this._usertype = tdsInputStream.readInt();
                this._datatype = tdsInputStream.readUnsignedByte();
                int n = ReturnFormat.lengthSize(this._datatype);
                if (this._datatype == 106 || this._datatype == 108) {
                    this._length = tdsInputStream.readUnsignedByte();
                    this._precision = tdsInputStream.readUnsignedByte();
                    this._scale = tdsInputStream.readUnsignedByte();
                } else if (n == 0) {
                    switch (this._datatype) {
                        case 48: 
                        case 50: {
                            this._length = 1;
                            break;
                        }
                        case 52: 
                        case 65: {
                            this._length = 2;
                            break;
                        }
                        case 56: 
                        case 58: 
                        case 59: 
                        case 66: 
                        case 122: {
                            this._length = 4;
                            break;
                        }
                        case 60: 
                        case 61: 
                        case 62: 
                        case 67: 
                        case 187: 
                        case 188: 
                        case 191: {
                            this._length = 8;
                            break;
                        }
                    }
                } else if (n == 1) {
                    this._length = tdsInputStream.readUnsignedByte();
                } else if (n == 4) {
                    this._length = tdsInputStream.readInt();
                }
            }
            catch (IOException iOException) {
                ReturnFormat.readSQE(iOException);
            }
        }

        @Override
        public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
            DumpInfo dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(7)) {
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Name Length", 1, this._name.length());
                }
                dumpInfo.addText("Name", this._name.length(), this._name);
                String[] stringArray = new String[]{"PARAM_UNUSED", "<unrecognized>", "<unrecognized>", "<unrecognized>", "PARAM_RETURN"};
                dumpInfo.addBitfield("Status", 1, this._status, stringArray);
                dumpInfo.addHex("User Type", 4, this._usertype);
                dumpInfo.addInfo("Data Type", 1, ReturnFormat.getDataTypeString(this._datatype));
                if (dumpFilter.includesDetail(1) && ReturnFormat.lengthSize(this._datatype) > 0) {
                    dumpInfo.addInt("Maximum Length", ReturnFormat.lengthSize(this._datatype), this._length);
                }
                if (this._datatype == 106 || this._datatype == 108) {
                    dumpInfo.addHex("Precision", 1, this._precision);
                    dumpInfo.addHex("Scale", 1, this._scale);
                }
            }
            return dumpInfo;
        }

        public int getType() {
            return -1;
        }
    }
}

