/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.SrvPdu;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.utils.Debug;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import sun.io.CharToByteConverter;

public class SrvDataOutputStream
extends TdsOutputStream {
    private SrvPdu _pdu = new SrvPdu();
    private boolean _bufstatEvent = false;
    CharToByteConverter _ctbc = null;
    protected int _last = 7;
    private byte[] _buf;

    public SrvDataOutputStream(OutputStream outputStream) throws Exception {
        super(outputStream);
        this._buf = new byte[this._pdu._packetSize];
        this._ctbc = CharToByteConverter.getConverter((String)this._pdu._charset);
    }

    public void setEncoding(String string) throws Exception {
        this._pdu._charset = string;
        this._ctbc = CharToByteConverter.getConverter((String)this._pdu._charset);
    }

    public void setPacketSize(int n) {
        Debug.asrt(this._last == 7, "Buffer in use, cannot reset packetsize");
        this._pdu._packetSize = n;
        this._buf = new byte[this._pdu._packetSize];
    }

    public void setAttention() {
        this._pdu._msgStatus |= 2;
    }

    public void setNotify() {
        this._bufstatEvent = true;
    }

    @Override
    public void write(int n) throws IOException {
        if (this._last == this._buf.length - 1) {
            this.flush(false);
        }
        this._buf[++this._last] = (byte)n;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n2 > 0) {
            int n4;
            if (this._last >= this._buf.length - 1) {
                this.flush(false);
            }
            int n5 = (n4 = this._buf.length - this._last - 1) < n2 - n ? n4 : n2 - n;
            System.arraycopy(byArray, n3, this._buf, this._last + 1, n5);
            this._last += n5;
            n2 -= n5;
            n3 += n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean bl) throws IOException {
        if (this._bufstatEvent) {
            this._pdu._msgStatus |= 8;
            this._pdu.setpdu(this._buf, bl, this._last + 1, 16);
        } else {
            this._pdu.setpdu(this._buf, bl, this._last + 1, 15);
        }
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(this._buf, 0, this._pdu._length);
            this.out.flush();
        }
        this._pdu.setpdu();
        this._last = 7;
    }

    @Override
    public String getCharset() {
        return this._pdu._charset;
    }

    public int getPacketSize() {
        return this._pdu._packetSize;
    }

    @Override
    protected byte[] toBytes(String string) throws CharConversionException {
        if (string == null) {
            return null;
        }
        return this._ctbc.convertAll(string.toCharArray());
    }
}

