/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.CurInfoToken;
import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.SrvCurDeclareToken;
import com.sybase.jdbc4.tds.SrvCursor;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import java.io.IOException;

public class SrvCurInfoToken
extends CurInfoToken
implements Dumpable {
    int _curlen = 0;
    int _curId = 0;
    int _nameLen = 0;
    String _cursorName = null;
    int _command = 0;
    int _status = 0;
    int _fetchSize = 0;
    protected SrvCursor _cursor = null;

    public SrvCurInfoToken(TdsInputStream tdsInputStream) throws IOException {
        int n = this._curlen = (int)tdsInputStream.readShort();
        this._curId = tdsInputStream.readInt();
        n -= 4;
        if (this._curId == 0) {
            this._nameLen = tdsInputStream.readUnsignedByte();
            --n;
            this._cursorName = tdsInputStream.readString(this._nameLen);
            n -= this._nameLen;
        }
        this._command = tdsInputStream.readUnsignedByte();
        --n;
        this._status = this.readStatus(tdsInputStream);
        this.readMetaInfo(tdsInputStream, n -= this.getStatusLength());
    }

    public SrvCurInfoToken() {
    }

    protected void setCursor(SrvCursor srvCursor) {
        this._cursor = srvCursor;
    }

    protected void setCommand(int n) {
        this._command = n;
    }

    public int curId() {
        return this._curId;
    }

    public String name() {
        return this._cursorName;
    }

    public int rowcnt() {
        return this._fetchSize;
    }

    protected int readStatus(TdsInputStream tdsInputStream) throws IOException {
        return tdsInputStream.readShort();
    }

    protected void readMetaInfo(TdsInputStream tdsInputStream, int n) throws IOException {
        if (n == 4) {
            this._fetchSize = tdsInputStream.readInt();
        }
    }

    @Override
    protected int getStatusLength() {
        return 2;
    }

    protected int getMetaLength() {
        if ((this._cursor.getCurInfoStatus() & 0x20) != 0) {
            return 4;
        }
        return 0;
    }

    @Override
    protected String getTokenName() {
        return "CURINFO";
    }

    @Override
    protected void send(TdsOutputStream tdsOutputStream) throws IOException {
        int n = 5 + this.getStatusLength() + this.getMetaLength();
        tdsOutputStream.writeByte(this.getTokenType());
        tdsOutputStream.writeShort(n);
        tdsOutputStream.writeInt(this._cursor.getID());
        tdsOutputStream.writeByte(this._command);
        this.sendStatus(tdsOutputStream);
        this.sendMetaInfo(tdsOutputStream);
    }

    protected void sendStatus(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeShort(this._cursor.getCurInfoStatus());
    }

    protected void sendMetaInfo(TdsOutputStream tdsOutputStream) throws IOException {
        if ((this._cursor.getCurInfoStatus() & 0x20) != 0) {
            tdsOutputStream.writeInt(this._cursor.getFetchSize());
        }
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        Object[] objectArray = new Object[]{this.getTokenName(), new Integer(this.getTokenType()), new Integer(2), new Integer(this._curlen), new Integer(this._curId), new Integer(this._nameLen), this._cursorName, null, null, null, null};
        DumpInfo dumpInfo = SrvCurDeclareToken.preDump(dumpFilter, objectArray);
        if (dumpFilter.includesToken(131) && (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(9))) {
            this.addCommandField(dumpInfo);
            this.addStatusField(dumpInfo);
            this.addMetaFields(dumpInfo);
        }
        return dumpInfo;
    }

    protected void addCommandField(DumpInfo dumpInfo) {
        String[] stringArray = new String[]{"<unrecognized>", "CUR_SETCURROWS", "CUR_INQUIRE", "CUR_INFORM", "CUR_LISTALL"};
        dumpInfo.addField("Command", 1, this._command, stringArray);
    }

    protected void addStatusField(DumpInfo dumpInfo) {
        String[] stringArray = new String[]{"UNUSED", "CUR_IS_DECLARED", "CUR_IS_OPEN", "CUR_IS_CLOSED", "CUR_IS_RDONLY", "CUR_IS_UPDATABLE", "CUR_IS_ROWCNT", "CUR_IS_DALLOC"};
        dumpInfo.addBitfield("Status", 2, this._status, stringArray);
    }

    protected void addMetaFields(DumpInfo dumpInfo) {
        if (this._fetchSize != 0) {
            dumpInfo.addInt("Fetch Size", 4, this._fetchSize);
        }
    }

    @Override
    public int getTokenType() {
        return 131;
    }
}

