/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.SybBCP;
import com.sybase.jdbc4.tds.TdsDataOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Calendar;

public class BCPRawInterface {
    private int _lockScheme;
    Calendar _userCal = Calendar.getInstance();
    private SybBCP _sybBCP = null;
    private TdsDataOutputStream _tdsOut = null;
    private int _columnCount = -1;
    private final int BOUNDARY = 256;
    private final int APL = 0;
    private int _textimageCount = 0;
    private boolean _hasValue = false;
    private int _iprev = 0;
    private boolean _lastTextColNull = false;
    private int[] _adjustmentTable;
    private int[] _offsetTable;
    private int _adjustptr = 0;
    private int _offsetptr = 0;
    private int[] _offsetTextImage;
    private int _textptr = 0;
    private Object[] _paramDataObject;
    private int[] _paramDataSqlTypes;
    private byte[] _byteValue = null;
    private int _dataLength = 0;
    private int _fixedColumnLengthTotal;
    private int _numberOfVariableColumns;
    private byte[] _fixedDataBuffer;
    private byte[] _variableDataBuffer;
    private int _fixedDataPos;
    private int _variableDataPos;
    protected byte[] _numbuf = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected static final int LOW_BYTE = 255;
    protected static final long D_LOW_BYTE = 255L;
    protected static final int STARTFIXEDDATAPOS = 4;
    protected static final int STARTVARIABLEDATAPOS = 2;
    protected static final int STARTFIXEDDATAPOS_DOL = 8;
    private int[] _tableMDAInfo;
    private int _columnId;
    private int _datatype;
    private int _isColumnNull;
    private boolean _fixedType = false;
    private int _varColLengthTotal = 0;
    private int _totalBytesWritten = 0;
    private int _valColCounter = 0;
    protected static final int COLUMN_DATATYPE = 1;
    protected static final int COLUMN_USERTYPE = 2;
    protected static final int COLUMN_LENGTH = 3;
    protected static final int COLUMN_ISNULL = 6;
    private int[] _colValueArray = null;
    private int _lastVarColumn = 0;
    private int _typeCount = 0;
    private byte[] _bitValueArray;
    private int _bitColumnCount = 0;
    private boolean _bitWritten = false;
    private int[] _bitColumnNumber;

    public BCPRawInterface(SybBCP sybBCP, TdsDataOutputStream tdsDataOutputStream) throws SQLException, IOException {
        this.reinitialize(sybBCP, tdsDataOutputStream);
        this._lockScheme = this._sybBCP.getTableLockScheme();
        if (this._lockScheme == 0) {
            this.APL();
        } else {
            this.DOL();
        }
    }

    private void DOL() throws SQLException, IOException {
        this._columnCount = this._sybBCP.getColumnCount();
        this._fixedColumnLengthTotal = this._sybBCP.getFixedColumnLengthTotal();
        this.resetValues_DOL();
        this.calcuateBitColumnCount();
        int n = this._fixedColumnLengthTotal + 8;
        if (this._numberOfVariableColumns > 0) {
            int n2 = this._sybBCP.getMaxRowLength() - this._fixedColumnLengthTotal;
            this._variableDataBuffer = new byte[n2 + this._numberOfVariableColumns * 2 + 1];
            n += 2;
            this._totalBytesWritten = this._fixedColumnLengthTotal + 8;
        }
        this._fixedDataBuffer = new byte[n];
        this._lastVarColumn = this._sybBCP._lastVarColumn;
    }

    private void APL() throws SQLException, IOException {
        this.resetValues();
        this._columnCount = this._sybBCP.getColumnCount();
        this._fixedColumnLengthTotal = this._sybBCP.getFixedColumnLengthTotal();
        this._numberOfVariableColumns = this._sybBCP.getNumberVarColumns();
        this.calcuateBitColumnCount();
        int n = this._fixedColumnLengthTotal + 4;
        int n2 = this._sybBCP.getMaxRowLength();
        if (this._numberOfVariableColumns > 0) {
            int n3 = n2 - this._fixedColumnLengthTotal;
            this._variableDataBuffer = new byte[n3 + this._numberOfVariableColumns + 2 + n3 / 256 + 1];
            this.initializeAPL(this._numberOfVariableColumns, n2 / 256 + 1);
            n += 2;
            this._totalBytesWritten = this._fixedColumnLengthTotal + 4;
        }
        this._fixedDataBuffer = new byte[n];
    }

    public void reinitialize(SybBCP sybBCP, TdsDataOutputStream tdsDataOutputStream) {
        this._sybBCP = sybBCP;
        this._tdsOut = tdsDataOutputStream;
        this._tableMDAInfo = this._sybBCP.getIntMDA();
    }

    private void resetValues() {
        this._fixedDataPos = 4;
        this._variableDataPos = 0;
        this._varColLengthTotal = 0;
        this._valColCounter = 0;
        this._totalBytesWritten = this._fixedColumnLengthTotal + 4;
        this._adjustptr = 0;
        this._offsetptr = this._numberOfVariableColumns + 1;
        this._textptr = 0;
        this._textimageCount = 0;
        this._iprev = 0;
        this._adjustmentTable = new int[this._sybBCP.getMaxRowLength() / 256 + 1];
        this._offsetTable = new int[this._numberOfVariableColumns + 1];
        this._bitWritten = false;
    }

    private void resetValues_DOL() {
        this._fixedDataPos = 8;
        this._variableDataPos = 0;
        this._varColLengthTotal = 0;
        this._valColCounter = 0;
        this._totalBytesWritten = this._fixedColumnLengthTotal + 8;
        this._numberOfVariableColumns = this._sybBCP.getNumberVarColumns();
        if (this._numberOfVariableColumns > 0) {
            this._offsetptr = this._numberOfVariableColumns;
        }
        this.initializeDOL(this._offsetptr);
        this._textptr = 0;
        this._typeCount = 0;
        this._colValueArray = null;
        this._textimageCount = 0;
        this._bitWritten = false;
    }

    public void writeBulkData(Object[] objectArray, int[] nArray, int[] nArray2, Calendar[] calendarArray) throws SQLException, IOException {
        this._paramDataObject = objectArray;
        this._paramDataSqlTypes = nArray;
        this.calculateBitValue();
        if (this._lockScheme == 0) {
            this.writeAPL();
            this.resetValues();
        } else {
            this.writeDOL();
            this.resetValues_DOL();
        }
    }

    private void getColumnMetaDataAll(int n) {
        this._datatype = this._tableMDAInfo[1 + (n *= 15)];
        this._isColumnNull = this._tableMDAInfo[6 + n];
    }

    private void setParamData(int n) {
        this.getColumnMetaDataAll(n);
        if (this._paramDataSqlTypes[n] == -999) {
            this._byteValue = (byte[])this._sybBCP.getObjectDefaults(n);
        } else if (!(this._paramDataObject[n] instanceof InputStream)) {
            this._byteValue = (byte[])this._paramDataObject[n];
        }
        this._dataLength = this._byteValue == null ? 0 : this._byteValue.length;
    }

    private void checkTextImage() {
        this._fixedType = false;
        if (this._byteValue == null) {
            return;
        }
        if (this._datatype == 35 || this._datatype == 34 || this._datatype == 174) {
            this._dataLength = 16;
            this._byteValue = new byte[this._dataLength];
            ++this._textimageCount;
        }
    }

    private void writeDOL() throws SQLException, IOException {
        int n;
        boolean bl = true;
        this._hasValue = true;
        for (n = 0; n < this._columnCount; ++n) {
            this.setParamData(n);
            this._fixedType = true;
            if (this._isColumnNull == 1 || this.getNullableDatatype()) {
                this.checkTextImage();
                if (bl && this._lastVarColumn > 0) {
                    if (this._colValueArray == null) {
                        this._colValueArray = this.checkLastColumn(0);
                    }
                    bl = false;
                }
                this._varColLengthTotal += this.getVarColLengthTotalDOL();
            }
            this.write(this._byteValue, 0, this._dataLength);
        }
        if (this._numberOfVariableColumns > 0) {
            this.recalculateVarColumns();
            this.recalculateTable();
            this._sybBCP.setNumberVarColumns(this._numberOfVariableColumns);
            this._numberOfVariableColumns = this._sybBCP.getNumberVarColumns();
        }
        n = 6 + (this._numberOfVariableColumns == 0 ? 0 : 2) + this._fixedColumnLengthTotal + this._varColLengthTotal + this._numberOfVariableColumns * 2;
        if (this._numberOfVariableColumns > 0) {
            this._fixedType = false;
            this.writeDOLOffSetTable();
            this._fixedType = true;
            this.writeShort(n);
        }
        this.writeDOLPageFormat(n);
        if (this._textimageCount > 0) {
            this.writeTextAndImage();
        }
        this._sybBCP.resetNumberVarColumns();
    }

    private void recalculateVarColumns() {
        int n = 0;
        if (this._numberOfVariableColumns <= 1) {
            if (!this._hasValue) {
                this._numberOfVariableColumns = 0;
            }
            return;
        }
        switch (this._lastVarColumn) {
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 174: 
            case 187: 
            case 188: {
                int n2 = this._colValueArray.length;
                for (int i = n2 - 1; i >= 0 && this._colValueArray[i] <= 0; --i) {
                    ++n;
                }
                break;
            }
        }
        this._numberOfVariableColumns -= n;
    }

    private int[] checkLastColumn(int n) {
        if (this._numberOfVariableColumns <= 1) {
            return this._colValueArray;
        }
        if (this._lastVarColumn > 0) {
            n = this._lastVarColumn;
        } else {
            this._lastVarColumn = n;
        }
        switch (n) {
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 174: 
            case 187: 
            case 188: {
                this._colValueArray = new int[this._numberOfVariableColumns];
            }
        }
        return this._colValueArray;
    }

    private int getVarColLengthTotalDOL() throws SQLException, IOException {
        int n = 0;
        if (this._byteValue != null) {
            if (this._colValueArray == null) {
                this._colValueArray = this.checkLastColumn(this._datatype);
            }
            this.setColumnValueArray();
        } else {
            this.incrementTypeCount();
        }
        this._totalBytesWritten += this.fillOffSetTable();
        n = this._dataLength;
        return n;
    }

    private int fillOffSetTable() throws SQLException, IOException {
        int n = 0;
        n = this._dataLength == 0 ? this._totalBytesWritten | 0x2000 : this._totalBytesWritten;
        if (this._columnId != this._columnCount || !this._lastTextColNull) {
            this.addoffset(n, this._dataLength, false);
        }
        return this._dataLength;
    }

    private void setColumnValueArray() {
        if (this._numberOfVariableColumns <= 1) {
            return;
        }
        switch (this._lastVarColumn) {
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 174: 
            case 187: 
            case 188: {
                this._colValueArray[this._typeCount++] = 1;
            }
        }
    }

    private void incrementTypeCount() {
        if (this._numberOfVariableColumns <= 1) {
            return;
        }
        switch (this._lastVarColumn) {
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 174: 
            case 187: 
            case 188: {
                ++this._typeCount;
            }
        }
    }

    private void writeAPL() throws SQLException, IOException {
        int n;
        for (n = 0; n < this._columnCount; ++n) {
            this.setParamData(n);
            this._fixedType = true;
            if (this._isColumnNull == 1 || this.getNullableDatatype()) {
                this.checkTextImage();
                ++this._valColCounter;
                this._totalBytesWritten += this.calculateAdjustLengthAPL(false);
                this._varColLengthTotal += this._dataLength;
            }
            this.write(this._byteValue, 0, this._dataLength);
        }
        n = 2 + this._fixedColumnLengthTotal + (this._numberOfVariableColumns == 0 ? 0 : 2 + this._varColLengthTotal + this._numberOfVariableColumns + 2);
        if (this._numberOfVariableColumns > 0) {
            ++this._valColCounter;
            this.calculateAdjustLengthAPL(true);
            this._fixedType = false;
            this.writeOffSetTable();
            this._fixedType = true;
            this.writeShort(n += this.getAdjustTableLength());
        }
        this.writeAPLPageFormat(n);
        if (this._textimageCount > 0) {
            this.writeTextAndImage();
        }
    }

    private boolean getNullableDatatype() {
        switch (this._datatype) {
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 174: 
            case 225: {
                return true;
            }
        }
        return false;
    }

    private void writeTextAndImage() throws SQLException, IOException {
        int n = 0;
        for (int i = 0; i < this._columnCount && n != this._textimageCount; ++i) {
            this.setParamData(i);
            if (this._byteValue == null) continue;
            switch (this._datatype) {
                case 34: 
                case 35: 
                case 174: {
                    if (this._dataLength == 0) {
                        this._byteValue = new byte[1];
                        this._byteValue[0] = 32;
                    }
                    this._tdsOut.writeShort(0);
                    this._tdsOut.writeByte(this._datatype);
                    this._tdsOut.writeByte(256 - (i + 1));
                    int n2 = this._offsetTextImage[n++];
                    this._tdsOut.writeShort(n2);
                    this._tdsOut.writeInt(this._dataLength);
                    this._tdsOut.write(this._byteValue);
                }
            }
        }
    }

    private int calculateAdjustLengthAPL(boolean bl) throws SQLException, IOException {
        int n = 0;
        int n2 = 0;
        if (!bl) {
            n = this._totalBytesWritten / 256;
            if (n > 0) {
                if (this._dataLength > 0) {
                    n2 = this._totalBytesWritten;
                }
                this.addoffset(this._totalBytesWritten % 256, n2, true);
                n2 = 0;
                if (n != this._iprev) {
                    int n3 = n - this._iprev;
                    this._iprev = n;
                    do {
                        this.addVariableColumnCounter();
                    } while (--n3 > 0);
                }
            } else {
                if (this._dataLength > 0) {
                    n2 = this._totalBytesWritten;
                }
                this.addoffset(this._totalBytesWritten, n2, false);
                n2 = 0;
            }
        } else {
            n = this._totalBytesWritten / 256;
            if (n > 0) {
                this.addoffset(this._totalBytesWritten % 256);
                if (n != this._iprev) {
                    int n4 = n - this._iprev;
                    this._iprev = n;
                    do {
                        this.addVariableColumnCounter();
                    } while (--n4 > 0);
                }
            } else {
                this.addoffset(this._totalBytesWritten);
            }
            this._iprev = 0;
        }
        return this._dataLength;
    }

    public void writeAPLPageFormat(int n) throws SQLException, IOException {
        int n2 = this._fixedDataPos;
        this._fixedDataPos = 0;
        this.writeShort(n);
        this.writeByte(this._numberOfVariableColumns);
        this.writeByte(0);
        this._tdsOut.write(this._fixedDataBuffer, 0, n2);
        if (this._numberOfVariableColumns > 0) {
            this._tdsOut.write(this._variableDataBuffer, 0, this._variableDataPos);
        }
    }

    public void writeDOLPageFormat(int n) throws SQLException, IOException {
        this._fixedType = true;
        int n2 = this._fixedDataPos;
        this._fixedDataPos = 0;
        this.writeShort(n);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this._numberOfVariableColumns);
        this._tdsOut.write(this._fixedDataBuffer, 0, n2);
        if (this._numberOfVariableColumns > 0) {
            this._tdsOut.write(this._variableDataBuffer, 0, this._variableDataPos);
        }
    }

    private void initializeAPL(int n, int n2) {
        this._offsetptr = n + 1;
        this._offsetTable = new int[this._offsetptr];
        this._adjustmentTable = new int[n2];
        if (this._sybBCP.getTextImageCount() > 0) {
            this._offsetTextImage = new int[this._sybBCP.getTextImageCount()];
        }
    }

    private void initializeDOL(int n) {
        this._offsetTable = new int[n];
        if (this._sybBCP.getTextImageCount() > 0) {
            this._offsetTextImage = new int[this._sybBCP.getTextImageCount()];
        }
    }

    private void addoffset(int n) {
        this._offsetTable[--this._offsetptr] = n;
    }

    private void addoffset(int n, int n2, boolean bl) {
        if ((this._datatype == 35 || this._datatype == 34 || this._datatype == 174) && n2 > 0) {
            this._offsetTextImage[this._textptr] = bl ? n2 : n;
            ++this._textptr;
        }
        if (this._offsetTable.length == 0) {
            return;
        }
        this.addoffset(n);
    }

    private void addVariableColumnCounter() {
        this._adjustmentTable[this._adjustptr] = this._valColCounter;
        ++this._adjustptr;
    }

    private void writeOffSetTable() throws IOException {
        int n = this._offsetTable.length;
        if (n > 0) {
            this.writeByte((byte)n);
            if (this._adjustmentTable.length > 0) {
                this.writeAdjustTable();
            }
            for (int i = 0; i < n; ++i) {
                this.writeByte(this._offsetTable[i]);
            }
        }
    }

    private void writeDOLOffSetTable() throws IOException {
        int n = this._offsetTable.length;
        for (int i = 0; i < n; ++i) {
            this.writeShort(this._offsetTable[i]);
        }
    }

    private void writeAdjustTable() throws IOException {
        int n = this.getAdjustTableLength();
        for (int i = n - 1; i >= 0; --i) {
            this.writeByte((byte)this._adjustmentTable[i]);
        }
    }

    private void recalculateTable() throws IOException {
        int n = this._sybBCP.getNumberVarColumns();
        if (n == this._numberOfVariableColumns || this._numberOfVariableColumns == 0) {
            return;
        }
        int[] nArray = new int[this._numberOfVariableColumns];
        System.arraycopy(this._offsetTable, n - this._numberOfVariableColumns, nArray, 0, this._numberOfVariableColumns);
        this._offsetTable = nArray;
    }

    private int getAdjustTableLength() throws IOException {
        int n = 0;
        if (this._adjustmentTable[0] == 0) {
            return n;
        }
        int n2 = this._adjustmentTable.length;
        for (int i = 0; i < n2 && this._adjustmentTable[i] != 0; ++i) {
            ++n;
        }
        return n;
    }

    private final void writeShort(int n) throws IOException {
        this.writeByte((byte)(n >>> 8 & 0xFF));
        this.writeByte((byte)(n >>> 0 & 0xFF));
    }

    private final void writeByte(byte by) throws IOException {
        if (this._fixedType) {
            this._fixedDataBuffer[this._fixedDataPos++] = by;
        } else {
            this._variableDataBuffer[this._variableDataPos++] = by;
        }
    }

    private final void writeByte(int n) throws IOException {
        this.writeByte((byte)n);
    }

    private final void write(byte[] byArray, int n, int n2) {
        if (this._fixedType) {
            if (this._datatype == 50) {
                if (this._bitValueArray != null && !this._bitWritten) {
                    System.arraycopy(this._bitValueArray, 0, this._fixedDataBuffer, this._fixedDataPos, this._bitValueArray.length);
                    this._fixedDataPos += this._bitValueArray.length;
                    this._bitWritten = true;
                }
            } else {
                System.arraycopy(byArray, 0, this._fixedDataBuffer, this._fixedDataPos, n2);
                this._fixedDataPos += n2;
            }
        } else if (n2 > 0) {
            System.arraycopy(byArray, 0, this._variableDataBuffer, this._variableDataPos, n2);
            this._variableDataPos += n2;
        }
    }

    protected byte[] toBytes(String string) throws CharConversionException {
        if (string == null) {
            return null;
        }
        return this._tdsOut._tds._charsetConverter.fromUnicode(string);
    }

    private void calcuateBitColumnCount() {
        int n;
        int[] nArray = new int[1024];
        for (n = 0; n < this._columnCount; ++n) {
            this.getColumnMetaDataAll(n);
            if (this._datatype != 50) continue;
            nArray[this._bitColumnCount++] = n;
        }
        n = (int)Math.ceil((double)this._bitColumnCount / 8.0);
        this._bitValueArray = new byte[n];
        this._bitColumnNumber = new int[this._bitColumnCount];
        System.arraycopy(nArray, 0, this._bitColumnNumber, 0, this._bitColumnCount);
        this._fixedColumnLengthTotal = this._fixedColumnLengthTotal - this._bitColumnCount + n;
    }

    private void calculateBitValue() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this._bitColumnNumber.length; ++i) {
            this.setParamData(this._bitColumnNumber[i]);
            ++n;
            if (this._byteValue[0] == 1) {
                n2 = 1 << (n - 1) % 8 | n2;
            }
            if (n % 8 != 0 && n != this._bitColumnCount) continue;
            this._bitValueArray[n3++] = (byte)n2;
            n2 = 0;
        }
    }
}

