/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.asn1;

import com.sybase.jdbc4.security.asn1.ASN1Object;
import com.sybase.jdbc4.security.asn1.ASN1OctetString;
import com.sybase.jdbc4.security.asn1.ASN1TaggedObject;
import com.sybase.jdbc4.security.asn1.DERObject;
import com.sybase.jdbc4.security.asn1.DEROutputStream;
import com.sybase.jdbc4.security.asn1.DERString;
import java.io.IOException;

public class DERGeneralString
extends ASN1Object
implements DERString {
    private String string;

    public static DERGeneralString getInstance(Object object) {
        if (object == null || object instanceof DERGeneralString) {
            return (DERGeneralString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERGeneralString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERGeneralString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGeneralString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERGeneralString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERGeneralString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERGeneralString(String string) {
        this.string = string;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    @Override
    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(27, this.getOctets());
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERGeneralString)) {
            return false;
        }
        DERGeneralString dERGeneralString = (DERGeneralString)dERObject;
        return this.getString().equals(dERGeneralString.getString());
    }
}

