/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobLocatorBufferedInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorBufferedReader;
import com.sybase.jdbc4.jdbc.LobLocatorInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorOutputStream;
import com.sybase.jdbc4.jdbc.LobLocatorReader;
import com.sybase.jdbc4.jdbc.LobLocatorWriter;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybCharLob
extends SybLob
implements NClob {
    private static Logger LOG = Logger.getLogger(SybCharLob.class.getName());
    private static volatile long _logIdCounter = 0L;

    public SybCharLob(String string, ProtocolContext protocolContext, byte[] byArray, SybLob.LOB_TYPE lOB_TYPE) throws SQLException {
        super(string, protocolContext, byArray);
        this._lobType = lOB_TYPE;
        this.setLiteralSQL();
        this._lengthBuiltin = "char_length";
        this._logId = string + "_Cl" + _logIdCounter++;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getAsciiStream()");
        }
        return new LobLocatorBufferedInputStream(new LobLocatorInputStream(this), 16384);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getCharacterStream()");
        }
        return new LobLocatorBufferedReader(new LobLocatorReader(this), 16384);
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getCharacterStream(long = [" + l + "], long = [" + l2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getCharacterStream(long, long)");
            }
        }
        long l3 = this.length();
        if (l < 1L || l > l3 || l + l2 > l3 + 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        return new LobLocatorBufferedReader(new LobLocatorReader(this, l, l2), 16384);
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSubString(long = [" + l + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSubString(long, int)");
            }
        }
        this.checkLocatorValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        } else if (n < 0) {
            ErrorMessage.raiseError("JZ038");
        }
        MdaManager mdaManager = this._context._conn.getMDA(this._context);
        PreparedStatement preparedStatement = mdaManager.getMetaDataAccessor("LOB_GETBYTES", this._context);
        preparedStatement.setInt(1, this._lobType.ordinal());
        preparedStatement.setBytes(2, this.getLocator());
        preparedStatement.setLong(3, l);
        preparedStatement.setInt(4, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            String string = resultSet.getString(1);
            int n2 = resultSet.getInt(2);
            if (string != null) {
                return string;
            }
            if (n2 != 0 && l <= (long)n2) {
                return "";
            }
        }
        return null;
    }

    @Override
    public long position(String string, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " position(String = [" + string + "], long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " position(String, long)");
            }
        }
        this.checkLocatorValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        long l2 = -1L;
        if (string != null) {
            CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("SEARCH_LOB", this._context);
            callableStatement.setInt(1, this._lobType.ordinal());
            callableStatement.setBytes(2, null);
            callableStatement.setBytes(3, this.getLocator());
            callableStatement.setLong(4, l);
            callableStatement.registerOutParameter(5, -5);
            callableStatement.setInt(6, 1);
            callableStatement.setString(7, string);
            callableStatement.execute();
            l2 = callableStatement.getLong(5);
            if (l2 < l) {
                l2 = -1L;
            }
        }
        return l2;
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " position", new Object[]{clob, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " position", new Object[]{clob, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " position(Clob, long)");
            }
        }
        return super.searchLocator((SybLob)((Object)clob), l);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setString(long = [" + l + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setString(long, String)");
            }
        }
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        if (string != null) {
            this.checkLocatorValidity();
            return this.setData(l, string);
        }
        return 0;
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setString(long = [" + l + "], String = [" + string + "], int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setString(long, String, int, int)");
            }
        }
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        if (string != null) {
            return this.setString(l, string.substring(n - 1, n - 1 + n2));
        }
        return 0;
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setAsciiStream(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAsciiStream(long)");
            }
        }
        if (l < 1L || l > this.length()) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedOutputStream(new LobLocatorOutputStream(this, l), 16384);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setCharacterStyream(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCharacterStream(long)");
            }
        }
        if (l < 1L || l > this.length()) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedWriter(new LobLocatorWriter(this, l), 16384);
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }
}

