/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmContext;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComLogoffAndX;
import jcifs.smb.SmbComSessionSetupAndX;
import jcifs.smb.SmbComSessionSetupAndXResponse;
import jcifs.smb.SmbComTreeConnectAndX;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2FindFirst2;
import jcifs.smb.Trans2FindFirst2Response;
import jcifs.util.LogStream;

public final class SmbSession {
    private static final String LOGON_SHARE = Config.getProperty("jcifs.smb.client.logonShare", null);
    private static final int LOOKUP_RESP_LIMIT = Config.getInt("jcifs.netbios.lookupRespLimit", 3);
    private static final String DOMAIN = Config.getProperty("jcifs.smb.client.domain", null);
    private static final String USERNAME = Config.getProperty("jcifs.smb.client.username", null);
    private static final int CACHE_POLICY = Config.getInt("jcifs.netbios.cachePolicy", 600) * 60;
    static NbtAddress[] dc_list = null;
    static long dc_list_expiration;
    static int dc_list_counter;
    private int uid;
    Vector trees;
    private boolean sessionSetup;
    private UniAddress address;
    private int port;
    private int localPort;
    private InetAddress localAddr;
    SmbTransport transport = null;
    NtlmPasswordAuthentication auth;
    long expiration;

    private static NtlmChallenge interrogate(NbtAddress addr) throws SmbException {
        UniAddress dc = new UniAddress(addr);
        SmbTransport trans = SmbTransport.getSmbTransport(dc, 0);
        if (USERNAME == null) {
            trans.connect();
            if (LogStream.level >= 3) {
                SmbTransport.log.println("Default credentials (jcifs.smb.client.username/password) not specified. SMB signing may not work propertly.  Skipping DC interrogation.");
            }
        } else {
            SmbSession ssn = trans.getSmbSession(NtlmPasswordAuthentication.DEFAULT);
            ssn.getSmbTree(LOGON_SHARE, null).treeConnect(null, null);
        }
        return new NtlmChallenge(trans.server.encryptionKey, dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NtlmChallenge getChallengeForDomain() throws SmbException, UnknownHostException {
        if (DOMAIN == null) {
            throw new SmbException("A domain was not specified");
        }
        String string = DOMAIN;
        synchronized (string) {
            long now = System.currentTimeMillis();
            int retry = 1;
            do {
                if (dc_list_expiration < now) {
                    NbtAddress[] list = NbtAddress.getAllByName(DOMAIN, 28, null, null);
                    dc_list_expiration = now + (long)CACHE_POLICY * 1000L;
                    if (list != null && list.length > 0) {
                        dc_list = list;
                    } else {
                        dc_list_expiration = now + 900000L;
                        if (LogStream.level >= 2) {
                            SmbTransport.log.println("Failed to retrieve DC list from WINS");
                        }
                    }
                }
                int max = Math.min(dc_list.length, LOOKUP_RESP_LIMIT);
                for (int j = 0; j < max; ++j) {
                    int i;
                    if (dc_list[i = dc_list_counter++ % max] == null) continue;
                    try {
                        return SmbSession.interrogate(dc_list[i]);
                    }
                    catch (SmbException se) {
                        if (LogStream.level >= 2) {
                            SmbTransport.log.println("Failed validate DC: " + dc_list[i]);
                            if (LogStream.level > 2) {
                                se.printStackTrace(SmbTransport.log);
                            }
                        }
                        SmbSession.dc_list[i] = null;
                    }
                }
                dc_list_expiration = 0L;
            } while (retry-- > 0);
            dc_list_expiration = now + 900000L;
        }
        throw new UnknownHostException("Failed to negotiate with a suitable domain controller for " + DOMAIN);
    }

    public static byte[] getChallenge(UniAddress dc) throws SmbException, UnknownHostException {
        return SmbSession.getChallenge(dc, 0);
    }

    public static byte[] getChallenge(UniAddress dc, int port) throws SmbException, UnknownHostException {
        SmbTransport trans = SmbTransport.getSmbTransport(dc, port);
        trans.connect();
        return trans.server.encryptionKey;
    }

    public static void logon(UniAddress dc, NtlmPasswordAuthentication auth) throws SmbException {
        SmbSession.logon(dc, 0, auth);
    }

    public static void logon(UniAddress dc, int port, NtlmPasswordAuthentication auth) throws SmbException {
        SmbTree tree = SmbTransport.getSmbTransport(dc, port).getSmbSession(auth).getSmbTree(LOGON_SHARE, null);
        if (LOGON_SHARE == null) {
            tree.treeConnect(null, null);
        } else {
            Trans2FindFirst2 req = new Trans2FindFirst2("\\", "*", 16);
            Trans2FindFirst2Response resp = new Trans2FindFirst2Response();
            tree.send(req, resp);
        }
    }

    SmbSession(UniAddress address, int port, InetAddress localAddr, int localPort, NtlmPasswordAuthentication auth) {
        this.address = address;
        this.port = port;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.auth = auth;
        this.trees = new Vector();
    }

    synchronized SmbTree getSmbTree(String share, String service) {
        SmbTree t;
        if (share == null) {
            share = "IPC$";
        }
        Enumeration e = this.trees.elements();
        while (e.hasMoreElements()) {
            t = (SmbTree)e.nextElement();
            if (!t.matches(share, service)) continue;
            return t;
        }
        t = new SmbTree(this, share, service);
        this.trees.addElement(t);
        return t;
    }

    boolean matches(NtlmPasswordAuthentication auth) {
        return this.auth == auth || this.auth.equals(auth);
    }

    synchronized SmbTransport transport() {
        if (this.transport == null) {
            this.transport = SmbTransport.getSmbTransport(this.address, this.port, this.localAddr, this.localPort, null);
        }
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        if (response != null) {
            response.received = false;
        }
        Object object = this.transport.setupDiscoLock;
        synchronized (object) {
            this.expiration = System.currentTimeMillis() + (long)SmbConstants.SO_TIMEOUT;
            this.sessionSetup(request, response);
            if (response != null && response.received) {
                return;
            }
            request.uid = this.uid;
            request.auth = this.auth;
            try {
                this.transport.send(request, response);
            }
            catch (SmbException se) {
                if (request instanceof SmbComTreeConnectAndX) {
                    this.logoff(true);
                }
                request.digest = null;
                throw se;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionSetup(ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbException {
        NtlmContext nctx = null;
        SmbException ex = null;
        byte[] token = new byte[]{};
        int state = 10;
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            if (this.sessionSetup) {
                return;
            }
            this.transport.connect();
            if (LogStream.level >= 4) {
                SmbTransport.log.println("sessionSetup: accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain);
            }
            this.uid = 0;
            block19: do {
                switch (state) {
                    case 10: {
                        if (this.auth != NtlmPasswordAuthentication.ANONYMOUS && this.transport.hasCapability(Integer.MIN_VALUE)) {
                            state = 20;
                            break;
                        }
                        SmbComSessionSetupAndX request = new SmbComSessionSetupAndX(this, andx, this.auth);
                        SmbComSessionSetupAndXResponse response = new SmbComSessionSetupAndXResponse(andxResponse);
                        if (this.transport.isSignatureSetupRequired(this.auth)) {
                            if (this.auth.hashesExternal && NtlmPasswordAuthentication.DEFAULT_PASSWORD != "") {
                                this.transport.getSmbSession(NtlmPasswordAuthentication.DEFAULT).getSmbTree(LOGON_SHARE, null).treeConnect(null, null);
                            } else {
                                byte[] signingKey = this.auth.getSigningKey(this.transport.server.encryptionKey);
                                request.digest = new SigningDigest(signingKey, false);
                            }
                        }
                        request.auth = this.auth;
                        try {
                            this.transport.send(request, response);
                        }
                        catch (SmbAuthException sae) {
                            throw sae;
                        }
                        catch (SmbException se) {
                            ex = se;
                        }
                        if (response.isLoggedInAsGuest && !"GUEST".equalsIgnoreCase(this.auth.username) && this.transport.server.security != 0) {
                            throw new SmbAuthException(-1073741715);
                        }
                        if (ex != null) {
                            throw ex;
                        }
                        this.uid = response.uid;
                        if (request.digest != null) {
                            this.transport.digest = request.digest;
                        }
                        this.sessionSetup = true;
                        state = 0;
                        break;
                    }
                    case 20: {
                        byte[] signingKey;
                        if (nctx == null) {
                            boolean doSigning = (this.transport.flags2 & 4) != 0;
                            nctx = new NtlmContext(this.auth, doSigning);
                        }
                        if (nctx.isEstablished()) {
                            this.sessionSetup = true;
                            state = 0;
                            break;
                        }
                        try {
                            token = nctx.initSecContext(token, 0, token.length);
                        }
                        catch (SmbException se) {
                            try {
                                this.transport.disconnect(true);
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                            this.uid = 0;
                            throw se;
                        }
                        if (token == null) continue block19;
                        SmbComSessionSetupAndX request = new SmbComSessionSetupAndX(this, null, token);
                        SmbComSessionSetupAndXResponse response = new SmbComSessionSetupAndXResponse(null);
                        if (this.transport.isSignatureSetupRequired(this.auth) && (signingKey = nctx.getSigningKey()) != null) {
                            request.digest = new SigningDigest(signingKey, true);
                        }
                        request.uid = this.uid;
                        this.uid = 0;
                        try {
                            this.transport.send(request, response);
                        }
                        catch (SmbAuthException sae) {
                            throw sae;
                        }
                        catch (SmbException se) {
                            ex = se;
                            try {
                                this.transport.disconnect(true);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (response.isLoggedInAsGuest && !"GUEST".equalsIgnoreCase(this.auth.username)) {
                            throw new SmbAuthException(-1073741715);
                        }
                        if (ex != null) {
                            throw ex;
                        }
                        this.uid = response.uid;
                        if (request.digest != null) {
                            this.transport.digest = request.digest;
                        }
                        token = response.blob;
                        break;
                    }
                    default: {
                        throw new SmbException("Unexpected session setup state: " + state);
                    }
                }
            } while (state != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logoff(boolean inError) {
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            if (!this.sessionSetup) {
                return;
            }
            Enumeration e = this.trees.elements();
            while (e.hasMoreElements()) {
                SmbTree t = (SmbTree)e.nextElement();
                t.treeDisconnect(inError);
            }
            if (!inError && this.transport.server.security != 0) {
                SmbComLogoffAndX request = new SmbComLogoffAndX(null);
                request.uid = this.uid;
                try {
                    this.transport.send(request, null);
                }
                catch (SmbException se) {
                    // empty catch block
                }
                this.uid = 0;
            }
            this.sessionSetup = false;
        }
    }

    public String toString() {
        return "SmbSession[accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain + ",uid=" + this.uid + ",sessionSetup=" + this.sessionSetup + "]";
    }
}

