/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emfplus;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emfplus.HemfPlusDraw;
import org.apache.poi.hemf.record.emfplus.HemfPlusHeader;
import org.apache.poi.hemf.record.emfplus.HemfPlusObject;
import org.apache.poi.hemf.record.emfplus.HemfPlusPath;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndianInputStream;

public class HemfPlusRegion {
    private static long readNode(LittleEndianInputStream leis, Consumer<EmfPlusRegionNodeData> con) throws IOException {
        EmfPlusRegionNodeDataType type = EmfPlusRegionNodeDataType.valueOf(leis.readInt());
        assert (type != null);
        EmfPlusRegionNodeData nd = type.constructor.get();
        con.accept(nd);
        return 4L + nd.init(leis);
    }

    public static class EmfPlusRegionNode
    implements EmfPlusRegionNodeData {
        private EmfPlusRegionNodeData left;
        private EmfPlusRegionNodeData right;

        @Override
        public long init(LittleEndianInputStream leis) throws IOException {
            long size = HemfPlusRegion.readNode(leis, n -> {
                this.left = n;
            });
            return size += HemfPlusRegion.readNode(leis, n -> {
                this.right = n;
            });
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties("left", () -> this.left, "right", () -> this.right);
        }
    }

    public static class EmfPlusRegionRect
    implements EmfPlusRegionNodeData {
        private final Rectangle2D rect = new Rectangle2D.Double();

        @Override
        public long init(LittleEndianInputStream leis) {
            return HemfPlusDraw.readRectF(leis, this.rect);
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties("rect", () -> this.rect);
        }
    }

    public static class EmfPlusRegionEmpty
    implements EmfPlusRegionNodeData {
        @Override
        public long init(LittleEndianInputStream leis) throws IOException {
            return 0L;
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            return null;
        }
    }

    public static class EmfPlusRegionInfinite
    implements EmfPlusRegionNodeData {
        @Override
        public long init(LittleEndianInputStream leis) throws IOException {
            return 0L;
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            return null;
        }
    }

    public static class EmfPlusRegionPath
    extends HemfPlusPath.EmfPlusPath
    implements EmfPlusRegionNodeData {
        @Override
        public long init(LittleEndianInputStream leis) throws IOException {
            int dataSize = leis.readInt();
            return super.init(leis, dataSize, HemfPlusObject.EmfPlusObjectType.PATH, 0) + 4L;
        }
    }

    public static interface EmfPlusRegionNodeData
    extends GenericRecord {
        public long init(LittleEndianInputStream var1) throws IOException;
    }

    public static class EmfPlusRegion
    implements HemfPlusObject.EmfPlusObjectData {
        private final HemfPlusHeader.EmfPlusGraphicsVersion graphicsVersion = new HemfPlusHeader.EmfPlusGraphicsVersion();
        private EmfPlusRegionNodeData regionNode;

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, HemfPlusObject.EmfPlusObjectType objectType, int flags) throws IOException {
            long size = this.graphicsVersion.init(leis);
            int nodeCount = leis.readInt();
            size += 4L;
            return size += HemfPlusRegion.readNode(leis, d -> {
                this.regionNode = d;
            });
        }

        @Override
        public void applyObject(HemfGraphics ctx, List<? extends HemfPlusObject.EmfPlusObjectData> continuedObjectData) {
        }

        @Override
        public HemfPlusHeader.EmfPlusGraphicsVersion getGraphicsVersion() {
            return this.graphicsVersion;
        }

        @Override
        public HemfPlusObject.EmfPlusObjectType getGenericRecordType() {
            return HemfPlusObject.EmfPlusObjectType.REGION;
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties("graphicsVersion", this::getGraphicsVersion, "regionNode", () -> this.regionNode);
        }
    }

    public static enum EmfPlusRegionNodeDataType {
        AND(1, EmfPlusRegionNode::new),
        OR(2, EmfPlusRegionNode::new),
        XOR(3, EmfPlusRegionNode::new),
        EXCLUDE(4, EmfPlusRegionNode::new),
        COMPLEMENT(5, EmfPlusRegionNode::new),
        RECT(0x10000000, EmfPlusRegionRect::new),
        PATH(0x10000001, EmfPlusRegionPath::new),
        EMPTY(0x10000002, EmfPlusRegionEmpty::new),
        INFINITE(0x10000003, EmfPlusRegionInfinite::new);

        public final int id;
        public final Supplier<EmfPlusRegionNodeData> constructor;

        private EmfPlusRegionNodeDataType(int id, Supplier<EmfPlusRegionNodeData> constructor) {
            this.id = id;
            this.constructor = constructor;
        }

        public static EmfPlusRegionNodeDataType valueOf(int id) {
            for (EmfPlusRegionNodeDataType wrt : EmfPlusRegionNodeDataType.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }
    }
}

