/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.MissingSheetException;
import com.monitorjbl.xlsx.impl.StreamingSheet;
import com.monitorjbl.xlsx.impl.StreamingWorkbookReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.Workbook;

public class StreamingWorkbook
implements Workbook,
AutoCloseable {
    private final StreamingWorkbookReader reader;

    public StreamingWorkbook(StreamingWorkbookReader streamingWorkbookReader) {
        this.reader = streamingWorkbookReader;
    }

    int findSheetByName(String string) {
        for (int i = 0; i < this.reader.getSheetProperties().size(); ++i) {
            if (!this.reader.getSheetProperties().get(i).get("name").equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<Sheet> iterator() {
        return this.reader.iterator();
    }

    @Override
    public Iterator<Sheet> sheetIterator() {
        return this.iterator();
    }

    @Override
    public String getSheetName(int n) {
        return this.reader.getSheetProperties().get(n).get("name");
    }

    @Override
    public int getSheetIndex(String string) {
        return this.findSheetByName(string);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        if (sheet instanceof StreamingSheet) {
            return this.findSheetByName(sheet.getSheetName());
        }
        throw new UnsupportedOperationException("Cannot use non-StreamingSheet sheets");
    }

    @Override
    public int getNumberOfSheets() {
        return this.reader.getSheets().size();
    }

    @Override
    public Sheet getSheetAt(int n) {
        return this.reader.getSheets().get(n);
    }

    @Override
    public Sheet getSheet(String string) {
        int n = this.getSheetIndex(string);
        if (n == -1) {
            throw new MissingSheetException("Sheet '" + string + "' does not exist");
        }
        return this.reader.getSheets().get(n);
    }

    @Override
    public boolean isSheetHidden(int n) {
        return "hidden".equals(this.reader.getSheetProperties().get(n).get("state"));
    }

    @Override
    public boolean isSheetVeryHidden(int n) {
        return "veryHidden".equals(this.reader.getSheetProperties().get(n).get("state"));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int getActiveSheetIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setActiveSheet(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFirstVisibleTab() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFirstVisibleTab(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetOrder(String string, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedTab(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetName(int n, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet createSheet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet createSheet(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet cloneSheet(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSheetAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font createFont() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font findFont(boolean bl, short s, short s2, String string, boolean bl2, boolean bl3, short s3, byte by) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getNumberOfFonts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfFontsAsInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font getFontAt(short s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font getFontAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellStyle createCellStyle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumCellStyles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellStyle getCellStyleAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name getName(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends Name> getNames(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends Name> getAllNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name getNameAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name createName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNameIndex(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeName(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeName(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeName(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int linkExternalWorkbook(String string, Workbook workbook) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrintArea(int n, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrintArea(int n, int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrintArea(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePrintArea(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFormat createDataFormat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addPicture(byte[] byArray, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends PictureData> getAllPictures() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CreationHelper getCreationHelper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHidden(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetHidden(int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SheetVisibility getSheetVisibility(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetVisibility(int n, SheetVisibility sheetVisibility) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolPack(UDFFinder uDFFinder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setForceFormulaRecalculation(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpreadsheetVersion getSpreadsheetVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addOlePackage(byte[] byArray, String string, String string2, String string3) throws IOException {
        throw new UnsupportedOperationException();
    }
}

