/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.NotSupportedException;
import com.monitorjbl.xlsx.impl.StreamingCell;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class StreamingRow
implements Row {
    private int rowIndex;
    private boolean isHidden;
    private TreeMap<Integer, Cell> cellMap = new TreeMap();

    public StreamingRow(int n, boolean bl) {
        this.rowIndex = n;
        this.isHidden = bl;
    }

    public Map<Integer, Cell> getCellMap() {
        return this.cellMap;
    }

    public void setCellMap(TreeMap<Integer, Cell> treeMap) {
        this.cellMap = treeMap;
    }

    @Override
    public int getRowNum() {
        return this.rowIndex;
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return this.cellMap.values().iterator();
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cellMap.values().iterator();
    }

    @Override
    public Cell getCell(int n) {
        return this.cellMap.get(n);
    }

    @Override
    public short getLastCellNum() {
        return (short)(this.cellMap.size() == 0 ? -1 : this.cellMap.lastEntry().getValue().getColumnIndex() + 1);
    }

    @Override
    public boolean getZeroHeight() {
        return this.isHidden;
    }

    @Override
    public int getPhysicalNumberOfCells() {
        return this.cellMap.size();
    }

    @Override
    public short getFirstCellNum() {
        if (this.cellMap.size() == 0) {
            return -1;
        }
        return this.cellMap.firstKey().shortValue();
    }

    @Override
    public Cell getCell(int n, Row.MissingCellPolicy missingCellPolicy) {
        StreamingCell streamingCell = (StreamingCell)this.cellMap.get(n);
        if (missingCellPolicy == Row.MissingCellPolicy.CREATE_NULL_AS_BLANK) {
            if (streamingCell == null) {
                return new StreamingCell(n, this.rowIndex, false);
            }
        } else if (missingCellPolicy == Row.MissingCellPolicy.RETURN_BLANK_AS_NULL && (streamingCell == null || streamingCell.getCellTypeEnum() == CellType.BLANK)) {
            return null;
        }
        return streamingCell;
    }

    @Override
    public Cell createCell(int n) {
        throw new NotSupportedException();
    }

    @Override
    public Cell createCell(int n, CellType cellType) {
        throw new NotSupportedException();
    }

    @Override
    public void removeCell(Cell cell) {
        throw new NotSupportedException();
    }

    @Override
    public void setRowNum(int n) {
        throw new NotSupportedException();
    }

    @Override
    public void setHeight(short s) {
        throw new NotSupportedException();
    }

    @Override
    public void setZeroHeight(boolean bl) {
        throw new NotSupportedException();
    }

    @Override
    public void setHeightInPoints(float f) {
        throw new NotSupportedException();
    }

    @Override
    public short getHeight() {
        throw new NotSupportedException();
    }

    @Override
    public float getHeightInPoints() {
        throw new NotSupportedException();
    }

    @Override
    public boolean isFormatted() {
        throw new NotSupportedException();
    }

    @Override
    public CellStyle getRowStyle() {
        throw new NotSupportedException();
    }

    @Override
    public void setRowStyle(CellStyle cellStyle) {
        throw new NotSupportedException();
    }

    @Override
    public Sheet getSheet() {
        throw new NotSupportedException();
    }

    @Override
    public int getOutlineLevel() {
        throw new NotSupportedException();
    }

    @Override
    public void shiftCellsRight(int n, int n2, int n3) {
        throw new NotSupportedException();
    }

    @Override
    public void shiftCellsLeft(int n, int n2, int n3) {
        throw new NotSupportedException();
    }
}

