/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class PlasticXPIconFactory {
    private static CheckBoxIcon checkBoxIcon;
    private static RadioButtonIcon radioButtonIcon;

    private PlasticXPIconFactory() {
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    private static boolean isBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final Stroke FOCUS_STROKE = new BasicStroke(2.0f);

        private RadioButtonIcon() {
        }

        public int getIconWidth() {
            int n = UIManager.getInt("rRadioButton.size");
            if (n > 0) {
                return n;
            }
            return 15;
        }

        public int getIconHeight() {
            int n = UIManager.getInt("rRadioButton.size");
            if (n > 0) {
                return n;
            }
            return 15;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = 15;
            int n4 = UIManager.getInt("rRadioButton.size");
            if (n4 > 0) {
                n3 = n4;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = buttonModel.isArmed() && !buttonModel.isPressed() || abstractButton.hasFocus() && PlasticXPIconFactory.isBlank(abstractButton.getText());
            Object object = RenderingHints.VALUE_ANTIALIAS_ON;
            RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
            Object object2 = graphics2D.getRenderingHint(key);
            if (object != object2) {
                graphics2D.setRenderingHint(key, object);
            } else {
                object2 = null;
            }
            this.drawFill(graphics2D, buttonModel.isPressed(), n, n2, n3 - 1, n3 - 1);
            if (bl) {
                this.drawFocus(graphics2D, n + 1, n2 + 1, n3 - 3, n3 - 3);
            }
            if (buttonModel.isSelected()) {
                this.drawCheck(graphics2D, component, buttonModel.isEnabled(), n + 4, n2 + 4, n3 - 8, n3 - 8);
            }
            this.drawBorder(graphics2D, buttonModel.isEnabled(), n, n2, n3 - 1, n3 - 1);
            if (object2 != null) {
                graphics2D.setRenderingHint(key, object2);
            }
        }

        private void drawBorder(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4) {
            graphics2D.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlDisabled());
            graphics2D.drawOval(n, n2, n3, n4);
        }

        private void drawCheck(Graphics2D graphics2D, Component component, boolean bl, int n, int n2, int n3, int n4) {
            graphics2D.translate(n, n2);
            if (bl) {
                graphics2D.setColor(UIManager.getColor("RadioButton.check"));
                graphics2D.fillOval(0, 0, n3, n4);
                UIManager.getIcon("RadioButton.checkIcon").paintIcon(component, graphics2D, 0, 0);
            } else {
                graphics2D.setColor(MetalLookAndFeel.getControlDisabled());
                graphics2D.fillOval(0, 0, n3, n4);
            }
            graphics2D.translate(-n, -n2);
        }

        private void drawFill(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4) {
            Color color;
            ColorUIResource colorUIResource;
            if (bl) {
                colorUIResource = MetalLookAndFeel.getControlShadow();
                color = PlasticLookAndFeel.getControlHighlight();
            } else {
                colorUIResource = PlasticLookAndFeel.getControl();
                color = PlasticLookAndFeel.getControlHighlight().brighter();
            }
            graphics2D.setPaint(new GradientPaint(n, n2, colorUIResource, n + n3, n2 + n4, color));
            graphics2D.fillOval(n, n2, n3, n4);
        }

        private void drawFocus(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
            graphics2D.setPaint(new GradientPaint(n, n2, PlasticLookAndFeel.getFocusColor().brighter(), n3, n4, PlasticLookAndFeel.getFocusColor()));
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(FOCUS_STROKE);
            graphics2D.drawOval(n, n2, n3, n4);
            graphics2D.setStroke(stroke);
        }
    }

    private static final class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        public int getIconWidth() {
            int n = UIManager.getInt("rCheckBox.size");
            if (n > 0) {
                return n;
            }
            return 15;
        }

        public int getIconHeight() {
            int n = UIManager.getInt("rCheckBox.size");
            if (n > 0) {
                return n;
            }
            return 15;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = 15;
            int n4 = UIManager.getInt("rCheckBox.size");
            if (n4 > 0) {
                n3 = n4;
            }
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = buttonModel.isArmed() && !buttonModel.isPressed() || jCheckBox.hasFocus() && PlasticXPIconFactory.isBlank(jCheckBox.getText());
            Object object = RenderingHints.VALUE_ANTIALIAS_ON;
            RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
            Object object2 = graphics2D.getRenderingHint(key);
            if (object != object2) {
                graphics2D.setRenderingHint(key, object);
            } else {
                object2 = null;
            }
            this.drawBorder(graphics2D, buttonModel.isEnabled(), n, n2, n3 - 1, n3 - 1);
            this.drawFill(graphics2D, buttonModel.isPressed(), n + 1, n2 + 1, n3 - 2, n3 - 2);
            if (bl) {
                this.drawFocus(graphics2D, n + 1, n2 + 1, n3 - 3, n3 - 3);
            }
            if (buttonModel.isSelected()) {
                this.drawCheck(graphics2D, buttonModel.isEnabled(), n + 3, n2 + 3, n3 - 7, n3 - 7);
            }
            if (object2 != null) {
                graphics2D.setRenderingHint(key, object2);
            }
        }

        private void drawBorder(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4) {
            graphics2D.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlDisabled());
            graphics2D.drawRect(n, n2, n3, n4);
        }

        private void drawCheck(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4) {
            graphics2D.setColor(bl ? UIManager.getColor("CheckBox.check") : MetalLookAndFeel.getControlDisabled());
            int n5 = n + n3;
            int n6 = n2 + n4;
            int n7 = n2 + n4 / 3;
            int n8 = n + n3 / 2 - 2;
            graphics2D.drawLine(n, n7, n8, n6 - 3);
            graphics2D.drawLine(n, n7 + 1, n8, n6 - 2);
            graphics2D.drawLine(n, n7 + 2, n8, n6 - 1);
            graphics2D.drawLine(n8 + 1, n6 - 2, n5, n2);
            graphics2D.drawLine(n8 + 1, n6 - 1, n5, n2 + 1);
            graphics2D.drawLine(n8 + 1, n6, n5, n2 + 2);
        }

        private void drawFill(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4) {
            Color color;
            ColorUIResource colorUIResource;
            if (bl) {
                colorUIResource = MetalLookAndFeel.getControlShadow();
                color = PlasticLookAndFeel.getControlHighlight();
            } else {
                colorUIResource = PlasticLookAndFeel.getControl();
                color = PlasticLookAndFeel.getControlHighlight().brighter();
            }
            graphics2D.setPaint(new GradientPaint(n, n2, colorUIResource, n + n3, n2 + n4, color));
            graphics2D.fillRect(n, n2, n3, n4);
        }

        private void drawFocus(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
            graphics2D.setPaint(new GradientPaint(n, n2, PlasticLookAndFeel.getFocusColor().brighter(), n3, n4, PlasticLookAndFeel.getFocusColor()));
            graphics2D.drawRect(n, n2, n3, n4);
            graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        }
    }
}

