/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PlasticSpinnerUI
extends BasicSpinnerUI {
    private static final ExtBasicArrowButtonHandler nextButtonHandler = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler previousButtonHandler = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticSpinnerUI();
    }

    protected Component createPreviousButton() {
        return new SpinnerArrowButton(5, previousButtonHandler);
    }

    protected Component createNextButton() {
        return new SpinnerArrowButton(1, nextButtonHandler);
    }

    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        this.configureEditorBorder(jComponent);
        return jComponent;
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.configureEditorBorder(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void configureEditorBorder(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            jFormattedTextField.setBorder(new EmptyBorder(insets));
        } else if (jComponent instanceof JPanel && jComponent.getBorder() == null && jComponent.getComponentCount() > 0) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(0);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            jComponent2.setBorder(new EmptyBorder(insets));
        }
    }

    private static final class SpinnerArrowButton
    extends PlasticArrowButton {
        private SpinnerArrowButton(int n, ExtBasicArrowButtonHandler extBasicArrowButtonHandler) {
            super(n, UIManager.getInt("ScrollBar.width"), true);
            this.addActionListener(extBasicArrowButtonHandler);
            this.addMouseListener(extBasicArrowButtonHandler);
        }

        protected int calculateArrowHeight(int n, int n2) {
            int n3 = Math.min((n - 4) / 3, (n2 - 4) / 3);
            return Math.max(n3, 3);
        }

        protected int calculateArrowOffset() {
            return 1;
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }
    }
}

