/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.jose.jwk;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.proc.JWEKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.jose.jwk.AbstractJWKSelectorWithSource;
import com.nimbusds.oauth2.sdk.jose.jwk.JWKSource;
import com.nimbusds.oauth2.sdk.jose.jwk.KeyConverter;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@Deprecated
public class JWEDecryptionKeySelector
extends AbstractJWKSelectorWithSource
implements JWEKeySelector {
    private final JWEAlgorithm jweAlg;
    private final EncryptionMethod jweEnc;

    private static void ensureAsymmetricEncryptionAlgorithm(JWEAlgorithm jweAlg) {
        if (!JWEAlgorithm.Family.RSA.contains(jweAlg) && !JWEAlgorithm.Family.ECDH_ES.contains(jweAlg)) {
            throw new IllegalArgumentException("The JWE algorithm must be RSA or EC based");
        }
    }

    public JWEDecryptionKeySelector(Identifier id, JWEAlgorithm jweAlg, EncryptionMethod jweEnc, JWKSource jwkSource) {
        super(id, jwkSource);
        if (jweAlg == null) {
            throw new IllegalArgumentException("The JWE algorithm must not be null");
        }
        JWEDecryptionKeySelector.ensureAsymmetricEncryptionAlgorithm(jweAlg);
        this.jweAlg = jweAlg;
        if (jweEnc == null) {
            throw new IllegalArgumentException("The JWE encryption method must not be null");
        }
        this.jweEnc = jweEnc;
    }

    public JWEAlgorithm getExpectedJWEAlgorithm() {
        return this.jweAlg;
    }

    public EncryptionMethod getExpectedJWEEncryptionMethod() {
        return this.jweEnc;
    }

    protected JWKMatcher createJWKMatcher(JWEHeader jweHeader) {
        if (!this.getExpectedJWEAlgorithm().equals(jweHeader.getAlgorithm())) {
            return null;
        }
        if (!this.getExpectedJWEEncryptionMethod().equals(jweHeader.getEncryptionMethod())) {
            return null;
        }
        return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm(this.getExpectedJWEAlgorithm())).keyID(jweHeader.getKeyID()).keyUses(KeyUse.ENCRYPTION, null).algorithms(this.getExpectedJWEAlgorithm(), null).build();
    }

    public List<Key> selectJWEKeys(JWEHeader jweHeader, SecurityContext context) {
        if (!this.jweAlg.equals(jweHeader.getAlgorithm()) || !this.jweEnc.equals(jweHeader.getEncryptionMethod())) {
            return Collections.emptyList();
        }
        JWKMatcher jwkMatcher = this.createJWKMatcher(jweHeader);
        List<JWK> jwkMatches = this.getJWKSource().get(this.getIdentifier(), new JWKSelector(jwkMatcher));
        LinkedList<Key> sanitizedKeyList = new LinkedList<Key>();
        for (Key key : KeyConverter.toJavaKeys(jwkMatches)) {
            if (!(key instanceof PrivateKey)) continue;
            sanitizedKeyList.add(key);
        }
        return sanitizedKeyList;
    }
}

