/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.jose.util.Base64URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import net.jcip.annotations.Immutable;

@Immutable
public class Secret {
    public static final int DEFAULT_BYTE_LENGTH = 32;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private byte[] value;
    private final Date expDate;

    public Secret(String value) {
        this(value, null);
    }

    public Secret(String value, Date expDate) {
        this.value = value.getBytes(Charset.forName("utf-8"));
        this.expDate = expDate;
    }

    public Secret(int byteLength) {
        this(byteLength, null);
    }

    public Secret(int byteLength, Date expDate) {
        if (byteLength < 1) {
            throw new IllegalArgumentException("The byte length must be a positive integer");
        }
        byte[] n = new byte[byteLength];
        SECURE_RANDOM.nextBytes(n);
        this.value = Base64URL.encode(n).toString().getBytes(Charset.forName("UTF-8"));
        this.expDate = expDate;
    }

    public Secret() {
        this(32);
    }

    public String getValue() {
        if (this.value == null) {
            return null;
        }
        return new String(this.value, Charset.forName("utf-8"));
    }

    public byte[] getValueBytes() {
        return this.value;
    }

    public void erase() {
        if (this.value == null) {
            return;
        }
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
        this.value = null;
    }

    public Date getExpirationDate() {
        return this.expDate;
    }

    public boolean expired() {
        if (this.expDate == null) {
            return false;
        }
        Date now = new Date();
        return this.expDate.before(now);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Secret)) {
            return false;
        }
        Secret secret = (Secret)o;
        return Arrays.equals(this.value, secret.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

